/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef HUDELEMENT_H
#define HUDELEMENT_H

#include "Player.hpp"
#include "Enemy_Help.hpp"
#include "Bitmapfont.hpp"
#include <string>
#include <list>


enum HUDType {POLL_GRAFIK_HORZ, POLL_GRAFIK_VERT, POLL_TEXT, SET_TEXT, POLL_INFO};

/// \todo Kurze dokumentation


class AHUDElement
{
protected:
	int m_X, m_Y;
	int m_Width, m_Height;
	CPlayer* m_player;
public:
	void SetPosition(int X, int Y);
	void SetSize(int Width, int Height);
	int GetPosition_X()
		{return m_X;}
	int GetPosition_Y()
		{return m_Y;}
	int GetSize_Width()
		{return m_Width;}
	int GetSize_Height()
		{return m_Height;}
	virtual void draw() = 0;
};



class AHUDPoll : 
	public AHUDElement
{
protected:
	enum {FLOAT, INTEGER} m_ValueType;
	const float* m_fAktuell;
	const int* m_iAktuell;
	float m_maxValue;
public:
	void init(int maxValue, const int* aktuell);
	void init(float maxValue, const float* aktuell);
	virtual void initChild() = 0;
};



class CHUDPollGrafikHorz : 
	public AHUDPoll
{
private:
	sf::Sprite* m_Sprite;
public:
	void initChild();
	void draw();
	CHUDPollGrafikHorz(global_data_pointers data);
};

class CHUDPollGrafikVert : 
	public AHUDPoll
{
private:
	sf::Sprite* m_Sprite;
public:
	void initChild();
	void draw();
	CHUDPollGrafikVert(global_data_pointers data);
};

class AHUDSetGrafik :
	public AHUDElement
{
protected:
	enum {FLOAT, INTEGER} m_ValueType;
	float m_Aktuell;
	float m_Max;
public:
	float* init(float maxValue);
	virtual void initChild() = 0;

};



class CHUDPollText : 
	public AHUDElement
{
	CBitmapFont* m_bmFont;
	const std::string* m_Data;
	int m_fontsize;
	int m_textwidth;
public:
	CHUDPollText(CBitmapFont* bmFont, int fontsize, int textwidth)
		{m_bmFont = bmFont; m_fontsize = fontsize; m_textwidth = textwidth;}
	void init(const std::string* data);
	void draw();
};

class CHUDSetText :
	public AHUDElement
{
	CBitmapFont* m_bmFont;
	std::string m_Data;
	int m_fontsize;
public:
	CHUDSetText(CBitmapFont* bmFont, int fontsize)
		{m_bmFont = bmFont; m_fontsize = fontsize;}
	std::string* init()
		{return &m_Data;}
	void draw();
};

class CHUDInfo : 
	public AHUDElement
{
	int m_timer;
	CBitmapFont* m_bmFont;
	sf::Sprite* m_backg;
	sf::Sprite* m_image;
	global_data_pointers m_data;
	bool* p_show;

	std::list<SInfo*>* p_Infos;
public:
	CHUDInfo(global_data_pointers data, CBitmapFont* bmFont)
		{m_bmFont = bmFont; m_data = data; m_backg = NULL;} 
	void init(bool* show, std::list<SInfo*>* Infos);
	void draw();
};

#endif

