/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ENEMY_HELP_HPP
#define ENEMY_HELP_HPP

#include <list>

enum {LEICHT, MITTELLEICHT, DURCHSCNITTLICH, MITTELSCHWEHR, SCHWEHR, LEICHT_BOSS, MITTELLEICHT_BOSS, DURCHSCNITTLICH_BOSS, MITTELSCHWEHR_BOSS, SCHWEHR_BOSS};

struct global_data_pointers
{
};


struct projectileData
{
	int posx;
	int posy;
	int damage;
	int width;
};

struct AI_parameter
{
	int max_power;
	//konstante zum berechnen der gefahr aus der y - nähe zum projektil
	float dist_divisor;
	//gewicht der y - position des players zum berechnen der angestrebten richtung
	float player_weight; 
	//analyseweite nach links und rechts um die bewegungsrichtung zu bestimmern
	int searchdepth;
	//durchscnittliche angestrebte distanz
	int des_dist_base;
	//bereich der Zufallszahl (+ ? ->  - ?)
	int des_dist_var;
	//abweichungs Zufallszahlenbereich von der Ruheposition im Zentrum
	int des_x_var;
	//Gewichtung der Zentrumsnähe
	float des_x_heavy;
	//Zwangspause in der Mitte
	int pause;
	//kleinster Wert der zu einer x-Bewegung führt
	int sensibility_x;
	//kleinster Wert der zu einer x-Bewegung führt
	int sensibility_y;
	//multiplys für separation
	int sep_x_mult;
	int sep_y_mult;
	//Manhatan-Ziel
	int des_man;
};

struct bonus
{
	int id;
	int number;
};

struct strength
{
	int firedist;
	std::list<bonus*> boni;
};

struct SInfo
{
	SInfo(std::string f_content, std::string f_image, int f_time, int f_framecount, int f_frameofset)
		{image = f_image; content = f_content; time = f_time; frameofset = f_frameofset; framecount = f_framecount;} 
	std::string image;
	std::string content;
	int time;
	int framecount;
	int frameofset;
};

#endif
