/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007,2008  Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "EnemyManager.hpp"
#include "Singletons.hpp"

#include <boost/format.hpp>
#include <libintl.h>
#define _(string) gettext(string)

bool CEnemyManager::init(std::string filename_waves,
						 std::string filename_parameter,
						 global_data_pointers data, /// \todo to be removed
						 CPlayer *playership,
						 bool* play_Info,
						 std::list<SInfo*>* Infos)
{
	errorCode error = SUCCESS;

	m_Data = data;

	p_blend = play_Info;

	p_Infos = Infos;

	player = playership;


	m_activeWave = 0;

	error = readParameter(filename_parameter);

	switch (error)
	{
		case FAILED_OPEN:
			LOG4CXX_ERROR(log_, boost::format(_("Error while opening File %1%!")) % filename_parameter);
			break;
		case WRONG_SYNTAX:
			LOG4CXX_ERROR(log_, boost::format(_("invalid Syntax in File %1%!")) % filename_parameter);
			break;
		case MISSING_ATTRIBUTE:
			LOG4CXX_ERROR(log_, boost::format(_("Missing Attributes in File %1%!")) % filename_parameter);
			break;
	}
	
	if (!parameter)
		LOG4CXX_ERROR(log_, boost::format(_("No <paramter> Block in Parameter File %1%!")) % filename_parameter);

	if (parameter->max_power == 0) parameter->max_power = 4;

	error = readFile(filename_waves);

	switch (error)
	{
		case FAILED_OPEN:
			LOG4CXX_ERROR(log_, boost::format(_("Error while opening File %1%!")) % filename_waves);
			break;
		case WRONG_SYNTAX:
			LOG4CXX_ERROR(log_, boost::format(_("invalid Syntax in File %1%!")) % filename_waves);
			break;
		case MISSING_ATTRIBUTE:
			LOG4CXX_ERROR(log_, boost::format(_("Missing Attributes in File %1%!")) % filename_waves);
			break;
	}

	m_NextToEvaluate_Enemy = m_ActiveEnemys.end();
	m_NextToEvaluate_Ally = m_ActiveAllys.begin();

	m_no_fight.sort(less_S_no_fight());

	return (error == SUCCESS);
}

bool CEnemyManager::reset()
{
	player = NULL;
	m_activePower = 0;

	std::list<ANPC*>::iterator clear_Iterator = m_ActiveEnemys.begin();


	//Löschen der Enemys
	while (clear_Iterator != m_ActiveEnemys.end())
	{
		if ((*clear_Iterator)) delete (*clear_Iterator);

		m_ActiveEnemys.erase(clear_Iterator++);
	}

	clear_Iterator = m_PassiveEnemys.begin();

	while (clear_Iterator != m_PassiveEnemys.end())
	{
		if ((*clear_Iterator)) delete (*clear_Iterator);

		m_PassiveEnemys.erase(clear_Iterator++);
	}

	//Löschen der Allys
	clear_Iterator = m_ActiveAllys.begin();

	while (clear_Iterator != m_ActiveAllys.end())
	{
		if ((*clear_Iterator)) delete (*clear_Iterator);
		m_ActiveAllys.erase(clear_Iterator++);
	}

	clear_Iterator = m_PassiveAllys.begin();

	while (clear_Iterator != m_PassiveAllys.end())
	{
		if ((*clear_Iterator)) delete (*clear_Iterator);

		m_PassiveAllys.erase(clear_Iterator++);
	}

	//Löschen der Neuralen
	std::list<S_no_fight>::iterator clear_IteratorII = m_no_fight.begin();

	while (clear_IteratorII != m_no_fight.end())
	{
		m_no_fight.erase(clear_IteratorII++);
	}

	return true;
}

errorCode CEnemyManager::readParameter(std::string filename)
{

	AI_parameter* tmp;

	float tmp_float;
	int tmp_int;

	std::string Tag;
	std::string Data;
	std::string Buffer;

	char buffer[255];

	FILE* theFile = std::fopen(filename.c_str(),"r");
	if(theFile == NULL)
	{
		return FAILED_OPEN;
	}

	while(std::feof(theFile) == 0)
	{
		std::fscanf(theFile, "%s", buffer);

		Buffer = buffer;

		if (Buffer == "<parameter>")
		{
			tmp = new AI_parameter;
			tmp->sep_x_mult = 50;
			tmp->sep_y_mult = 50;
			tmp->des_man = 1000;
			while (std::fscanf(theFile, "%s", buffer))
			{
				Buffer = buffer;
						
				if (Buffer == "</parameter>") break;

				if (Buffer == "<dist_divisor>")
				{
					tmp_float = 0;
					std::fscanf(theFile, "%f", &tmp_float);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</dist_divisor>")
					{
						return WRONG_SYNTAX;
					}
					tmp->dist_divisor = tmp_float;
				}

				else if (Buffer == "<max_enemy>")
				{
					tmp_int = 4;
					std::fscanf(theFile, "%d", &tmp_int);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</max_enemy>") 
					{
						return WRONG_SYNTAX;
					}
					if (tmp_int == 0) tmp_int = 128;
					tmp->max_power = tmp_int;
				}

				else if (Buffer == "<player_weight>")
				{
					tmp_float = 0;
					std::fscanf(theFile, "%f", &tmp_float);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</player_weight>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->player_weight = tmp_float;
				}

				else if (Buffer == "<searchdepth>")
				{
					tmp_int = 0;
					std::fscanf(theFile, "%d", &tmp_int);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</searchdepth>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->searchdepth = tmp_int;
				}

				else if (Buffer == "<des_dist_base>")
				{
					tmp_int = 0;
					std::fscanf(theFile, "%d", &tmp_int);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</des_dist_base>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->des_dist_base = tmp_int;
				}

				else if (Buffer == "<des_dist_var>")
				{
					tmp_int = 0;
					std::fscanf(theFile, "%d", &tmp_int);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</des_dist_var>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->des_dist_var = tmp_int;
				}

				else if (Buffer == "<des_x_var>")
				{
					tmp_int = 0;
					std::fscanf(theFile, "%d", &tmp_int);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</des_x_var>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->des_x_var = tmp_int;
				}

				else if (Buffer == "<pause>")
				{
					tmp_int = 0;
					std::fscanf(theFile, "%d", &tmp_int);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</pause>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->pause = tmp_int;
				}

				else if (Buffer == "<sensibility_x>")
				{
					tmp_int = 0;
					std::fscanf(theFile, "%d", &tmp_int);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</sensibility_x>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->sensibility_x = tmp_int;
				}

				else if (Buffer == "<sensibility_y>")
				{
					tmp_int = 0;
					std::fscanf(theFile, "%d", &tmp_int);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</sensibility_y>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->sensibility_y = tmp_int;
				}

				else if (Buffer == "<des_x_heavy>")
				{
					tmp_float = 0;
					std::fscanf(theFile, "%f", &tmp_float);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					
					if (Tag != "</des_x_heavy>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->des_x_heavy = tmp_float;
				}

				else if (Buffer == "<sep_x_mult>")
				{
					tmp_int = 0;
					std::fscanf(theFile, "%d", &tmp_int);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</sep_x_mult>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->sep_x_mult = tmp_int;
				}

				else if (Buffer == "<sep_y_mult>")
				{
					tmp_int = 0;
					std::fscanf(theFile, "%d", &tmp_int);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</sep_y_mult>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->sep_y_mult = tmp_int;
				}

				else if (Buffer == "<des_man>")
				{
					tmp_int = 0;
					std::fscanf(theFile, "%d", &tmp_int);
					std::fscanf(theFile, "%s", buffer);
					Tag = buffer;
					if (Tag != "</des_man>") 
					{
						return WRONG_SYNTAX;
					}
					tmp->des_man = tmp_int;
				}


				else if (Buffer == "<!--")
				{
					do
					{
						std::fscanf(theFile, "%s", buffer);
						Buffer = buffer;
					}
					while(Buffer != "-->");							
				}
				parameter = tmp;
			}
					
			if (Buffer != "</parameter>")
			{
				return WRONG_SYNTAX;
			}		
		}
		else if (Buffer == "<!--")
		{
			do
			{
				std::fscanf(theFile, "%s", buffer);
				Buffer = buffer;
			}
			while(Buffer != "-->");
		}
		else if (Buffer == "<strength>")
		{
			while (std::fscanf(theFile, "%s", buffer))
			{
				Buffer = buffer;
						
				if (Buffer == "</strength>") break;

				if (Buffer == "<default>")
				{
					while (std::fscanf(theFile, "%s", buffer))
					{
						Buffer = buffer;

						int i;
						bonus *tmp;
						tmp = new bonus;

						if (Buffer == "</default>") break;

						else if (Buffer == "<firedist>")
						{
							std::fscanf(theFile, "%d", &m_strength[0].firedist);
							for (i = 1; i < 10; i++)
								m_strength[i].firedist = m_strength[0].firedist;

							std::fscanf(theFile, "%s", buffer);
							Buffer = buffer;

							if (Buffer != "</firedist>") return WRONG_SYNTAX;
						}
						else if (Buffer == "<bonus")
						{
							std::fscanf(theFile, "%s", buffer);
							std::sscanf(buffer, "id=\"%d\">", &tmp->id);
							std::fscanf(theFile, "%d", &tmp->number);
							for (i = 0; i < 10; i++)
								m_strength[i].boni.push_back(new bonus(*tmp));

							std::fscanf(theFile, "%s", buffer);
							Buffer = buffer;
							if (Buffer != "</bonus>") return WRONG_SYNTAX;
						}
					}
				}
				else if (Buffer == "<enemy")
				{
					int enemy = 0;

					std::fscanf(theFile, "%s", buffer);
					std::sscanf(buffer, "str=\"%d\">", &enemy);
					(enemy < 50) ? enemy -= 1 : enemy -= 96;

					std::list<bonus*>::iterator clIt = m_strength[enemy].boni.begin();

					while (clIt != m_strength[enemy].boni.end())
					{
						delete *clIt;
						m_strength[enemy].boni.erase(clIt++);
					}


					while (std::fscanf(theFile, "%s", buffer))
					{
						bonus *tmp;
						tmp = new bonus;
						Buffer = buffer;

						if (Buffer == "</enemy>") break;

						else if (Buffer == "<firedist>")
						{
							std::fscanf(theFile, "%d", &m_strength[enemy].firedist);

							std::fscanf(theFile, "%s", buffer);
							Buffer = buffer;

							if (Buffer != "</firedist>") return WRONG_SYNTAX;
						}
						else if (Buffer == "<bonus")
						{
							std::fscanf(theFile, "%s", buffer);
							std::sscanf(buffer, "id=\"%d\">", &tmp->id);
							std::fscanf(theFile, "%d", &tmp->number);
							std::fscanf(theFile, "%s", buffer);
							m_strength[enemy].boni.push_back(tmp);
							Buffer = buffer;
							if (Buffer != "</bonus>") return WRONG_SYNTAX;
						}
					}
				}

			}
		}
		else if (Buffer == "</parameter>")
		{
#ifndef NO_DEBUG
			m_Console->printString("CEnemyManager::readParameter:\nÜberzähliges </parameter>\n");
#endif
		}
		else if (Buffer == "</strength>")
		{
#ifndef NO_DEBUG
			m_Console->printString("CEnemyManager::readParameter:\nÜberzähliges </parameter>\n");
#endif
		}
		else
		{
			return WRONG_SYNTAX;
		}
	}
	fclose(theFile);
	return SUCCESS;
}



errorCode CEnemyManager::readFile(std::string filename)
{

	//DebugVariablen
	int waves = 0;
	int ships = 0;


	char buffer[255];
	
	std::string Tag;
	std::string Data;
	std::string Buffer;

	int posx, posy;
	std::string shipfile;
	std::string powerupfile;
	CEnemy::Strength theStrength;
	unsigned starttime = 0;

	S_no_fight nfTmp;

	FILE* theFile = std::fopen(filename.c_str(),"r");
	if(theFile == NULL)
	{
		return FAILED_OPEN;
	}

	while(feof(theFile) == 0)
	{
		std::fscanf(theFile, "%s", buffer);

		Buffer = buffer;

		if (Buffer == "<wave")
		{
			std::fscanf(theFile, "%s", buffer);
			Buffer = buffer;
			if (Buffer.find("time=\"") == 0)
			{
				if (Buffer.length() < 8) return UNEXPECTED_ENDING;
				std::sscanf(Buffer.c_str(), "time=\"%d\"", &starttime);

				if (Buffer[Buffer.length() - 1] != '>')
				{
					std::fscanf(theFile, "%s", buffer);
					Buffer = buffer;
					if (Buffer.find("neutral=\"") == 0)
					{
						if (Buffer.length() < 11) return UNEXPECTED_ENDING;
						std::sscanf(Buffer.c_str(), "neutral=\"%d\"", &nfTmp.end);

						nfTmp.end *= 1000;
						nfTmp.begin = starttime * 1000/* - 5*/;
						m_no_fight.push_back(nfTmp);
					}
					else return WRONG_SYNTAX;
				}
			}
			else if (Buffer.find("neutral=\"") == 0)
			{
				if (Buffer.length() < 11) return UNEXPECTED_ENDING;
				std::sscanf(Buffer.c_str(), "neutral=\"%d\"", &nfTmp.end);

				nfTmp.end *= 1000;

				std::fscanf(theFile, "%s", buffer);
				Buffer = buffer;
				if (Buffer.find("time=\"") == 0)
				{
					if (Buffer.length() < 8) return UNEXPECTED_ENDING;
					std::sscanf(Buffer.c_str(), "time=\"%d\"", &nfTmp.begin);
					nfTmp.begin *= 1000;

					m_no_fight.push_back(nfTmp);
				}
				else return WRONG_SYNTAX;
			}
			else return WRONG_SYNTAX;
			if(starttime > 0)
			{
				while(std::feof(theFile) == 0)
				{
					std::fscanf(theFile, "%s", buffer);
					Buffer = buffer;
					while (Buffer == "<enemy>" || Buffer == "<!--" || Buffer == "<ally>" || Buffer == "<info>")
					{
						if (Buffer == "<!--")
						{
							do
							{
								std::fscanf(theFile, "%s", buffer);
								Buffer = buffer;
							}
							while(Buffer != "-->");
						}
						else if (Buffer == "<enemy>")
						{
							shipfile = "data/ships/Bummer.txt";
							theStrength = CEnemy::EMPTY;
							posx = 0;
							posy = 1;
							powerupfile = "";
							while (std::fscanf(theFile, "%s", buffer))
							{
								Buffer = buffer;
								
								if (Buffer == "</enemy>") break;
	
								if (Buffer == "<strength>")
								{
									std::fscanf(theFile, "%d", &theStrength);
									std::fscanf(theFile, "%s", buffer);
									Tag = buffer;
									if (Tag != "</strength>")
									{
										return WRONG_SYNTAX;
									}
								}
								else if (Buffer == "<posx>")
								{
									std::fscanf(theFile, "%d", &posx);
									std::fscanf(theFile, "%s", buffer);
									Tag = buffer;
									if (Tag != "</posx>") 
									{
										return WRONG_SYNTAX;
									}
								}
								else if (Buffer == "<posy>")
								{
									std::fscanf(theFile, "%d", &posy);
									std::fscanf(theFile, "%s", buffer);
									Tag = buffer;
									if (Tag != "</posy>") 
									{
										return WRONG_SYNTAX;
									}
								}
								else if (Buffer == "<shiptype>")
								{
									std::fscanf(theFile, "%s", buffer);
									shipfile = buffer;
									std::fscanf(theFile, "%s", buffer);
									Tag = buffer;
									if (Tag != "</shiptype>") 
									{	
										return WRONG_SYNTAX;
									}
								}
								else if (Buffer == "<powerup>")
								{
									std::fscanf(theFile, "%s", buffer);
									powerupfile = buffer;
									std::fscanf(theFile, "%s", buffer);
									Tag = buffer;
									if (Tag != "</powerup>") 
									{
										return WRONG_SYNTAX;
									}
								}
								else if (Buffer == "<!--")
								{
									do
									{
										std::fscanf(theFile, "%s", buffer);
										Buffer = buffer;
									}
									while(Buffer != "-->");
								}							
							}
							if (posx && posy && (theStrength != CEnemy::EMPTY) && (shipfile != ""))
							{
								m_PassiveEnemys.push_back(new CEnemy(starttime, posx, posy, theStrength, shipfile, powerupfile, parameter));
							}
							else
							{
								return MISSING_ATTRIBUTE;
							}
							ships++;						
						}
						else if (Buffer == "<ally>")
						{
							shipfile = "data/ships/Bummer.txt";
							theStrength = CEnemy::EMPTY;
							posx = 0;
							posy = 1;
							powerupfile = "";
							while (std::fscanf(theFile, "%s", buffer))
							{
								Buffer = buffer;
								
								if (Buffer == "</ally>") break;
	
								if (Buffer == "<strength>")
								{
									std::fscanf(theFile, "%d", &theStrength);
									std::fscanf(theFile, "%s", buffer);
									Tag = buffer;
									if (Tag != "</strength>")
									{
										std::printf ("strength\n");
										return WRONG_SYNTAX;
									}									
								}
								else if (Buffer == "<posx>")
								{
									std::fscanf(theFile, "%d", &posx);
									std::fscanf(theFile, "%s", buffer);
									Tag = buffer;
									if (Tag != "</posx>") 
									{
										std::printf ("posx\n");
										return WRONG_SYNTAX;
									}
								}
								else if (Buffer == "<posy>")
								{
									std::fscanf(theFile, "%d", &posy);
									std::fscanf(theFile, "%s", buffer);
									Tag = buffer;
									if (Tag != "</posy>") 
									{
										std::printf ("posy\n");
										return WRONG_SYNTAX;
									}
								}
								else if (Buffer == "<shiptype>")
								{
									std::fscanf(theFile, "%s", buffer);
									shipfile = buffer;
									std::fscanf(theFile, "%s", buffer);
									Tag = buffer;
									if (Tag != "</shiptype>") 
									{	
										std::printf ("shiptype\n");
										return WRONG_SYNTAX;
									}
								}
								else if (Buffer == "<!--")
								{
									do
									{
										std::fscanf(theFile, "%s", buffer);
										Buffer = buffer;
									}
									while(Buffer != "-->");
								}							
							}
							if (posx && posy && (theStrength != CEnemy::EMPTY) && (shipfile != ""))
							{
								CAlly* tmp = new CAlly(starttime, posx, posy, theStrength, shipfile, parameter);
								m_PassiveAllys.push_back(tmp);
							}
							else
							{
								return MISSING_ATTRIBUTE;
							}
							ships++;						
						}
						else if (Buffer == "<info>")
						{
							std::string content;
							std::string image;
							int framecount = 4, frameofset = 4;
							char buffer[255];
							while (!feof(theFile))
							{	
								std::fscanf(theFile, "%s", buffer);
								Buffer = buffer;
		
								if (Buffer == "</info>") break;
							
								if (Buffer == "<content>")
								{
									while (!feof(theFile))
									{
			
										std::fscanf(theFile, "%s", buffer);
										Buffer = buffer;
		
										if (Buffer == "</content>") break;
	
										content += " " + Buffer;
									}
								}
								else if (Buffer == "<image>")
								{
									while (!feof(theFile))
									{							
										std::fscanf(theFile, "%s", buffer);
										Buffer = buffer;
		
										if (Buffer == "</image>") break;
		
										if (Buffer == "<file>")
										{
											std::fscanf(theFile, "%s", buffer);
											image = buffer;	
											std::fscanf(theFile, "%s", buffer);
											Buffer = buffer;
											if (Buffer != "</file>") return WRONG_SYNTAX;
										}
										else if (Buffer == "<framecount>")
										{
											std::fscanf(theFile, "%d", &framecount);
											std::fscanf(theFile, "%s", buffer);
											Buffer = buffer;
											if (Buffer != "</framecount>") return WRONG_SYNTAX;
										}	
										else if (Buffer == "<frameofset>")
										{
											std::fscanf(theFile, "%d", &frameofset);
											std::fscanf(theFile, "%s", buffer);
											Buffer = buffer;
											if (Buffer != "</frameofset>") return WRONG_SYNTAX;
										}
										else if (Buffer == "<!--")
										{
											do
											{
												std::fscanf(theFile, "%s", buffer);
												Buffer = buffer;
											}
											while(Buffer != "-->");
										}
										else return WRONG_SYNTAX;
									}
	
								}
								else if (Buffer == "<!--")
								{
									do
									{
										std::fscanf(theFile, "%s", buffer);
										Buffer = buffer;
									}
									while(Buffer != "-->");
								}
								else return WRONG_SYNTAX;
							}
							if ( image == "") image = "data/gfx/statik.png"; 
							m_Infos.push_back(new SInfo(content, image, starttime, framecount, frameofset));
						}
						
						std::fscanf(theFile, "%s", buffer);
						Buffer = buffer;
					}
					if (Buffer == "</wave>")
					{
						break;
					}
					else
					{
						std::cout << Buffer << std::endl;
						return WRONG_SYNTAX;
					}
				}
			}
			else
			{
				return WRONG_SYNTAX;
			}
			waves++;
		}
		
		else if (Buffer == "<!--")
		{
			do
			{
				std::fscanf(theFile, "%s", buffer);
				Buffer = buffer;
			}
			while(Buffer != "-->");
		}
		else if (Buffer == "</wave>")
		{
			/// \todo should really be TRACE
			LOG4CXX_DEBUG(log_, _("CEnemyManager::readFile:\nÜberzähliges </wave>\n"));
		}
		else
		{
			return WRONG_SYNTAX;
		}
	}
	fclose(theFile);

	return SUCCESS;
}






bool CEnemyManager::update()
{
	unsigned time = sgl::get_clock().GetElapsedTime();

	bool fight;

	std::list<S_no_fight>::iterator S_n_f_i = m_no_fight.begin();
	while (S_n_f_i != m_no_fight.end() && S_n_f_i->end < m_activeWave)
	{
		m_no_fight.erase(S_n_f_i++);
	}

	if (m_no_fight.size())
	{
		fight = (m_no_fight.begin()->begin >= m_activeWave);
	}
	else
	{
		fight = true;
	}

	std::list<ANPC*>::iterator enemyIterator;

	if ((m_activePower == 0 || !fight) && *p_blend == false)
	{
		
		if (m_Infos.size() > 0)
		{
			if(m_PassiveEnemys.size())
			{
				int earliest =  time;
				enemyIterator = m_PassiveEnemys.begin();
				while(true)
				{
					if ((*enemyIterator)->getStarttime() < m_activeWave)
					{
						break;
					}
					else
					{
						if ((*enemyIterator)->getStarttime() < earliest) earliest = (*enemyIterator)->getStarttime();
						enemyIterator++;
					}
					if(enemyIterator == m_PassiveEnemys.end())
					{
						m_activeWave = earliest + 1;
						break;
					}
				}
			}
			else
			{
				m_activeWave = time;
			}

			std::list<SInfo*>::iterator tmp = m_Infos.begin();
			
		
			while(tmp != m_Infos.end() && (*tmp)->time < m_activeWave)
			{
				tmp++;
			}
			if (tmp != ++(m_Infos.end()) && tmp != m_Infos.begin())
			{
				p_Infos->splice(p_Infos->begin(), m_Infos, m_Infos.begin(), tmp);
				*p_blend = true;
			}
			else
			{
				
			}
		}
		else
		{
			if (m_PassiveEnemys.size())
			{
				int earliest =  time;
				enemyIterator = m_PassiveEnemys.begin();
				while(true)
				{
					if ((*enemyIterator)->getStarttime() < m_activeWave)
					{
						break;
					}
					else
					{
						if ((*enemyIterator)->getStarttime() < earliest) earliest = (*enemyIterator)->getStarttime();
						enemyIterator++;
					}
					if(enemyIterator == m_PassiveEnemys.end())
					{
						m_activeWave = earliest + 1;
						break;
					}
				}
			}
			else
			{
				m_activeWave = time;
			}
		}
	}

	//Falls zulässig werden passive Gegner aktiviert
	if (!(*p_blend) && m_activePower < parameter->max_power)
	{
		enemyIterator = m_PassiveEnemys.begin();
		while(enemyIterator != m_PassiveEnemys.end())
		{
			int power;
			if ((*enemyIterator)->getStarttime() < m_activeWave && (power = (*enemyIterator)->getPower()) <= (parameter->max_power - m_activePower))
			{
				((CEnemy*)(*enemyIterator))->init(m_Data, player, getStrength((*enemyIterator)->getStrength()));
				m_activePower += power;
				m_ActiveEnemys.splice(m_ActiveEnemys.begin(), m_PassiveEnemys, enemyIterator++);
			}
			else
			{
				enemyIterator++;
			}
		}
	}

	//Falls zulässig werden passive Allys aktiviert
	enemyIterator = m_PassiveAllys.begin();
	while(!(*p_blend) && enemyIterator != m_PassiveAllys.end())
	{
		if ((*enemyIterator)->getStarttime() < m_activeWave)
		{
			((CAlly*)(*enemyIterator))->init(m_Data, getStrength((*enemyIterator)->getStrength()));
			m_ActiveAllys.splice(m_ActiveAllys.begin(), m_PassiveAllys, enemyIterator++);
		}
		else
		{
			enemyIterator++;
		}
	}

	
	std::list<ANPC*>::iterator col_test;
	//Aktive Gegner werden bewegt und Gezeichnet
	enemyIterator = m_ActiveEnemys.begin();


	while(enemyIterator != m_ActiveEnemys.end())
	{
		fight ? (*enemyIterator)->update(m_owned_ally) : (*enemyIterator)->update(m_bs_empty);

		(*enemyIterator)->Draw();
		if(fight)
		{
			(*enemyIterator)->getShip()->CheckCollision(player->GetShip());
			player->CheckCollision((*enemyIterator)->getShip());
		}

		col_test = m_ActiveAllys.begin();
		if(fight)
		{
			while (col_test != m_ActiveAllys.end())
			{
					(*col_test)->getShip()->CheckCollision((*enemyIterator)->getShip());
					(*enemyIterator)->getShip()->CheckCollision((*col_test)->getShip());
					col_test++;
			}
		}

		

		if ((*enemyIterator)->getShip()->CanBeRemoved())
		{
			if (m_NextToEvaluate_Enemy == enemyIterator)
				m_NextToEvaluate_Enemy++;
			if (((CEnemy*)(*enemyIterator))->getPowerUp() != "")
			{
				CPowerUp* tmp_powerup = new CPowerUp();
				tmp_powerup->Init(((CEnemy*)(*enemyIterator))->getPowerUp());
				tmp_powerup->SetPosition((*enemyIterator)->getShip()->GetXPosition(), (*enemyIterator)->getShip()->GetYPosition());
			
				m_PowerUps.push_back(tmp_powerup);
			}
			m_activePower -= (*enemyIterator)->getPower();
			delete *enemyIterator;
			m_ActiveEnemys.erase(enemyIterator++);
		}
		else
		{
			enemyIterator++;
		}
	}
	//Aktive Verbündete werden Bewegt und gezeichnet
	enemyIterator = m_ActiveAllys.begin();

	while(enemyIterator != m_ActiveAllys.end())
	{
		fight ? (*enemyIterator)->update(m_owned_enemy) : (*enemyIterator)->update(m_bs_empty);

		(*enemyIterator)->Draw();

		
		col_test = m_ActiveEnemys.begin();
		if (fight)
		{
			while (col_test != m_ActiveEnemys.end())
			{
				(*col_test)->getShip()->CheckCollision((*enemyIterator)->getShip());
				(*enemyIterator)->getShip()->CheckCollision((*col_test)->getShip());
				col_test++;
			}
		}


		if ((*enemyIterator)->getShip()->CanBeRemoved())
		{
			if (m_NextToEvaluate_Ally == enemyIterator)
				m_NextToEvaluate_Ally++;
			
			delete *enemyIterator;
			m_ActiveAllys.erase(enemyIterator++);
		}
		else
		{
			enemyIterator++;
		}
	}


	if (m_ActiveEnemys.size())
	{
		if (m_NextToEvaluate_Enemy == m_ActiveEnemys.end())
		{
			m_regProjectiles_Ally.clear();
			registerProjectiles(m_ActiveAllys, m_regProjectiles_Ally);
			registerProjectiles();
			m_owned_ally.reset();
			update_owned(m_ActiveAllys, m_owned_ally);
			update_owned();
			m_NextToEvaluate_Enemy = m_ActiveEnemys.begin();
		}
		else
		{
			(*m_NextToEvaluate_Enemy++)->calculate(m_fancy, m_regProjectiles_Ally, m_ActiveAllys, m_ActiveEnemys);
		}
	}
	if (m_ActiveAllys.size())
	{
		if (m_NextToEvaluate_Ally == m_ActiveAllys.end())
		{
			m_regProjectiles_Enemy.clear();
			registerProjectiles(m_ActiveEnemys, m_regProjectiles_Enemy);

			m_owned_enemy.reset();
			update_owned(m_ActiveEnemys, m_owned_enemy);

			m_NextToEvaluate_Ally = m_ActiveAllys.begin();
		}
		else
		{
			(*m_NextToEvaluate_Ally++)->calculate(m_fancy, m_regProjectiles_Enemy, m_ActiveEnemys, m_ActiveAllys);
		}
	}

	std::list<CPowerUp*>::iterator powerupIterator = m_PowerUps.begin();
	while(powerupIterator != m_PowerUps.end())
	{
		(*powerupIterator)->Update();
		(*powerupIterator)->Draw();
		if(player->CheckCollision(*powerupIterator))
		{
			delete *powerupIterator;
			m_PowerUps.erase(powerupIterator++);
		}
		else
		{
			powerupIterator++;
		}
	}
	return true;
}

void CEnemyManager::registerProjectiles()
{
	int i;
	projectileData tmp;

	m_regProjectiles_Ally.clear();

	for (i = 0; i < player->GetProjectilCount(); i++)
	{
		tmp.posx = player->GetProjectilX(i);
		tmp.posy = player->GetProjectilY(i);
		tmp.damage = player->GetProjectilDamage(i);
		tmp.width = player->GetProjectilWidth(i);
		m_regProjectiles_Ally.push_back(tmp);
	}
}

void CEnemyManager::registerProjectiles(std::list<ANPC*>& source, std::list<projectileData>& dest)
{
	int i;
	projectileData tmpD;

	dest.clear();

	std::list<ANPC*>::iterator tmp = source.begin();
	while (tmp != source.end())
	{
		for (i = 0; i < (*tmp)->getShip()->GetProjectilCount(); i++)
		{
			tmpD.posx = (*tmp)->getShip()->GetProjectilXPosition(i);
			tmpD.posy = (*tmp)->getShip()->GetProjectilYPosition(i);
			tmpD.damage = (*tmp)->getShip()->GetProjectilDamage(i);
			tmpD.width = (*tmp)->getShip()->GetProjectilWidth(i);
			dest.push_back(tmpD);
		}
		tmp++;
	}
}

void CEnemyManager::update_owned(std::list<ANPC*>& source, std::bitset<(SCREEN_X_SIZE - HUD_SIZE_X)>& dest)
{
	std::list<ANPC*>::iterator tmp = source.begin();
	while (tmp != source.end())
	{
		for (int i = (*tmp)->getShip()->GetXPosition() - (*tmp)->getShip()->GetCollisionSystemWidth()/2;
					i < (*tmp)->getShip()->GetXPosition() + (*tmp)->getShip()->GetCollisionSystemWidth()/2;
					i++)
		{
			if (i > -1 && i < 800)
				dest.set(i);
		}
		tmp++;
	}
}

void CEnemyManager::update_owned()
{
	for (int i = player->GetShip()->GetXPosition() - player->GetShip()->GetCollisionSystemWidth()/2;
				i < player->GetShip()->GetXPosition() + player->GetShip()->GetCollisionSystemWidth()/2;
				i++)
	{
		if (i > -1 && i < (SCREEN_X_SIZE - HUD_SIZE_X))
		{
			m_owned_ally.set(i);
		}
	}
}

strength* CEnemyManager::getStrength(int level)
{
	strength * tmp;
	if (level > 105 || level < 1)
	{
		LOG4CXX_ERROR(log_, _("BAD Value!"));
		return NULL;
	}
	else
	{
		int ttp = (level < 50) ? (level - 1) : (level-96);
		tmp = &m_strength[ttp];
		
		if (tmp == NULL)
		{
			LOG4CXX_ERROR(log_, _("BAD Data"));
		}
		return tmp;
	}
}

int CEnemyManager::clearPowerups()
{
	int i = 0;
	std::list<CPowerUp*>::iterator IT = m_PowerUps.begin();
	while (IT != m_PowerUps.end())
	{
		i++;
		delete (*IT);
		m_PowerUps.erase(IT++);
	}
	return i;
}
