/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "CollisionSystem.hpp"
#include <cstdio>


CCollisionSystem::CCollisionSystem()
{}

CCollisionSystem::~CCollisionSystem()
{
	for(std::size_t CurCircle = 0; CurCircle < m_Circles.size(); CurCircle++)
	{
		delete m_Circles[CurCircle];
	}
}

void CCollisionSystem::Init(std::string FileName)
{
	char strBuf[100];

	float X;
	float Y;
	float Radius;

	FILE* SystemFile = std::fopen(FileName.c_str(),"r");
	if(SystemFile == NULL)
	{
		return;
	}

	while(std::feof(SystemFile) == 0)
	{
		std::fscanf(SystemFile,"%s",strBuf);
		std::fscanf(SystemFile,"%s",strBuf);
		std::fscanf(SystemFile,"%f",&X);

		std::fscanf(SystemFile,"%s",strBuf);
		std::fscanf(SystemFile,"%s",strBuf);
		std::fscanf(SystemFile,"%f",&Y);

		std::fscanf(SystemFile,"%s",strBuf);
		std::fscanf(SystemFile,"%s",strBuf);
		std::fscanf(SystemFile,"%f",&Radius);

		CBoundingCircle* BoundingCircle = new CBoundingCircle;
		BoundingCircle->SetPositionAdd(X,Y);
		BoundingCircle->SetRadius(Radius);

		m_Circles.push_back(BoundingCircle);
	}

	fclose(SystemFile);
}

void CCollisionSystem::SetPosition(float X, float Y)
{
	for(std::size_t CurCircle = 0; CurCircle < m_Circles.size(); CurCircle++)
	{
		m_Circles[CurCircle]->SetPosition(X,Y);
	}
}

bool CCollisionSystem::CheckCollision(const CCollisionSystem* CounterPart) const
{
	std::size_t Count = CounterPart->GetCircleCount();

	for(std::size_t CurCircle1 = 0; CurCircle1 < m_Circles.size(); CurCircle1++)
	{
		for(std::size_t CurCircle2 = 0; CurCircle2 < Count; CurCircle2++)
		{
			const CBoundingCircle* Circle = CounterPart->GetCircle(CurCircle2);
			if(Circle->Overlap(m_Circles[CurCircle1]))
			{
				return true;
			}
		}
	}

	return false;
}


float CCollisionSystem::GetWidth() const
{
	float SmallestX = 9999.0f;
	float SmallestRadius = 0.0f;
	float BiggestX = -9999.0f;
	float BiggestRadius = 0.0f;

	for(std::size_t CurCircle = 0; CurCircle < m_Circles.size(); CurCircle++)
	{
		if(m_Circles[CurCircle]->GetXPositionAdd() < SmallestX)
		{
			SmallestX = m_Circles[CurCircle]->GetXPositionAdd();
			SmallestRadius = m_Circles[CurCircle]->GetRadius();
		}

		if(m_Circles[CurCircle]->GetXPositionAdd() > BiggestX)
		{
			BiggestX = m_Circles[CurCircle]->GetXPositionAdd();
			BiggestRadius = m_Circles[CurCircle]->GetRadius();
		}
	}

	return (BiggestX - SmallestX) + (SmallestRadius + BiggestRadius);
}
