/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "Briefing.hpp"
#include "UpdateFrame.hpp"

#include <libintl.h>
#define _(string) gettext(string)

CBriefing::CBriefing()
{
	/// \todo initialisierungsliste
	m_BitmapFont = NULL;

	m_LogoSprite = NULL;

	m_MouseX = NULL;
	m_MouseY = NULL;
	m_MouseDown = NULL;

	m_ContentScroll = 0;

	m_SubMenu = BRIEF_SUB_START;

	m_ScrollingDown = false;
	m_ScrollingUp	= false;

	m_ButtonType = BRIEF_BUTTON_START;

	m_Player = NULL;

	m_LastFrameInc = 0;
	m_FrameDelay   = 50;

	m_CampaignName = "";
}

CBriefing::~CBriefing()
{
	delete m_LogoSprite;
}

void CBriefing::Init(CBitmapFont* BitMapFont, int* MouseX, int* MouseY, 
					 bool* MouseDown, CPlayer* Player)
{
	if(BitMapFont == NULL || MouseX == NULL || MouseY == NULL || MouseDown == NULL)
	{
		return;
	}

	m_MouseX = MouseX;
	m_MouseY = MouseY;
	m_MouseDown = MouseDown;
	m_BitmapFont = BitMapFont;
	m_Player = Player;

	m_BackSprite.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/briefing.png"));

	m_StartUp.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/start_up.png"));
	m_StartUp.SetPosition(30,630);
	m_StartDown.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/start_down.png"));
	m_StartDown.SetPosition(m_StartUp.GetPosition().x,m_StartUp.GetPosition().y);

	m_SaveUp.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/speichern_up.png"));
	m_SaveUp.SetPosition(m_StartUp.GetPosition().x,690);
	m_SaveDown.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/speichern_down.png"));
	m_SaveDown.SetPosition(m_StartUp.GetPosition().x,m_SaveUp.GetPosition().y);

	m_CancelUp.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/abbrechen_up.png"));
	m_CancelUp.SetPosition(m_SaveUp.GetPosition().x,m_SaveUp.GetPosition().y);
	m_CancelDown.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/abbrechen_down.png"));
	m_CancelDown.SetPosition(m_SaveUp.GetPosition().x,m_SaveUp.GetPosition().y);

	m_BackUp.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/zurück_up.png"));
	m_BackUp.SetPosition(m_SaveUp.GetPosition().x,690);
	m_BackDown.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/zurück_down.png"));
	m_BackDown.SetPosition(m_SaveUp.GetPosition().x,690);

	m_FinishUp.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/abschliessen_up.png"));
	m_FinishUp.SetPosition(m_SaveUp.GetPosition().x,m_SaveUp.GetPosition().y);
	m_FinishDown.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/abschliessen_down.png"));
	m_FinishDown.SetPosition(m_SaveUp.GetPosition().x,m_SaveUp.GetPosition().y);

	m_ScrollUp_Up.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/up_up.png"));
	m_ScrollUp_Up.SetPosition(960,240);

	m_ScrollUp_Down.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/up_down.png"));
	m_ScrollUp_Down.SetPosition(m_ScrollUp_Up.GetPosition().x,m_ScrollUp_Up.GetPosition().y);

	m_ScrollUpDisable.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/up_disable.png"));
	m_ScrollUpDisable.SetPosition(m_ScrollUp_Up.GetPosition().x,m_ScrollUp_Up.GetPosition().y);


	m_ScrollDown_Up.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/down_up.png"));
	m_ScrollDown_Up.SetPosition(m_ScrollUp_Up.GetPosition().x,700);

	m_ScrollDown_Down.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/down_down.png"));
	m_ScrollDown_Down.SetPosition(m_ScrollDown_Up.GetPosition().x,m_ScrollDown_Up.GetPosition().y);

	m_ScrollDownDisable.SetImage(sgl::get_imagemgr().get_img("data/gfx/Briefing/down_disable.png"));
	m_ScrollDownDisable.SetPosition(m_ScrollUpDisable.GetPosition().x,700);

	m_SaveField.Init(BitMapFont, "data/gfx/Briefing/listselect.png");
	m_SaveField.SetSize(655,470);
	m_SaveField.SetPosition(270,250);
}

void CBriefing::Update()
{
	if(m_BitmapFont == NULL || m_MouseX == NULL || m_MouseY == NULL || m_MouseDown == NULL)
	{
		return;
	}

	if(UpdateAll() == true)
	{
		m_Close = true;
		return;
	}

	RenderAll();
}

void CBriefing::RenderAll()
{
	sgl::get_window().Draw(m_BackSprite);

	m_BitmapFont->DrawText(220,80,m_Title,27);

	m_CanScrollDown = false;

	if(m_SubMenu == BRIEF_SUB_START)
	{
		RenderStart();
	}
	else if(m_SubMenu == BRIEF_SUB_SAVE)
	{
		RenderLoad();
	}
	

	if(m_ContentScroll <= 0)
	{
		sgl::get_window().Draw(m_ScrollUpDisable);
	}
	else
	{
		if(m_ScrollingUp == true)
		{
			sgl::get_window().Draw(m_ScrollUp_Down);
		}	
		else
		{	
			sgl::get_window().Draw(m_ScrollUp_Up);
		}
	}

	if(m_CanScrollDown == false)
	{
		sgl::get_window().Draw(m_ScrollDownDisable);
	}
	else
	{
		if(m_ScrollingDown == true)
		{
			sgl::get_window().Draw(m_ScrollDown_Down);
		}	
		else
		{
			sgl::get_window().Draw(m_ScrollDown_Up);
		}
	}

	if(m_LogoSprite != NULL)
	{
		sgl::get_window().Draw(*m_LogoSprite);

		if(sgl::get_clock().GetElapsedTime()*1000 - m_LastFrameInc > m_FrameDelay)
		{
			update_frame(*m_LogoSprite, frame_count);
			m_LastFrameInc = sgl::get_clock().GetElapsedTime()*1000;
		}
	}
}

void CBriefing::RenderStart()
{
	m_BitmapFont->DrawText(280,255,m_Content,25,670,430,m_ContentScroll,&m_CanScrollDown);

	if(m_ButtonDown == true)
	{
		switch(m_ButtonType)
		{
		case BRIEF_BUTTON_START:
			sgl::get_window().Draw(m_StartDown);
			break;
		case BRIEF_BUTTON_CANCEL:
			sgl::get_window().Draw(m_CancelDown);
			break;
		case BRIEF_BUTTON_FINISH:
				sgl::get_window().Draw(m_FinishDown);
			break;
		}
	}
	else
	{
		switch(m_ButtonType)
		{
		case BRIEF_BUTTON_START:
			sgl::get_window().Draw(m_StartUp);
			break;
		case BRIEF_BUTTON_CANCEL:
				sgl::get_window().Draw(m_CancelUp);
			break;
		case BRIEF_BUTTON_FINISH:
			sgl::get_window().Draw(m_FinishUp);
			break;
		}
	}

	if(m_ButtonType == BRIEF_BUTTON_START)
	{
		if(m_SaveButtonDown == false)
		{
			sgl::get_window().Draw(m_SaveUp);
		}
		else
		{
			sgl::get_window().Draw(m_SaveDown);
		}
	}
}

void CBriefing::RenderLoad()
{
	m_SaveField.Draw();

	m_CanScrollDown = m_SaveField.CanScrollDown();

	if(m_SaveButtonDown == false)
	{
		sgl::get_window().Draw(m_SaveUp);
	}
	else
	{
		sgl::get_window().Draw(m_SaveDown);
	}

	if(m_ButtonDown == false)
	{
		sgl::get_window().Draw(m_BackUp);
	}
	else
	{
		sgl::get_window().Draw(m_BackDown);
	}
}


bool CBriefing::UpdateAll()
{
	bool MouseDown = (*m_MouseDown); 

	if(m_HasHitMouse == true && MouseDown == false)
	{
		if(m_ButtonDown == true && m_SubMenu == BRIEF_SUB_START)
		{
			m_Close = true;
		}
		else if(m_ButtonDown == true && m_SubMenu == BRIEF_SUB_SAVE)
		{
			ChangeToStart();
		}
		
		if(m_SaveButtonDown == true && m_SubMenu == BRIEF_SUB_START && m_ButtonType == BRIEF_BUTTON_START)
		{
			ChangeToSave();
		}
		else if(m_SaveButtonDown == true && m_SubMenu == BRIEF_SUB_SAVE && m_ButtonType == BRIEF_BUTTON_START)
		{
			Save();
		}
	}

	int MouseX = (*m_MouseX);
	int MouseY = (*m_MouseY);

	int ButtonX = 31;
	int ButtonY = 687;

	if(MouseDown == true && m_SubMenu == BRIEF_SUB_START)
	{
		if(m_ButtonType == BRIEF_BUTTON_START)
		{
			ButtonY -= 60;
		}

		if(MouseX > ButtonX && MouseX < ButtonX + m_StartUp.GetSubRect().GetWidth() &&
		   MouseY > ButtonY && MouseY < ButtonY + m_StartUp.GetSubRect().GetHeight())
		{
			m_ButtonDown = true;
		}
		else
		{
			m_ButtonDown = false;
		}

		if(m_ButtonType == BRIEF_BUTTON_START)
		{
			if(MouseX > ButtonX && MouseX < ButtonX + m_StartUp.GetSubRect().GetWidth() &&
			   MouseY > ButtonY + 60 && MouseY < ButtonY + 60 + m_StartUp.GetSubRect().GetHeight())
			{
				m_SaveButtonDown = true;
			}
			else
			{
				m_SaveButtonDown = false;
			}
		}
	}
	else if(MouseDown == true && m_SubMenu == BRIEF_SUB_SAVE)
	{
		int ID = 0;

		if(MouseX > m_SaveField.GetXPosition() && MouseX < m_SaveField.GetXPosition() + m_SaveField.GetXSize() &&
		   MouseY > m_SaveField.GetYPosition() && MouseY < m_SaveField.GetYPosition() + m_SaveField.GetYSize() - 50)
		{
			ID = (MouseY - m_SaveField.GetYPosition()) / 32;
			m_SaveField.SelectEntryWithScroll(ID);
		}

		if(MouseX > ButtonX && MouseX < ButtonX + m_StartUp.GetSubRect().GetWidth() &&
		   MouseY > ButtonY && MouseY < ButtonY + m_StartUp.GetSubRect().GetHeight())
		{
			m_ButtonDown = true;
		}
		else
		{
			m_ButtonDown = false;
		}

		ButtonY -= 60;

		if(MouseX > ButtonX && MouseX < ButtonX + m_StartUp.GetSubRect().GetWidth() &&
		   MouseY > ButtonY && MouseY < ButtonY + m_StartUp.GetSubRect().GetHeight())
		{
			m_SaveButtonDown = true;
		}
		else
		{
			m_SaveButtonDown = false;
		}
	}
	else
	{
		m_SaveButtonDown = false;
		m_ButtonDown = false;
	}

	if(MouseDown == true)
	{
		if(MouseX > 951 && MouseX < 951 + m_StartUp.GetSubRect().GetWidth() &&
		   MouseY > 227 && MouseY < 227 + m_StartUp.GetSubRect().GetHeight())
		{
			m_ScrollingUp = true;
		}
		else
		{
			m_ScrollingUp = false;
		}

		if(MouseX > 951 && MouseX < 951 + m_ScrollDown_Up.GetSubRect().GetWidth() &&
		   MouseY > 677 && MouseY < 677 + m_ScrollDown_Up.GetSubRect().GetHeight() && m_CanScrollDown == true)
		{
			m_ScrollingDown = true;
		}
		else
		{
			m_ScrollingDown = false;
		}
		
	}
	else
	{
		m_ScrollingUp = false;
		m_ScrollingDown = false;
	}

	if((m_ScrollingUp == true || m_ScrollingDown == true) && sgl::get_clock().GetElapsedTime()*1000 - m_LastScrollTime > BRIEF_SCROLL_DELAY)
	{
		if(m_ScrollingUp == true)
		{
			m_SaveField.Scroll(-1);
			if(m_ContentScroll > 0)
			{
				m_ContentScroll--;
			}
			else
			{
				m_ScrollingUp = false;
			}
		}
		else if(m_ScrollingDown == true)
		{
			m_SaveField.Scroll(1);
			m_ContentScroll++;
		}
		m_LastScrollTime = sgl::get_clock().GetElapsedTime()*1000;
	}

	if(m_ScrollingDown == true && m_CanScrollDown == false)
	{
		m_ScrollingDown = false;
	}

	m_HasHitMouse = MouseDown; 

	return false;
}

void CBriefing::SetContent(std::string Title, std::string Content, std::string FileName, int ButtonType, unsigned int FrameCount, int FrameDelay)
{
	m_SubMenu = BRIEF_SUB_START;

	m_Title = Title;
	m_Content = Content;

	if(m_LogoSprite != NULL)
	{
		delete m_LogoSprite;
		m_LogoSprite = NULL;
	}

	if(FileName != "")
	{
		m_LogoSprite = new sf::Sprite;
		m_LogoSprite->SetImage(sgl::get_imagemgr().get_img(FileName));
		m_LogoSprite->SetSubRect(sf::IntRect(0, 0,160,160));
		frame_count = FrameCount;
		m_LogoSprite->SetPosition(50,255);

		m_FrameDelay = FrameDelay;
	}

	m_ButtonType = ButtonType;

	m_ContentScroll = 0;
}

void CBriefing::ChangeToSave()
{
	m_SubMenu = BRIEF_SUB_SAVE;

	m_SaveField.Clear();

	m_SaveUp.SetPosition(m_SaveUp.GetPosition().y,m_SaveUp.GetPosition().y - 60);
	m_SaveDown.SetPosition(m_SaveUp.GetPosition().y,m_SaveUp.GetPosition().y);

	FillSaveList();

	m_ContentScroll = 0;
}

void CBriefing::ChangeToStart()
{
	m_SubMenu = BRIEF_SUB_START;

	m_SaveUp.SetPosition(m_SaveUp.GetPosition().y,m_SaveUp.GetPosition().y + 60);
	m_SaveDown.SetPosition(m_SaveUp.GetPosition().y,m_SaveUp.GetPosition().y);

	m_ContentScroll = 0;
}

void CBriefing::Save()
{
	if(m_Player == NULL)
	{
		return;
	}

	std::string CurEntry; 
	CurEntry = m_SaveField.GetCurEntry();

	CSaveManager SaveManager;

	int OldSelect = 0;

	if(CurEntry == _("<New Savepoint>"))
	{
		SaveManager.Save("saves",m_CampaignName,m_CurMission,m_Player->GetLives());
	}
	else
	{
		SaveManager.ReadSavesFromFolder("saves");

		SaveData* Data;

		OldSelect = m_SaveField.GetCurSelectIndex() - 1;
		Data = SaveManager.GetSaveData(OldSelect);

		if(Data != NULL)
		{
			SaveManager.SaveFile(Data->SaveFile,m_CampaignName,m_CurMission,m_Player->GetLives());
		}
	}

	FillSaveList();

	m_SaveField.SelectEntryWithoutScroll(OldSelect + 1);
}

void CBriefing::FillSaveList()
{
	//Diese Funktion füllt die SaveListe

	CSaveManager SaveManager;
	SaveManager.ReadSavesFromFolder("saves");
	m_SaveField.Clear();

	m_SaveField.AddEntry(_("<New Savepoint>"));

	SaveData* Data;
	for(std::size_t CurData = 0; CurData < SaveManager.GetSaveCount(); CurData++)
	{
		Data = SaveManager.GetSaveData(CurData);

		if(Data == NULL)
		{
			continue;
		}

		m_SaveField.AddEntry(Data->ListName);
	}
}
