/* This Spaceshooter is an small space adventure game
 * Copyright (C) 2006,2007  Steffen Nörtershäuser
 * Copyright (C) 2008 Christoph Egger
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

//////////////////////////////////////////////////////////////////////////////////////////////////
//BoundingCircle.h - Deklaration der Klasse CBoundingCircle
//CBoundingCircle wird für das erkennen von Kollisionen benötigt
//Steffen Nörtershäuser
//////////////////////////////////////////////////////////////////////////////////////////////////


////////////////////////////////Makros und Includes///////////////////////////////////////////////
//Schutz vor Mehrfach Deklaration
#ifndef BOUNDINGCIRCLE_H
#define BOUNDINGCIRCLE_H

#include <cmath>

//////////////////////////////////////////////////////////////////////////////////////////////////

/** \brief Bounding Circles für das Collision System
  * \author Steffen Nörtershäuser
  */
class CBoundingCircle
{
public:
	/// Konstrukor und Destruktor
	CBoundingCircle()
			: m_Radius(0.0f),
			  m_XPos(0.0f),
			  m_YPos(0.0f),
			  m_XPosAdd(0.0f),
			  m_YPosAdd(0.0f)
	{}
	~CBoundingCircle() {}

	/// Diese Funktion legt den Radius des BoundingCircles fest
	void SetRadius(float Radius) 
	{ 
		m_Radius = Radius;
	}

	/// Diese Funktion gibt den Radius des BoundingCircles zurück
	float GetRadius() const { return m_Radius; }

	/// Diese Funktion legt die Position des BoundingCircles fest
	void SetPosition(float X, float Y)
	{
		m_XPos = X;
		m_YPos = Y;
	}

	/// Diese Funktion gibt die X-Position des BoundingCircles zurück
	float GetRealXPosition() const { return m_XPos+m_XPosAdd; }
	float GetXPosition() const { return m_XPos; }

	/// Diese Funktion gibt die X-Position des BoundingCircles zurück
	float GetRealYPosition() { return m_YPos+m_YPosAdd; }
	float GetYPosition() { return m_YPos; }

	/// Diese Funktion legt fest was auf den Position des BoundingCircles addiert wird
	void SetPositionAdd(float XAdd, float YAdd)
	{
		m_XPosAdd = XAdd;
		m_YPosAdd = YAdd;
	}

	/// Diese Funktion gibt den Wert der auf X-Position des BoundingCircles addiert wird zurück
	float GetXPositionAdd() const { return m_XPosAdd; }

	/// Diese Funktion gibt den Wert der auf Y-Position des BoundingCircles addiert wird zurück
	float GetYPositionAdd() const { return m_YPosAdd; }


	/// Diese Funktion überprüft ob sich die beiden BoundCirlces überschneiden
	bool Overlap(CBoundingCircle* Counterpart) const
	{
		float Distance = std::sqrt((Counterpart->GetRealXPosition()-(m_XPos+m_XPosAdd))*(Counterpart->GetRealXPosition()-(m_XPos+m_XPosAdd)) + 
										 (Counterpart->GetRealYPosition()-(m_YPos+m_YPosAdd))*(Counterpart->GetRealYPosition()-(m_YPos+m_YPosAdd)));

		return (Distance < m_Radius + Counterpart->GetRadius());
	}


	void Draw() 
	{}
private:
	float m_Radius;		//Der Radius des BoundingCircles

	float m_XPos;		//Die X-Position des BoundingCircles
	float m_YPos;		//Die Y-Position des BoundingCircles

	float m_XPosAdd;	//Wird auf die X-Position des BoundingCircles addiert
	float m_YPosAdd;	//Wird auf die Y-Position des BoundingCircles addiert
};

#endif

