Summary: script to organize ogg and mp3 files
Name: songanizer
Version: 0.5
Release: 1
URL: http://savannah.nognu.org/songanizer
Source0: %{name}-%{version}.tar.gz
License: GPL
Group: Applications/Multimedia
BuildRoot: %{_builddir}/%{name}-root

%description
Script to organize a directory containing ogg and mp3 files.

The biggest problem for me, during my tries to organize music files,
was the choice of the directory structure. Should the directory
structure reflect the author or the genre or may be the album? I ended
up with the conclusion, that no ideal directory structure exists. So I
wanted different virtual directory structures to the same data. Thanks
to the symbolic links capability of the file systems I use (ext2,
ext3, ...) this dream has become reality!

The script gets a list of _data directories, in which the real ogg and
mp3 files reside. The script has to read informations like author,
album, genre, ... from these files and create parallel directory
structures, which just contain symbolic links (like pointers) to the
directories in which the real files live.

The goal is to create virtual directory structures, which give
different views of the data, but without having redundant copies of
the files themself.

%prep
%setup -q

%build

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p ${RPM_BUILD_ROOT}/usr/local/bin/
cp bin/songanizer ${RPM_BUILD_ROOT}/usr/local/bin/.

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/local/bin/songanizer
%doc COPYING AUTHORS README NEWS

%changelog
* Fri Aug 22 2003 Patrick Ohnewein <patrick.ohnewein@lugbz.org>
- fixed problems if an album is contained in more than one data directory [bug #4877]

* Sun Aug 17 2003 Patrick Ohnewein <patrick.ohnewein@lugbz.org>
- added support for multiple data directories

* Wed Jul 16 2003 Patrick Ohnewein <patrick.ohnewein@lugbz.org>
- Initial build.


