/*****************************************************************************/

/*
 *      xrobotsdlg.cpp is part of SoftBots.
 *
 *      Copyright (C) 2008  Atul Sowani (sowani@gmail.com)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *      02110-1301 USA
 *
 *
 */

/*****************************************************************************/

//
// C++ Implementation: xrobotsdlg
//
// Description:
//      Displays the XRobot launcher dialog.
//
// Author: Atul Sowani <asowani>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <stdlib.h>
#include <qmessagebox.h>
#include "xrobotsdlg.h"

char execName[] = "/usr/local/apps/gnurobots/bin/xrobots";

/*
    QLabel        *robotLabel;
    QLabel        *mapLabel;
    myFileChooser *robotFileChooser;
    myFileChooser *mapFileChooser;
    QPushButton   *launchButton;
    QPushButton   *exitButton;
    QPushButton   *mapEditButton;
    QPushButton   *helpButton;
    QPushButton   *aboutButton;
*/

XRobotsDialog::XRobotsDialog ( QWidget *parent, const char *name)
              : QDialog (parent, name)
{
    if ( !name )
        setName( "XRobot Launcher" );
    setSizePolicy( QSizePolicy( (QSizePolicy::SizeType) 5,
                                (QSizePolicy::SizeType) 5, 0, 0,
                                sizePolicy().hasHeightForWidth() ) );

    launchButton = new QPushButton( "&Launch!", this, "launchButton" );
    launchButton->setGeometry( QRect( 30, 110, 80, 22 ) );
    launchButton->setAccel ( QKeySequence (tr ("Alt+L")) );

    mapFileChooser = new myFileChooser( this, "mapFileChooser" );
    mapFileChooser->setGeometry( QRect( 80, 60, 160, 30 ) );
    mapFileChooser->setFilter("*.map");
    mapFileChooser->setFocusPolicy( QWidget::TabFocus );

    exitButton = new QPushButton( "E&xit", this, "exitButton" );
    exitButton->setGeometry( QRect( 150, 110, 82, 22 ) );
    exitButton->setAccel ( QKeySequence (tr ("ALT+x")) );

    robotLabel = new QLabel( "Robot", this, "robotLabel" );
    robotLabel->setGeometry( QRect( 10, 10, 60, 37 ) );
    robotLabel->setTextFormat( QLabel::AutoText );

    mapLabel = new QLabel( "Map", this, "mapLabel" );
    mapLabel->setGeometry( QRect( 10, 60, 60, 37 ) );

    robotFileChooser = new myFileChooser( this, "robotFileChooser" );
    robotFileChooser->setGeometry( QRect( 80, 10, 160, 30 ) );
    robotFileChooser->setFilter("*.scm");
    robotFileChooser->setFocusPolicy( QWidget::TabFocus );

    aboutButton = new QPushButton ( "&About", this, "aboutButton" );
    aboutButton->setGeometry ( QRect( 260, 10, 80, 22 ) );
    aboutButton->setAccel ( QKeySequence (tr ("ALT+A")) );

    helpButton = new QPushButton ( "&Help", this, "helpButton" );
    helpButton->setGeometry ( QRect (260, 60, 80, 22 ) );
    helpButton->setAccel ( QKeySequence (tr ("ALT+H")) );

    mapEditButton = new QPushButton ( "&Map Editor", this, "mapEditButton");
    mapEditButton->setGeometry (QRect( 260, 110, 80, 22 ) );
    mapEditButton->setAccel ( QKeySequence (tr ("ALT+M")) );

    resize( QSize(350, 144).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect ( robotFileChooser, SIGNAL (fileNameChanged(const QString&)),
              this, SIGNAL (robotNameChanged(const QString& )) );
    connect ( mapFileChooser, SIGNAL (fileNameChanged(const QString& )),
              this, SIGNAL (mapNameChanged(const QString& )) );
    connect ( launchButton, SIGNAL (clicked()), this, SLOT (launchApp()) );
    connect ( exitButton, SIGNAL (clicked()), this, SLOT (exitApp()) );
    connect ( aboutButton, SIGNAL (clicked()), this, SLOT (showVersion()) );
    connect ( helpButton, SIGNAL (clicked()), this, SLOT (showDoc()) );
    connect ( mapEditButton, SIGNAL (clicked()),
              this, SLOT (launchMapEditor()) );

    // tab order
    setTabOrder( robotFileChooser, mapFileChooser );
    setTabOrder( mapFileChooser, launchButton );
    setTabOrder( launchButton, exitButton );
    setTabOrder( exitButton, aboutButton );
    setTabOrder( aboutButton, helpButton );
    setTabOrder( helpButton, mapEditButton );

    // buddies
    robotLabel->setBuddy( robotFileChooser );
    mapLabel->setBuddy( mapFileChooser );
    setIcon (QPixmap( "/usr/local/share/pixmaps/robots/PincherUnit.png"));
}

XRobotsDialog::~XRobotsDialog()
{
}

void XRobotsDialog::launchApp()
{
    char commandLine[512];
    sprintf (commandLine, "%s -f %s %s\n", execName,
                            mapFileChooser->fileName().ascii(),
                            robotFileChooser->fileName().ascii() );
    system (commandLine);
}

void XRobotsDialog::exitApp()
{
    exit (0);
}

void XRobotsDialog::showVersion()
{
    QMessageBox::about ( this, "About GNURobots Launcher",
            "Copyleft (C) 2007 - end-of-eternity, Atul Sowani"
            " <sowani@gmail.com>\n"
            "Released under GNU GPL 2.0 or later\n\n"
            "GNU Robots, version 1.0\n"
            "Copyright (C) 1998,1999,2000 Jim Hall <jhall1@isd.net>" );
}

void XRobotsDialog::showDoc()
{
    system ( "kedit /usr/local/apps/gnurobots/doc/Robots-HOWTO" );
}

void XRobotsDialog::launchMapEditor()
{
    system ( "/usr/local/apps/gnurobots/bin/mapedit" );
}
