/*****************************************************************************/

/*
 *      filechooser.h is part of SoftBots.
 *
 *      Copyright (C) 2008  Atul Sowani (sowani@gmail.com)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *      02110-1301 USA
 *
 *
 */

/*****************************************************************************/

#ifndef FILE_CHOOSER_H
#define FILE_CHOOSER_H

#include <qwidget.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qfiledialog.h>

class QLineEdit;
class QPushButton;

class myFileChooser : public QWidget
{
    Q_OBJECT
    
    Q_ENUMS (Mode)
    Q_PROPERTY (Mode mode READ mode WRITE setMode)
    Q_PROPERTY (QString fileName READ fileName WRITE setFileName)

public:
    myFileChooser ( QWidget *parent = 0, const char *name = 0 );
    enum Mode { File, Directory };
    QString fileName() const;
    Mode mode() const;

public slots:
    void setFileName (const QString &fn);
    void setMode (Mode m);
    void setFilter (const QString& flt);

signals:
    void fileNameChanged (const QString &);

private slots:
    void chooseFile();

private:
    QLineEdit *lineEdit;
    QPushButton *button;
    Mode md;
    QString filter;
};
#endif  // FILE_CHOOSER_H
