/*****************************************************************************/

/*
 *      xrobotsdlg.h is part of SoftBots.
 *
 *      Copyright (C) 2008  Atul Sowani (sowani@gmail.com)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 *      02110-1301 USA
 *
 *
 */

/*****************************************************************************/
#ifndef XROBOTS_DIALOG_H
#define XROBOTS_DIALOG_H

#include <qlabel.h>
#include "filechooser.h"

class XRobotsDialog : public QDialog
{
    Q_OBJECT

public:
    XRobotsDialog ( QWidget *parent = 0, const char *name = 0 );
    ~XRobotsDialog();

public slots:
    virtual void launchApp();
    virtual void exitApp();
    virtual void showDoc();
    virtual void showVersion();
    virtual void launchMapEditor();

signals:
    void robotNameChanged ( const QString& );
    void mapNameChanged ( const QString& );

private:
    QLabel                 *robotLabel;
    QLabel                 *mapLabel;
    myFileChooser   *robotFileChooser;
    myFileChooser   *mapFileChooser;
    QPushButton       *launchButton;
    QPushButton       *exitButton;
    QPushButton       *mapEditButton;
    QPushButton       *helpButton;
    QPushButton       *aboutButton;

    char *execpath, *docpath, *mapeditpath;
    int getConfigPaths (void);
};

#endif  // XROBOTS_DIALOG_H
