# svs_simulation.utilities.constants

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Constants for simulation classes.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# internal imports
from svs_core.utilities.lib import Constants


#############################
# CONSTANTS
#############################
sim_const = Constants()

# entity types *** NOT USED AT PRESENT ***
sim_const.TYPE_AGENT = 100
sim_const.TYPE_OBJECT = 101
sim_const.TYPE_STRUCTURE = 102

# process labels
sim_const.LABEL_UPDATEWORLD = 'update_world'
sim_const.LABEL_STARTWORLD = 'start_world'
sim_const.LABEL_STOPWORLD = 'stop_world'
sim_const.LABEL_NOTIFYOFEVENTS = 'notify_of_events'
sim_const.LABEL_UPDATE = 'update'

# entity labels
sim_const.LABEL_WORLD = 'world'
sim_const.LABEL_AGENT = 'agent'
sim_const.LABEL_AGENTS = 'agents'
sim_const.LABEL_AGENTGROUP = 'agentgroup'
sim_const.LABEL_AGENTGROUPS = 'agentgroups'
sim_const.LABEL_OBJECT = 'object'
sim_const.LABEL_OBJECTS = 'objects'
sim_const.LABEL_OBJECTGROUP = 'objectgroup'
sim_const.LABEL_OBJECTGROUPS = 'objectgroups'
sim_const.LABEL_STRUCTURE = 'structure'
sim_const.LABEL_STRUCTURES = 'structures'
sim_const.LABEL_TERRAIN = 'terrain'
sim_const.LABEL_PARTITION = 'partition'
sim_const.LABEL_PARTITIONS = 'partitions'
sim_const.LABEL_GRAPH = 'graph'
sim_const.LABEL_GRAPHS = 'graphs'
sim_const.LABEL_MEMBER = 'member'
sim_const.LABEL_MEMBERS = 'members'

# property labels
sim_const.LABEL_CLASS = 'class'
sim_const.LABEL_IDTAG = 'idtag'
sim_const.LABEL_BOUNDS = 'bounds'
sim_const.LABEL_LOCATION = 'location'
sim_const.LABEL_FACING = 'facing'
sim_const.LABEL_NAME = 'name'
sim_const.LABEL_SPEED = 'speed'
sim_const.LABEL_MAXSPEED = 'maxspeed'
sim_const.LABEL_DENSITY = 'density'
sim_const.LABEL_MOVEMENTCOST = 'movecost'
sim_const.LABEL_X = 'x'
sim_const.LABEL_Y = 'y'
sim_const.LABEL_Z = 'z'
sim_const.LABEL_DIMX = 'dim_x'
sim_const.LABEL_DIMY = 'dim_y'
sim_const.LABEL_DIMZ = 'dim_z'
sim_const.LABEL_MINX = 'min_x'
sim_const.LABEL_MINY = 'min_y'
sim_const.LABEL_MINZ = 'min_z'
sim_const.LABEL_MAXX = 'max_x'
sim_const.LABEL_MAXY = 'max_y'
sim_const.LABEL_MAXZ = 'max_z'
sim_const.LABEL_WIDTH = 'width'
sim_const.LABEL_HEIGHT = 'height'
sim_const.LABEL_RADIUS = 'radius'
sim_const.LABEL_SPACEX = 'space_x'
sim_const.LABEL_SPACEY = 'space_y'
sim_const.LABEL_MARGIN = 'margin'
sim_const.LABEL_EDGE = 'edge'
sim_const.LABEL_EDGES = 'edges'
sim_const.LABEL_NODE = 'node'
sim_const.LABEL_NODES = 'nodes'
sim_const.LABEL_HEAD = 'head'
sim_const.LABEL_TAIL = 'tail'
sim_const.LABEL_SIMDATA = 'simdata'
sim_const.LABEL_VALID = 'valid'
sim_const.LABEL_CONTENT = 'content'
sim_const.LABEL_FILE = 'file'
sim_const.LABEL_COPYOF = 'copyof'
sim_const.LABEL_DEFINITION = 'definition'
sim_const.LABEL_EXTRAPROPERTIES = 'extraproperties'

# structure labels
sim_const.LABEL_COMPONENT = 'component'
sim_const.LABEL_FLOORPLANE = 'floorplane'
sim_const.LABEL_WALLPLANE = 'wallplane'
sim_const.LABEL_WALLPLANES = 'wallplanes'
sim_const.LABEL_VERTICES = 'vertices'
sim_const.LABEL_NAVGRAPH = 'navgraph'
sim_const.LABEL_NAVPOINT = 'navpoint'
sim_const.LABEL_EXTDENSITY = 'ext_density'
sim_const.LABEL_INTDENSITY = 'int_density'

# path labels
sim_const.LABEL_PATH = 'path'
sim_const.LABEL_PATHS = 'paths'
sim_const.LABEL_LINKPATH = 'linkpath'
sim_const.LABEL_LINKPATHS = 'linkpaths'
sim_const.LABEL_START = 'start'
sim_const.LABEL_END = 'end'
sim_const.LABEL_TRANSITION = 'transition'
sim_const.LABEL_ENTRANCE = 'entrance'
sim_const.LABEL_OPEN = 'open'
sim_const.LABEL_WORLDEXIT = 'worldexit'

# event labels
sim_const.LABEL_SIMEVENT = 'simevent' 
sim_const.LABEL_TIME = 'time' 
sim_const.LABEL_SOURCE = 'source'
sim_const.LABEL_DATA = 'data'
sim_const.LABEL_EVENTTAG = 'event_tag'

# action label
sim_const.LABEL_SIMACTION = 'simaction' 
sim_const.LABEL_TARGET = 'target'
sim_const.LABEL_METHODNAME = 'mthname' 
sim_const.LABEL_ARGS = 'args'
sim_const.LABEL_KWARGS = 'kwargs'

# state labels
sim_const.LABEL_STATECHANGE = 'statechange'

# data labels
sim_const.LABEL_LOD = 'lod'

# schedule labels
sim_const.LABEL_SCHEDULE = 'schedule'
sim_const.LABEL_SCHEDULES = 'schedules'
sim_const.LABEL_TIMELINE = 'timeline'
sim_const.LABEL_MONDAY = 'monday'
sim_const.LABEL_TUESDAY = 'tuesday'
sim_const.LABEL_WEDNESDAY = 'wednesday'
sim_const.LABEL_THURSDAY = 'thursday'
sim_const.LABEL_FRIDAY = 'friday'
sim_const.LABEL_SATURDAY = 'saturday'
sim_const.LABEL_SUNDAY = 'sunday'

# time labels
sim_const.LABEL_SIMCLOCK = 'simclock'
sim_const.LABEL_SIMTIME = 'simtime'
sim_const.LABEL_DAY = 'day'
sim_const.LABEL_HOUR = 'hour'
sim_const.LABEL_MINUTES = 'mins'
sim_const.LABEL_SECONDS = 'seconds'
sim_const.LABEL_STARTTIME = 'start_time'
sim_const.LABEL_ENDTIME = 'end_time'
sim_const.LABEL_TIMESTEP = 'timestep'
sim_const.LABEL_TIMESTEPDURATION = 'timestepdur'
sim_const.LABEL_LOOPING = 'looping'

# terrain
sim_const.COMPASS_POINTS = ['E', 'SE', 'S', 'SW', 'W', 'NW', 'N', 'NE']



#############################
# XML TAGS
#############################
sim_xml = Constants()

# generic
sim_xml.IDTAG = 'svs_idtag'
sim_xml.NAME = 'svs_name'
sim_xml.DATA = 'svs_data'

# terrains
sim_xml.TERRAIN = 'svs_terrain'
sim_xml.PARTITION = 'svs_partition'

# structures
sim_xml.STRUCTURE = 'svs_structure'
sim_xml.FLOORPLANE = 'svs_floorplane'
sim_xml.WALLPLANE = 'svs_wallplane'

# geometry and SVG
sim_xml.SVG = 'svg'
sim_xml.RECT = 'rect'
sim_xml.PATH = 'path'
sim_xml.WIDTH = 'width'
sim_xml.HEIGHT = 'height'
sim_xml.X = 'x'
sim_xml.Y = 'y'
sim_xml.D = 'd'
sim_xml.STYLE = 'style'
