# svs_simulation.terrain.util_classes

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Utility classes for terrains.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

#############################
# CLASSES
#############################
class GenericTerrainObject:
	"""
	Base class for all terrain objects.
	"""
	def __init__(self):
		self.bounds = None
		self.spaceX = None
		self.spaceY = None
		self.margin = None
		self.graphs = None

	def getBoundsMinX(self):
		"""
		Returns minimum x coordinate from bounds.
		"""
		pass

	def getBoundsMinY(self):
		"""
		Returns minimum y coordinate from bounds.
		"""
		pass

	def getBoundsMaxX(self):
		"""
		Returns maximum x coordinate from bounds.
		"""
		pass

	def getBoundsMaxY(self):
		"""
		Returns maximum y coordinate from bounds.
		"""
		pass

	def containsPoint(self, x, y):
		"""
		Tests if specified coordinates are present in area.
		"""
		return False

	def addGraph(self, graphName, graph):
		"""
		Adds new graph to object.
		"""
		if not self.graphs:self.graphs = {}
		self.graphs[graphName] = graph

	def getGraph(self, graphName):
		"""
		Returns named graph.  If not found returns C{None}.
		"""
		if not self.graphs:return None
		return self.graphs.get(graphName, None)

	def update(self, simTime):
		"""
		Updates self in response to simulation time.

		This should be overridden by extending classes.
		"""
		pass

	def addEntity(self, entity):
		"""
		Adds entity to terrain object.
		"""
		pass

	def removeEntity(self, entity):
		"""
		Adds entity to terrain object.
		"""
		pass
