# svs_simulation.numdata.mathlib

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Math utilities and constants.

This module depends on the C{kinds.py} module, available through
the CVS repository for the Numeric Python project:

L{http://numeric.scipy.org/}

L{http://cvs.sourceforge.net/viewcvs.py/numpy/kinds/}

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# extrnal imports
import kinds

# internal imports
from svs_core.utilities.lib import Constants


#############################
# CONSTANTS
#############################
math_const = Constants()
math_const.EPSILON = kinds.default_float_kind.EPSILON # 2.2204460492503131e-16
math_const.MAX_FLOAT = kinds.default_float_kind.MAX # 1.7976931348623157e+308 (Linux PowerPC)
math_const.MAX_INTEGER = kinds.default_int_kind.MAX # 2147483647 (Linux PowerPC)



