# svs_simulation.agents.agentstates.movement.walk

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Walk state for agents.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

# walk state
name = "walk"

transitions = ("stop", "run", "walkback", "sit")
inputs = {
    "slower":"stop",
    "faster":"run",
    "stop":"stop",
    "walkback":"walkback",
    "walk":"walk"
    }

def enter(agent):
    #print "enter walk"
    agent.gotoState("stand", "posture")
    agent.accel = 1
    agent.taskManager.setCurrentTask("move", "movement")
    agent.taskManager.setCurrentTask("nextstep", "obstacles")
    agent.stateManager.setStateProperty("movement", "direction", agent.facing)
    agent.stateManager.setStateProperty("movement", "stopOnCollide", 0)
        
def leave(agent):
    pass
    
def update(agent, simTimeInterval):
    pass
    
def onContact(agent, other):
    pass
        
