# svs_demogame.timebasedviews

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Base components for views with time-based displays.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# external imports
from time import time

# internal imports
from svs_core.utilities.lib import Constants
from svs_core.utilities.notification import Listenable


#############################
# CONSTANTS
#############################
timebasedviews_const = Constants()
timebasedviews_const.TIME_CURSOR = 'time_cursor'


class TimeCursorController(Listenable):
	"""
	Coordinating class for cursors indicating current, or
	selected time.  Used to synchronise multiple views.
	"""
	def __init__(self):
		Listenable.__init__(self)
		self.startTime = None
		self.currentTime = None
		self.cursorTime = None

	def start(self, startTime=None):
		"""
		Sets starts time to specified value, or current time
		if no value given.
		
		@type startTime: float
		"""
		if not startTime:startTime = time()
		self.startTime = startTime
		self.currentTime = startTime
		self.cursorTime = startTime
		if not self.listeners.has_key(timebasedviews_const.TIME_CURSOR):return
		for listener in self.listeners[timebasedviews_const.TIME_CURSOR]:
			listener.startTimeCursor(self.startTime)
		self.synchViews()

	def setCursorTime(self, newTime=None):
		"""
		Sets the diplayed time and notifies listeners.

		If no time value is given, sets it to the current time.
	
		@type newTime: float
		"""
		if not newTime:newTime = time()
		self.cursorTime = newTime
		self.synchViews()
		return self.cursorTime

	def addView(self, view):
		"""
		Connects view to time cursor.
		"""
		self.addListener(view, listenFor=timebasedviews_const.TIME_CURSOR)

	def removeView(self, view):
		"""
		Removes view from time cursor.
		"""
		self.removeListener(view, listenFor=timebasedviews_const.TIME_CURSOR)
		
	def synchViews(self):
		"""
		Sends cursor time to views for display or synchronisation.
		"""
		if not self.listeners.has_key(timebasedviews_const.TIME_CURSOR):return
		synchTime = self.cursorTime - self.startTime
		for listener in self.listeners[timebasedviews_const.TIME_CURSOR]:listener.synchTimeCursor(synchTime)


	def selectItem(self, selectedItem):
		"""
		Selects specified item if present within view.

		This method is used to synchronise selesctions 
		between the different tracker views.
		"""
		pass
