# svs_core.filehandling.loaders

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Shared classes for loading and storing documents.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# external imports
from string import upper, lower, split, strip
from xml.sax import saxutils
from xml.sax import make_parser
from xml.sax.handler import feature_namespaces, feature_validation
from xml.dom.minidom import getDOMImplementation

# internal imports
from svs_core.utilities.lib import Bunch

#############################
# EXCEPTIONS
#############################
class DocumentLoadingException(Exception):pass
	

#############################
# FUNCTIONS
#############################
def malformedInputForXMLNodeException(nodename):
	return DocumentLoadingException("Malformed input data, when parsing <%s> node" % nodename)


#############################
# MAIN CLASSES
#############################
class DocumentLoader:
	"""
	Generic class for reading and writing document data.
	"""
	def __init__(self, target, contentHandlerClass=None):
		self.url = None
		self.target = target
		self.contentHandler = contentHandlerClass(self.target)
		
	def read(self, path):
		"""
		Reads document from path.
		"""
		pass
		
	def write(self, path):
		"""
		Writes document to path.
		"""
		pass
		
		
		
class DocumentLoaderXML(DocumentLoader):
	"""
	Generic class for reading and writing document data in xml format.
	"""
	def __init__(self, target, contentHandlerClass=None):
		DocumentLoader.__init__(self, target, contentHandlerClass)
		
	def read(self, path):
		"""
		Reads document from path.

		@type 	path: string
		@param 	path: pathname to actor
		"""
		input = open(path, 'rb')
		parser = make_parser()
		parser.setFeature(feature_namespaces, 0)
		parser.setFeature(feature_validation, 0) 
		parser.setContentHandler(self.contentHandler)
		parser.parse(input)

		
	def write(self, path):
		"""
		Writes profile to output.
		
		@type 	path: string
		@param 	path: pathname to profile
		"""
		
		# format as xml
		xmlStr = self.toxml()
		# write to output
		path = url + self.target.type + "." + self.target.name + ".xml"
		output = open(path, 'wb')
		output.write(xmlStr)
		
	
	def toxml(self):
		"""
		Converts profile data to xml text.
		
		@rtype:	string
		@return: profile data in xml encoding
		"""
		
		dom = self.toDOM()
		return dom.toxml()
		
		
	def toDOM(self):
		"""
		Converts profile data to xml DOM.
		
		@rtype:	DOM
		@return: profile data as DOM object
		"""
		return None


class GenericXMLContentHandler(saxutils.DefaultHandler):
	"""
	Generic handler for parsing xml document.
	
	@type	target: string
	@ivar	target: target to pass parsed data to
	@type	currentNode: string
	@ivar	currentNode: name of current node in parsing process
	"""
	
	def __init__(self, target):
		self.target = target
		self.currentNode = None
		self.chardata = None
		
	def startElement(self, name, attrs):
		pass
				
	def endElement(self, name):
		pass
	
	def characters(self, content):
		self.chardata += content.encode("utf-8")
			
	def error(self, exception):
		raise DocumentLoadingException("Malformed XML document: \%s" % exception)

		
