# svs_tracking.visualisation.sprite

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Basic display components for visualisation.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

class Sprite:
	"""
	Base class for all display components.
	"""
	def __init__(self, x=0.0, y=0.0, z=0.0):
		self.x = x
		self.y = y
		self.z = z

	def translate(self, dX=0.0, dY=0.0, dZ=0.0):
		"""
		Move sprite by specified amounts.
		"""
		pass


class Label(Sprite):
	"""
	Simple text label.
	"""
	def __init__(self, text=None, x=0.0, y=0.0, z=0.0):
		Sprite.__init__(x, y, z)
		self.setText(text)

	def setText(self, newText):
		self.text = newText

class TextArea(Sprite):
	"""
	Multiline text.
	"""
	pass

class BranchLine(Sprite):
	"""
	Branching graph line.
	"""
	pass

class AxialLine(Sprite):
	"""
	Annotated graph axis.
	"""
	pass


