# svs_tracking.visualisation.graphviews

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Objects for visualising graph structures.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

# internal imports
from svs_tracking.visualisation.collections import *



class NetworkGraphView(ClusterCollection):
	"""
	Respresents a graph consisting of connected nodes in a centralised cluster.

	The graph view receives a data source which should be a type of graph object.
	"""
	def __init__(self, x=0.0, y=0.0, z=0.0, maxRadius=0, dataSource=Null):
		ClusterCollection.__init__(self, x, y, z)
		self.setDataSource(dataSource)
	
	def setDataSource(self, dataSource):
		"""
		Defines data source for graph.
		"""
		self.dataSource = dataSource
		self.updateGraph()

	def updateGraph(self):
		"""
		Updates graph view to display current state of data source.
		"""
		if not self.dataSource:
			return


