# svs_tracking.visualisation.filehistoryview

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Provides a graphical representation of the changes to a file over a period of time.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""


class FileHistoryFrameView:
	"""
	Represents a single frame in the sequence of a FileHistoryView.
	"""
	def __init__(self, parentView, filedata=None):
		self.parentView = parentView
		self.opacity = 1.0
		self.filedata = filedata
		self.xMin = 0
		self.yMin = 0
		self.xMax = 0
		self.yMax = 0

	def draw(self):
		"""
		Draws FileHistoryFrameView.

		This should be overridden by implementing classes.
		"""
		pass

	 
class FileHistoryView:
	"""
	Represents the changes over time of a single file.
	"""
	def __init__(self, graphicContext, filename=''):
		self.filename = filename
		self.graphicContext = graphicContext
		self.basecolour = (0.0, 0.0, 0.0)
		self.frames = []

	def addFrame(self, filedata=None):
		"""
		Adds a frame to the view, this is appended to the end of the sequence.
		"""
		self.frames.append(FileHistoryFrameView(self, filedata=None))

	def insertFrame(self, index, filedata=None):
		"""
		Inserts a frame to the view at the specified index point.
		If the index value is too high the frame is appended onto the end.
		"""
		if index < 0: index = 0
		if index >= len(self.frames): 
			self.frames.append(FileHistoryFrameView(self, filedata=None))
			return
		self.frames[index] = FileHistoryFrameView(self, filedata=None)

	def draw(self):
		"""
		Draws FileHistoryView.
		"""
		pass
