# svs_tracking.visualisation.events

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Objects representing events within a CVS project.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

# external imports
from twisted.spread import pb



#########################
# CLASSES
#########################

class Event(pb.Copyable, pb.RemoteCopy):
	"""
	Generic base class for all events.
	"""
	def __init__(self):
		self.timecode = None

	def setCopyableState(self, state):
		self.__dict__ = state

	def getStateToCopy(self):
		d = self.__dict__.copy()
		return d
	
	def display(self, displayContext=None):
		print "event"
	
# register with perspective broker
pb.setUnjellyableForClass(Event, Event)


class CVSLogEvent(Event):
	"""
	Class for events recorded in the CVS log reports.
	"""
	def __init__(self):
		self.message = None
		self.author = None
		self.revision = None
		self.date = None
		self.state = None
		self.lines = None

	def display(self, displayContext=None):
		print "CVSLogEvent"
		print " date:", self.date
		print " message:", self.message
		print " author:", self.author
		print " revision:", self.revision 
		print " state:", self.state 
		print " lines:", self.lines

# register with perspective broker
pb.setUnjellyableForClass(CVSLogEvent, CVSLogEvent)
