# svs_tracking.extraction.localcvsmanager

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Looks after local copies of files from the CVS and makes these
available to other analysis components.

CVS access is provided by Brent Hendricks's Python CVS Library (pycvs):
U{http://software.cnx.rice.edu/downloads/python/pycvs/}

@author:        Simon Yuill
@copyright:     2005 Simon Yuill
@license:       GNU GPL version 2 or any later version
@contact:       simon@lipparosa.org
"""
# external imports
import os
import cvs

# local imports
from svs_tracking.extraction.cvsdatasource import CVSDataSource
from svs_tracking.analysis.entities import *


#########################
# EXCEPTIONS
#########################
class LocalCVSManagerException(Exception):
	"""
	Generic excpetion class for LocalCVSManager.
	"""
	pass


#########################
# CLASSES
#########################
class LocalCVSManager(CVSDataSource):
	def __init__(self, path):
		CVSDataSource.__init__(self)
		self.path = os.path.abspath(path)
		print "LocalCVSManager:", self.path
		# check if directory exists, create if not
		if not os.path.isdir(self.path):
			os.makedirs(self.path)
		self.wd_handler = None

	def checkout(self, cvsroot, modules):
		"""
		Retrieve files from cvs to local directory,
		and create handler for inspecting them.
		"""
		self.cvsroot = cvsroot
		self.modules = modules
		try:
			cvs.checkout(self.cvsroot, self.modules, None, self.path)
		except:
			raise LocalCVSManagerException("unable to access cvs %s, %s", (self.cvsroot, self.modules))
		self.buildFileMap(self.cvsroot, self.modules)


	def buildFileMap(self, cvsroot=None, modules=None):
		"""
		Creates basic data from cvs files.
		"""
		# check required info is present for cvsroot
		if cvsroot and self.cvsroot:
			if cvsroot is not self.cvsroot:
				raise LocalCVSManagerException("CVSROOT parameter, <%s>, does not match current: %s", (cvsroot, self.cvsroot))
		elif not self.cvsroot:
			self.cvsroot = cvsroot

		# check required info is present for modules
		if modules and self.modules:
			if modules is not self.modules:
				raise LocalCVSManagerException("modules parameter, <%s>, does not match current: %s", (modules, self.modules))
		elif not self.modules:
			self.modules = modules

		# create handler for accessing file data
		try:
			self.wd_handler = cvs.CVSWorkingDir(self.cvsroot, self.modules, self.path)
		except:
			raise LocalCVSManagerException("unable to analyse cvs %s, %s", (self.cvsroot, self.modules))
		
		# build map of files
		self.filemap = makeCVSDirectory(self.path)



	def getLogFor(self, cvsFile):
		"""
		Returns log data for specified file.

		Overrides method in L{CVSDataSource}.
		"""
		print cvsFile.getPath()
		return cvs.log(cvsFile.getPath())
	
	
		



	
