# svs_tracking.extraction.cvslog

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Extracts data from result of log command in CVS.

@author:        Simon Yuill
@copyright:     2005 Simon Yuill
@license:       GNU GPL version 2 or any later version
@contact:       simon@lipparosa.org
"""

class CVSLogExtractor:
	def __init__(self, cvsDataSource):
		self.cvsDataSource = cvsDataSource
		self.translators = None
	
	def addTranslator(self, translator):
		"""
		Adds a new translator to the extractor.
		"""
		if not self.translators:
			self.translators = []
		if translator not in self.translators:
			translator.cvsDataSource = self.cvsDataSource
			self.translators.append(translator)
		
	def extract(self, fileMap):
		"""
		Extracts data from C{fileMap}.
		"""
		if not self.translators or len(self.translators) == 0:
			return
		tmpDir = fileMap
		self.extractFiles(tmpDir.files.values(),)
				
		
	def extractFiles(self, files):
		"""
		Takes a list of files and extracts log data from them
		and translates them into visualisation objects.

		The files are supplied as a list of cvs.CVSFile objects.
		"""
		for tmpfile in files:
			logData = self.cvsDataSource.getLogFor(tmpfile)
			for translator in self.translators:
				translator.translate(logData)
				

