# svs_tracking.extraction.cvsdatasource

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Provides generic methods for accessing data in a CVS.

@author:        Simon Yuill
@copyright:     2005 Simon Yuill
@license:       GNU GPL version 2 or any later version
@contact:       simon@lipparosa.org
"""

# local imports
from svs_tracking.analysis.entities import CVSContributerList


class CVSDataSource:
	"""
	Base class for classes providing data from a CVS.
	"""
	def __init__(self):
		self.filemap = None
		self.contributers = CVSContributerList()
	
	def getFileMap(self):
		"""
		Returns map of files within cvs.
		"""
		return self.filemap
	
	def getContributers(self):
		"""
		Returns list of contributers to cvs.
		"""
		self.contributers
	
	def getLogFor(self, cvsFile):
		"""
		Returns log data for specified file.

		Should be overridden by subclasses.
		"""
		return None
	
	def addContributer(self, contributerName):
		"""
		Adds new author name to contributer list.
		
		Checks is name already present, if so returns
		existing reference, if not, creates a new one.
		"""
		if not self.contributers:
			return contributerName

		return self.contributers.addContributer(contributerName)
