# svs_tracking.analysis.networks

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

"""
Builds network graph of relations between contributers.

@author:	Simon Yuill
@copyright:	2005 Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""
# external imports
from pygraphlib import DGraph

class AnalysisNetwork:
	"""
	Generic base class for network graphs.
	"""
	def __init__(self):
		self.graph = DGraph()
	
	def makeLinksTo(self, primaryNode, otherNodes):
		"""
		Builds graph edges from primary node to other nodes.
		"""
		pass

	def makeLinksBetween(self, nodes):
		"""
		Builds graph edges between nodes.
		"""
		pass
		

class LogEntryNetwork(AnalysisNetwork):
	"""
	Represents interactions between contributers as extracted from log entries.
	"""
	def __init__(self):
		AnalysisNetwork.__init__(self)

	def makeLinksBetween(self, nodes):
		"""
		Builds graph edges between a list of authors in a log entry.
		"""
		pass


class AuthorCodeNetwork(AnalysisNetwork):
	"""
	Represents links between authors and code files.
	"""
	def __init__(self):
		AnalysisNetwork.__init__(self)

	def makeLinksTo(self, primaryNode, otherNodes):
		"""
		Builds graph edges from primary node to other nodes.

		In this case the primary node is a source file from the CVS and
		the other nodes are the authors who have contributed to it.
		"""
		pass

	
	


