// volume-integ.h -- Light integrator interface for volumes
//
//  Copyright (C) 2010  Miles Bader <miles@gnu.org>
//
// This source code is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 3, or (at
// your option) any later version.  See the file COPYING for more details.
//
// Written by Miles Bader <miles@gnu.org>
//

#ifndef __VOLUME_INTEG_H__
#define __VOLUME_INTEG_H__

#include "sample-set.h"

#include "integ.h"


namespace snogray {

class Medium;


class VolumeInteg : public Integ
{
public:

  // Global state for this integrator, for rendering an entire scene.
  //
  class GlobalState : public Integ::GlobalState
  {
  public:

    GlobalState (const Scene &_scene) : Integ::GlobalState (_scene) { }

    // Return a new volume integrator, allocated in context.
    //
    virtual VolumeInteg *make_integrator (RenderContext &context) = 0;
  };

  // Return light generated by the volume between the endpoint of RAY and
  // its origin and arriving at its origin.  MEDIUM is the medium which the
  // ray travels through.  SAMPLE_NUM is the sample to use.
  //
  // "Li" means "Light incoming" (to ray).
  //
  virtual Color Li (const Ray &ray, const Medium &medium,
		    const SampleSet::Sample &sample)
    const = 0;

  // Return the amount by which light travelling from the endpoint of RAY
  // to its origin is attenuated by the intervening volume.  MEDIUM is the
  // medium which the ray travels through.
  //
  virtual Color transmittance (const Ray &ray, const Medium &medium) const = 0;

protected:

  VolumeInteg (RenderContext &_context) : Integ (_context) { }
};


}

#endif // __VOLUME_INTEG_H__
