/*
 * This file is part of smtpmail.
 * 
 * smtpmail is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */



#define OK                  (0)
#define FAIL                (-1)
#define BUFOVER             (-2)
#define CHAR64(c)           (((c) < 0 || (c) > 127) ? -1 : index_64[(c)])
static char basis_64[] =
  "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/???????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????";

int
encode64 (const char *_in, unsigned inlen,
	  char *_out, unsigned outmax, unsigned *outlen)
{

  const unsigned char *in = (const unsigned char *) _in;
  unsigned char *out = (unsigned char *) _out;
  unsigned char oval;
  char *blah;
  unsigned olen;

  olen = (inlen + 2) / 3 * 4;
  if (outlen)
    *outlen = olen;
  if (outmax < olen)
    return BUFOVER;

  blah = (char *) out;
  while (inlen >= 3)
    {
/* user provided max buffer size; make sure we don't go over it */
      *out++ = basis_64[in[0] >> 2];
      *out++ = basis_64[((in[0] << 4) & 0x30) | (in[1] >> 4)];
      *out++ = basis_64[((in[1] << 2) & 0x3c) | (in[2] >> 6)];
      *out++ = basis_64[in[2] & 0x3f];
      in += 3;
      inlen -= 3;
    }
  if (inlen > 0)
    {
/* user provided max buffer size; make sure we don't go over it */
      *out++ = basis_64[in[0] >> 2];
      oval = (in[0] << 4) & 0x30;
      if (inlen > 1)
	oval |= in[1] >> 4;
      *out++ = basis_64[oval];
      *out++ = (inlen < 2) ? '=' : basis_64[(in[1] << 2) & 0x3c];
      *out++ = '=';
    }

  if (olen < outmax)
    *out = '\0';

  return OK;

}
