/*
 * message.c
 * this file contains the functions to create the mail
 * including all headers
 */

/*
 * This file is part of smtpmail.
 * 
 * smtpmail is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Foobar; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <libgen.h>
#include "types.h"

extern int encode64 (const char *_in, unsigned inlen,
		     char *_out, unsigned outmax, unsigned *outlen);

char * 
add_break(char *buff, int orglen)
{
  char *out;
  int i, j=0;
  int newlen = ((orglen / 72) + 1) * 75;
  out = (char*) malloc(newlen);
  for(i = 0; i < orglen; i++)
    {
      out[i+j] = buff[i];
      if(i > 0 && ((i+1) % 71) == 0){
        out[i+j+1] = '\r';
        out[i+j+2] = '\n';
        j+=2;
      }
    }
  j+=2;
  out[i+j+1] = '\r';
  out[i+j+2] = '\n';
  return out;
}

char *
encode_attachment(const char *filename)
{
  char *buff;
  struct stat st;
  FILE *fp;
  int mi, mo;
  char *mbuff;

  stat(filename, &st);
  buff = malloc(st.st_size);
  fp = fopen(filename, "r");
  fread(buff, 1, st.st_size, fp);
  mi = ((st.st_size / 3) + 2) * 4;
  mi = (((mi / 72) + 1) * 2) + mi;
  mbuff = malloc(mi);
  encode64(buff, st.st_size, mbuff, mi, &mo);
  mbuff = add_break(mbuff, mi);
  return mbuff;
}

int
create_plain_body (mail_opt * opts, char **message)
{
  size_t len;
  //fprintf(stderr, "create_plain_body\n");
  if (opts->msg != NULL)
    {
      int mlen;
      int olen;
      char *mbuff;
      char *ctype1 = "Content-Type: text/plain; charset=us-ascii\r\n";
      char *ctype2 = "Content-Transfer-Encoding: base64\r\n\r\n";
      mlen = ((strlen (opts->msg) / 3) + 2) * 4;
      mlen = (((mlen / 72) + 1) * 2) + mlen;
      mbuff = (char *) malloc (mlen);
      encode64 (opts->msg, strlen (opts->msg), mbuff, mlen, &olen);
      mbuff = add_break (mbuff, mlen);
      len = strlen (*message) + strlen ("\r\n") + mlen + strlen (ctype1)
	+ strlen (ctype2);
      if ((*message = (char *) realloc (*message, len)) == NULL)
	{
	  fprintf (stderr, "message - text\n");
	  _exit (1);
	}
      sprintf (*message, "%s%s%s%s\r\n", *message, ctype1, ctype2, mbuff);
    }
  return 0;
}

int
create_mime_body (mail_opt * opts, char **message)
{
  time_t tm;
  char ctype[512];
  size_t len;
  int mlen;
  int olen;
  char *mbuff;
  int i;
  tm = time(NULL);
  //fprintf(stderr, "create_mime_body\n");
  sprintf(ctype, "MIME-Version: 1.0\r\n");
  sprintf(ctype, "%sContent-Type: multipart/mixed;\r\n boundary=\"AA%dBB\"\r\n\r\n\r\n", ctype, tm);
  len = strlen(*message) + strlen(ctype);
  if((*message = (char*) realloc(*message, len)) == NULL)
    {
      fprintf(stderr, "ctype\n");
      _exit(1);
    }
  sprintf(*message, "%s%s", *message, ctype);
  if(opts->msg != NULL)
    {
      char bound[512];
      sprintf(bound, "--AA%dBB\r\n", tm);
      sprintf(bound, "%sContent-Type: text/plain; charset=\"us-ascii\"\r\n", bound);
      sprintf(bound, "%sContent-Transfer-Encoding: base64\r\n\r\n", bound);
      mlen = ((strlen (opts->msg) / 3) + 2) * 4;
      mlen = (((mlen / 72) + 1) * 2) + mlen;
      mbuff = (char *) malloc (mlen);
      encode64 (opts->msg, strlen (opts->msg), mbuff, mlen, &olen);
      mbuff = add_break (mbuff, mlen);
      len = strlen(*message) + strlen(bound) + strlen("\r\n") + strlen(mbuff);
      if((*message = (char*) realloc(*message, len)) == NULL)
	{
	  fprintf(stderr, "bound\n");
	  _exit(1);
	}
      sprintf(*message, "%s%s%s\r\n", *message, bound, mbuff);
      free(mbuff);
    }
  for(i = 0; i < opts->att_count; i++)
    {
      sprintf(ctype, "\r\n--AA%dBB\r\n", tm);
      sprintf(ctype, "%sContent-Type: application/octet-stream; name=\"%s\"\r\n", ctype, 
	      basename(opts->att_names[i]));
      sprintf(ctype, "%sContent-Transfer-Encoding: base64\r\n", ctype);
      sprintf(ctype, "%sContent-Disposition: attachment; filename=\"%s\"\r\n\r\n", ctype, 
	      basename(opts->att_names[i]));
      mbuff = encode_attachment(opts->att_names[i]);
      len = strlen(*message) + strlen(mbuff) + strlen(ctype) + strlen("\r\n");
      if((*message = (char*) realloc(*message, len)) == NULL)
	{
	  fprintf(stderr, "att\n");
	  _exit(1);
	}
      sprintf(*message, "%s%s%s\r\n", *message, ctype, mbuff);
    }
  sprintf(ctype, "\r\n--AA%dBB--\r\n", tm);
  len = strlen(*message) + strlen(ctype);
  if((*message = (char*) realloc(*message, len)) == NULL)
    {
      fprintf(stderr, "end\n");
      _exit(1);
    }
  sprintf(*message, "%s%s", *message, ctype);
  return 0;
}

char *
create_mail (mail_opt * opts)
{
  char *message = NULL;
  char *buff = NULL;
  size_t len = 0;
  unsigned int i;
  /* from */
  if ((message =
       (char *) malloc (strlen ("From: \r\n") + strlen (opts->sender))) ==
      NULL)
    {
      fprintf (stderr, "message - from\n");
      _exit (1);
    }
  sprintf (message, "From: %s\r\n", opts->sender);
  /* to */
  len = 0;
  for (i = 0; i < opts->rcpt_count; i++)
    {
      if (buff != NULL)
	{
	  len = strlen (buff);
	}
      if ((buff =
	   (char *) realloc (buff,
			     len + strlen (opts->rcpt_addr[i]) + 2)) == NULL)
	{
	  fprintf (stderr, "message - to 1\n");
	  _exit (1);
	}
      if (len == 0)
	sprintf (buff, "%s", opts->rcpt_addr[i]);
      else
	sprintf (buff, "%s,%s", buff, opts->rcpt_addr[i]);
    }
  len = strlen (message) + strlen ("To: \r\n") + strlen (buff);
  if ((message = (char *) realloc (message, len)) == NULL)
    {
      fprintf (stderr, "message - to 2\n");
      _exit (1);
    }
  sprintf (message, "%sTo: %s\r\n", message, buff);
  /* CC */
  if (opts->cc_count > 0)
    {
      len = 0;
      free (buff);
      buff = NULL;
      for (i = 0; i < opts->cc_count; i++)
	{
	  if (buff != NULL)
	    len = strlen (buff);
	  if ((buff =
	       (char *) realloc (buff,
				 len + strlen (opts->cc_addr[i]) + 2)) ==
	      NULL)
	    {
	      fprintf (stderr, "message - cc 1\n");
	      _exit (1);
	    }
	  if (len == 0)
	    sprintf (buff, "%s", opts->cc_addr[i]);
	  else
	    sprintf (buff, "%s,%s", buff, opts->cc_addr[i]);
	}
      len = strlen (message) + strlen ("Cc: \r\n") + strlen (buff);
      if ((message = (char *) realloc (message, len)) == NULL)
	{
	  fprintf (stderr, "message - cc 2\n");
	  _exit (1);
	}
      sprintf (message, "%sCc: %s\r\n", message, buff);
    }
  /* bcc */
  if (opts->bcc_count > 0)
    {
      len = 0;
      free (buff);
      buff = NULL;
      for (i = 0; i < opts->bcc_count; i++)
	{
	  if (buff != NULL)
	    len = strlen (buff);
	  if ((buff =
	       (char *) realloc (buff,
				 len + strlen (opts->bcc_addr[i]) + 2)) ==
	      NULL)
	    {
	      fprintf (stderr, "message - bcc 1\n");
	      _exit (1);
	    }
	  if (len == 0)
	    sprintf (buff, "%s", opts->bcc_addr[i]);
	  else
	    sprintf (buff, "%s,%s", buff, opts->bcc_addr[i]);
	}
      len = strlen (message) + strlen ("Bcc: \r\n") + strlen (buff);
      if ((message = (char *) realloc (message, len)) == NULL)
	{
	  fprintf (stderr, "message - bcc 2\n");
	  _exit (1);
	}
      sprintf (message, "%sBcc: %s\r\n", message, buff);
    }
  /* reply */
  if (opts->reply != NULL)
    {
      len =
	strlen (message) + strlen ("Reply-To: \r\n") + strlen (opts->reply);
      if ((message = (char *) realloc (message, len)) == NULL)
	{
	  fprintf (stderr, "message - reply\n");
	  _exit (1);
	}
      sprintf (message, "%sReply-To: %s\r\n", message, opts->reply);
    }
  /* subject */
  if (opts->subj != NULL)
    {
      len = strlen (message) + strlen ("Subject: \r\n") + strlen (opts->subj);
      if ((message = (char *) realloc (message, len)) == NULL)
	{
	  fprintf (stderr, "message - subject\n");
	  _exit (1);
	}
      sprintf (message, "%sSubject: %s\r\n", message, opts->subj);
    }
  else
    {
      len = strlen (message) + strlen ("Subject: (No Subject)\r\n");
      if ((message = (char *) realloc (message, len)) == NULL)
	{
	  fprintf (stderr, "message - subject\n");
	  _exit (1);
	}
      sprintf (message, "%sSubject: (No Subject)\r\n", message);
    }
  /* text */
  //fprintf(stderr, "atts: %d\n", opts->att_count);
  if(opts->att_count == 0)
    create_plain_body(opts, &message);
  else
    create_mime_body(opts, &message);
  return message;
}
