/**
 * @file  imgs.c
 * @copyright Copyright (C) 2019-2020 Michal Babik
 *
 * This file is part of Small File Renamer.
 *
 * Small File Renamer is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Small File Renamer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Small File Renamer.  If not, see <https://www.gnu.org/licenses/>.
 *
 * @brief  Application graphics
 *
 * @author Michał Bąbik <michalb1981@o2.pl>
 */
#include "imgs.h"
/*----------------------------------------------------------------------------*/
/**
 * @brief  Icon data structure
 */
typedef struct Icon {
  int           width;                        /**< Image width */
  int           height;                       /**< Image height */
  int           bytes_per_pixel;              /**< 2:RGB16, 3:RGB, 4:RGBA */ 
  unsigned char pixel_data[16 * 16 * 4 + 1];  /**< Image data */
} Icon;
/*----------------------------------------------------------------------------*/
/**
 * @brief  Add icon
 */
static const Icon icon_add = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000+K'\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\061M.\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000(G%\213i\262_\377i\256`\377m\257d\377t\266k\377/I+\213"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\070b\063\200\221\367\204\377\221\361\205\377\226\363\212\377\240\374"
  "\224\377Ae<\200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\070a\062\200\217\364\201\377\217\356\203\377\224\357"
  "\210\377\236\371\222\377Ac<\200\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000$"
  "H\040\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\066^\061|\216\364\201\377\217\356\202"
  "\377\224\360\210\377\235\371\221\377?a:|\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\067N\064\001\000\000\000\000\"D\036\213\061_+\200\062_-\200\064].|Bt;\277\216\364\201\377"
  "\217\355\202\377\223\360\207\377\235\371\220\377MxH\277Ab<|De@\200GgC\200"
  "\065J\061\213\000\000\000\000\000\000\000\000V\254K\377|\357m\377\200\356q\377\204\360v\377"
  "\211\362{\377\211\353|\377\216\355\201\377\223\357\206\377\226\360\213\377"
  "\241\372\225\377\246\374\232\377\253\375\237\377\262\377\247\377\203\274"
  "|\377\000\000\000\000\000\000\000\000S\246H\377x\347i\377{\347m\377\200\350r\377\204\352"
  "w\377\211\353|\377\216\356\200\377\222\357\206\377\227\361\213\377\233\363"
  "\220\377\240\364\225\377\245\366\232\377\254\373\241\377\177\266w\377\000\000"
  "\000\000\000\000\000\000S\246H\377w\347h\377{\347l\377\177\350q\377\204\352v\377\210"
  "\353|\377\215\355\200\377\222\357\206\377\226\360\212\377\233\362\217\377"
  "\240\364\224\377\244\365\232\377\253\372\240\377\177\266w\377\000\000\000\000\000\000"
  "\000\000V\253J\377{\357k\377~\356o\377\203\360t\377\207\361y\377\210\353z\377"
  "\215\355\177\377\221\356\205\377\226\360\211\377\237\372\224\377\244\374"
  "\231\377\251\375\236\377\260\377\245\377\202\273{\377\000\000\000\000\000\000\000\000\"D"
  "\035\213\061_+\200\062^,\200\063]-|Ar:\277\214\363~\377\214\355\200\377\221\356"
  "\204\377\233\370\216\377KwF\277@b;|Ce?\200GgA\200\064J\061\213\000\000\000\000$H\037"
  "\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\065^/|\213\362}\377\214\354\177\377\220"
  "\357\204\377\232\370\215\377=a\071|\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\066N\064"
  "\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\066`\060\200\213\363}\377\213\354"
  "\177\377\220\357\203\377\231\367\215\377?c:\200\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\067a\061\200\214\365"
  "~\377\215\357\200\377\222\361\205\377\233\372\216\377?d:\200\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000'F#\213"
  "d\260[\377e\254[\377h\255_\377o\265f\377.H*\213\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000*J%\001\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\060L,\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Add dir icon
 */
static const Icon icon_add_dir = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\323\323j\000rr\067\021\234\234O#\234\234R#\234"
  "\234U#\234\234Y#rrA\021\323\323|\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\264\264Zn\347\347w\332\353\353~\334\353"
  "\353\203\334\347\347\205\332\264\264hn\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\306\306b\200\373\373\200\376"
  "\377\377\207\377\377\377\215\377\373\373\216\376\306\306q\200\000\000\000\001\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\306"
  "\306`\200\372\372~\376\377\377\205\377\377\377\212\377\372\372\214\376\306"
  "\306o\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\323\323N\000\000\000\000\002\000\000"
  "\000\001\000\000\000\001\000\000\000\003\305\305]\200\372\372{\375\377\377\202\377\377\377\207"
  "\377\372\372\212\375\305\305m\200\000\000\000\003\000\000\000\001\000\000\000\001\000\000\000\002\323\323"
  "\205\000rr&\021\264\264Cn\306\306M\200\306\306Q\200\305\305T\200\321\321`\277"
  "\373\373y\376\377\377\200\377\377\377\205\377\373\373\210\376\321\321s\277"
  "\305\305p\200\306\306t\200\306\306y\200\264\264pnrrF\021\234\234\067#\347\347"
  "V\332\373\373b\376\372\372g\376\372\372l\375\373\373q\376\377\377x\377\377"
  "\377}\377\377\377\202\377\377\377\207\377\373\373\212\376\372\372\217\375"
  "\372\372\223\376\373\373\231\376\347\347\220\332\234\234a#\234\234\065#\353"
  "\353V\334\377\377a\377\377\377f\377\377\377l\377\377\377q\377\377\377v\377"
  "\377\377{\377\377\377\200\377\377\377\205\377\377\377\212\377\377\377\217"
  "\377\377\377\224\377\377\377\231\377\353\353\220\334\234\234_#\234\234\063"
  "#\353\353S\334\377\377_\377\377\377d\377\377\377i\377\377\377n\377\377\377"
  "s\377\377\377x\377\377\377}\377\377\377\202\377\377\377\207\377\377\377\214"
  "\377\377\377\221\377\377\377\226\377\353\353\216\334\234\234]#\234\234\062"
  "#\347\347P\332\373\373[\376\372\372`\376\372\372e\375\373\373j\376\377\377"
  "q\377\377\377v\377\377\377z\377\377\377\200\377\373\373\203\376\372\372\207"
  "\375\372\372\214\376\373\373\221\376\347\347\211\332\234\234\\#rr!\021\264"
  "\264;n\306\306E\200\306\306I\177\305\305L\200\321\321V\277\373\373m\376\377"
  "\377s\377\377\377x\377\373\373{\376\321\321i\277\305\305h\200\306\306l\177"
  "\306\306q\200\264\264inrrA\021\323\323E\000\000\000\000\002\000\000\000\001\000\000\000\001\000\000\000\003"
  "\305\305O\200\372\372j\375\377\377q\377\377\377u\377\372\372x\375\305\305"
  "_\200\000\000\000\003\000\000\000\001\000\000\000\001\000\000\000\002\323\323}\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\001\306\306N\200\372\372g\376\377\377n\377\377\377s\377\372"
  "\372u\376\306\306]\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\306\306L\200\373\373e\376\377\377k\377\377"
  "\377p\377\373\373s\376\306\306\\\200\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\002\264\264Cn\347\347Z\332\353\353"
  "a\334\353\353e\334\347\347h\332\264\264Qn\000\000\000\002\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\323\323N\000rr&\021\234\234:#\234\234"
  "=#\234\234@#\234\234C#rr\061\021\323\323`\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Remove icon
 */
static const Icon icon_remove = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000Q\031\031\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000Q$$\001\000\000\000\000M\030"
  "\030\213k\"\"\200i##\200i$%\200i%%\200i''\200i((\200i**\200i++\200i,,\200"
  "i..\200i./\200k\060\060\200M\"\"\213\000\000\000\000\000\000\000\000\300;;\377\377UU\377\377"
  "WX\377\377Z[\377\377^^\377\377aa\377\377dd\377\377gh\377\377kk\377\377nn"
  "\377\377qq\377\377ut\377\377vv\377\300UU\377\000\000\000\000\000\000\000\000\272\071\070\377"
  "\377QQ\377\377ST\377\377WW\377\377ZZ\377\377]]\377\377``\377\377cc\377\377"
  "gf\377\377ji\377\377mm\377\377pp\377\377rr\377\272SS\377\000\000\000\000\000\000\000\000"
  "\272\070\067\377\377PP\377\377SR\377\377UU\377\377YX\377\377\\\\\377\377__"
  "\377\377bb\377\377ee\377\377hh\377\377lk\377\377oo\377\377ss\377\272SS\377"
  "\000\000\000\000\000\000\000\000\300\071\071\377\377RR\377\377TT\377\377WW\377\377[Z\377\377"
  "^^\377\377aa\377\377dd\377\377gg\377\377kk\377\377nn\377\377qq\377\377vv"
  "\377\300UU\377\000\000\000\000\000\000\000\000M\027\027\213k\040\040\200i!!\200i\"\"\200i$$\200"
  "i%%\200i&&\200i((\200i)(\200i**\200i++\200i--\200k//\200M\"\"\213\000\000\000\000"
  "Q\030\030\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000Q$$\001\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Revert icon
 */
static const Icon icon_rev = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\000\000\000\001"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000)\000\000\000\030\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\017*X#\022\061c\244\005\026\063\064\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\014\"S\236\216(`\264\342\021\062c\065\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\001\035G\213O\061"
  "s\325\350.q\313\350\017\060Z\066\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\021.a\037*c\273\300\067\204\353"
  "\377.y\320\361\031S\205\216\031Y\210q\025RyP\012\065O#\000\000\000\005\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\005#T\241u\064|\341\367\067\215\361\377"
  "\064\221\352\377\060\223\341\373\060\231\341\373-\230\330\363%\211\276\320\033"
  "o\227w\012=S\035\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\031?~//o\316\325\067"
  "\210\357\377\066\223\361\377\065\234\361\377\064\244\362\377\063\252\362\377"
  "\062\260\362\377\061\262\357\377-\252\341\367\"\214\265\267\024b~\071\000\000\000\002"
  "\000\000\000\000\000\000\000\000\000\000\000\010&Z\254\216\066\200\346\373\067\220\361\377\065\231"
  "\361\377\064\242\361\377\063\252\362\377\062\260\362\377\061\266\362\377\061\272"
  "\362\377\060\276\363\377.\272\353\377!\220\265\300\006\061@\033\000\000\000\000\000\000\000"
  "\000\035F\212\070\061t\326\337\067\213\360\377\066\226\361\377\065\237\361\377\063"
  "\246\356\377/\245\344\374.\252\343\374.\264\351\377/\276\360\377/\304\363"
  "\377/\306\362\377#\237\302\333\007:I%\000\000\000\000\002\002\033\012'^\262\230\066\202\351"
  "\375\067\221\361\377\065\234\361\377\064\246\361\377,\230\326\363\031g\217\225"
  "\030h\213z\033y\233\235#\232\277\321*\272\341\367.\312\360\377#\244\303\332"
  "\006;G%\000\000\000\000\024\064j\071+g\300\341\063\201\340\377\063\221\350\377\064\240\357"
  "\377\063\254\362\377)\227\316\347\014AZ\067\000\000\000\001\000\000\000\007\011AQ$\031\177\227"
  "v%\260\315\332\040\237\270\332\010DO%\000\000\000\002\003\017'N\021\062b\235\026Dw\254\033"
  "Z\216\313$|\264\352,\241\333\375'\231\312\350\016Kc\065\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\005\022n~<\020es\227\002%+\"\000\000\000\000\000\000\000\005\000\000\000\010\000\000\000\014\000\000\000"
  "\034\006*>F\024^~\237\027l\214\321\007\065F\065\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\024\000\000\000\010\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\017\002\031\"E\000\000\000\034\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\001\000\000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};

/**
 * @brief  Sort icon
 */
static const Icon icon_srt = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\065\071Q\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000CGf\002\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\062"
  "\066M\213~\206\300\377|\203\274\377Y_\210\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000GLm\203"
  "\265\300\377\377\261\274\377\377\200\210\302\377\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\035\037.=HLo\177HMm|\064\067O\210\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\071\000\000\000\065\000\000\000\065\000\000\000\062\000\000\000"
  "/\000\000\000/\000\000\000\063\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000hs\277\377\226\244\377\377\232\246\377\377\236\253\377\377"
  "\245\260\377\377\254\267\377\377~\206\300\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000ep\277\377\221\240\377\377\226"
  "\243\377\377\233\250\377\377\240\254\377\377\247\263\377\377}\204\300\377"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\033\037@\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\063\000\000\000/\000\000\000/\000\000\000/\000\000\000/\000\000\000/\000\000\000\063\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\022\025,@/\066l\203\060\067h\200\062\070h\200\065<k|\070>k|:"
  "@k|<Ak|>Cl|BFm|\061\065N\210\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000-\064m\204"
  "u\207\377\377w\210\377\377|\215\377\377\202\221\377\377\207\226\377\377\215"
  "\233\377\377\221\240\377\377\227\244\377\377\237\253\377\377v\177\302\377"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\032\037BeDP\245\320FP\240\313IS\240"
  "\313LV\240\313OY\240\313S[\240\313V_\240\313Yb\240\313^f\242\313FKu\335\000"
  "\000\000\000\026\033C\001\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000'*C\003\000\000\000\000&/t\335"
  "\065B\241\313\066C\237\313:F\237\313=I\237\313AL\237\313DN\240\313GQ\240\313"
  "JU\240\313NW\240\313QZ\240\313T\\\240\313Xa\242\313BHt\335\000\000\000\000\000\000\000"
  "\000?N\275\377Vk\377\377Vj\377\377\\o\377\377`s\377\377fy\377\377k}\377\377"
  "p\202\377\377u\206\377\377{\213\377\377\200\217\377\377\206\225\377\377\215"
  "\233\377\377is\276\377\000\000\000\000\000\000\000\000&/t\335\065B\241\313\065A\237\313\066"
  "B\237\313\071E\237\313<H\237\313@K\237\313CN\237\313FQ\240\313JT\240\313M"
  "V\240\313PZ\240\313T]\241\313?Et\335\000\000\000\000\026\033C\001\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000%(C\001",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Select icon
 */
static const Icon icon_select = {
  16, 16, 4,
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364\026V\000\377\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\026V\000\377B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377\377\377\000"
  "\377\377\377\000\026V\000\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364B\377"
  "\000\364B\377\000\364\026V\000\377\377\377\377\000\377\377\377\000\026V\000\377B\377\000"
  "\364\026V\000\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\026V\000\377B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377\377\377"
  "\000\377\377\377\000\026V\000\377B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377"
  "\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364B\377\000\364B\377"
  "\000\364\026V\000\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\026V\000\377B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377\377\377\000\026V\000"
  "\377B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377"
  "\000\364B\377\000\364B\377\000\364\026V\000\377B\377\000\364B\377\000\364B\377\000\364\026"
  "V\000\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364B\377\000"
  "\364B\377\000\364B\377\000\364B\377\000\364\026V\000\377\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364B\377\000\364"
  "B\377\000\364\026V\000\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377B\377\000\364\026V\000\377"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\026V\000\377\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  B/W select icon
 */
static const Icon icon_select_bw = {
  16, 16, 4,
  "\364\364\364\000\364\364\364\000\366\366\366\000\365\365\365\000\366\366\366\000\364"
  "\364\364\000\364\364\364\000\366\366\366\000\365\365\365\000\367\367\367\000\365\365"
  "\365\000\370\370\370\000\371\371\371\000\366\366\366\000\364\364\364\000\364\364\364"
  "\000\367\367\367\000\363\363\363\000\364\364\364\000\370\370\370\000\363\363\363\000"
  "\366\366\366\000\367\367\367\000\363\363\363\000\363\363\363\000\371\371\371\000\371"
  "\371\371\000\370\370\370\000\366\366\366\000\367\367\367\000\370\370\370\000\364\364"
  "\364\000\365\365\365\000\366\366\366\000\367\367\367\000\366\366\366\000\365\365\365"
  "\000\364\364\364\000\367\367\367\000\364\364\364\000\364\364\364\000\367\367\367\000"
  "\370\370\370\000\370\370\370\000\371\371\371\000uuu\377\374\374\374\000\374\374\374"
  "\000\364\364\364\000\364\364\364\000\372\372\372\000\370\370\370\000\366\366\366\000"
  "\370\370\370\000\366\366\366\000\364\364\364\000\365\365\365\000\365\365\365\000\366"
  "\366\366\000\371\371\371\000\200\200\200\377\377\377\377\364\\\\\\\377\377\377"
  "\377\000\365\365\365\000\367\367\367\000\366\366\366\000\370\370\370\000\365\365\365"
  "\000\370\370\370\000\371\371\371\000\367\367\367\000\371\371\371\000\365\365\365\000"
  "\370\370\370\000\\\\\\\377\377\377\377\364\367\367\367\364\367\367\367\364"
  "ccc\377\367\367\367\000\371\371\371\000\\\\\\\377\374\374\374\000\374\374\374\000"
  "\364\364\364\000\372\372\372\000\371\371\371\000\370\370\370\000\372\372\372\000\\"
  "\\\\\377\373\373\373\364\377\377\377\364\377\377\377\364VVV\377\377\377\377"
  "\000\372\372\372\000ccc\377\373\373\373\364\\\\\\\377\374\374\374\000\370\370\370"
  "\000\372\372\372\000\371\371\371\000\370\370\370\000ccc\377\373\373\373\364\367\367"
  "\367\364\365\365\365\364\\\\\\\377\377\377\377\000\377\377\377\000kkk\377\373"
  "\373\373\364\364\364\364\364\367\367\367\364VVV\377\377\377\377\000\372\372"
  "\372\000\372\372\372\000kkk\377\364\364\364\364\365\365\365\364\365\365\365\364"
  "VVV\377\377\377\377\000\377\377\377\000\370\370\370\000\377\377\377\000\\\\\\\377"
  "\373\373\373\364\363\363\363\364\365\365\365\364ccc\377\377\377\377\000\\\\"
  "\\\377\373\373\373\364\364\364\364\364\367\367\367\364VVV\377\372\372\372"
  "\000\374\374\374\000\371\371\371\000\370\370\370\000\370\370\370\000\377\377\377\000"
  "\\\\\\\377\367\367\367\364\363\363\363\364\363\363\363\364VVV\377\377\377"
  "\377\364\373\373\373\364\365\365\365\364VVV\377\377\377\377\000\374\374\374"
  "\000\370\370\370\000\370\370\370\000\371\371\371\000\374\374\374\000\370\370\370\000"
  "\377\377\377\000\\\\\\\377\367\367\367\364\373\373\373\364\365\365\365\364"
  "\365\365\365\364\364\364\364\364VVV\377\374\374\374\000\374\374\374\000\374\374"
  "\374\000\370\370\370\000\372\372\372\000\371\371\371\000\366\366\366\000\370\370\370"
  "\000\372\372\372\000\377\377\377\000ccc\377\367\367\367\364\363\363\363\364\367"
  "\367\367\364VVV\377\377\377\377\000\377\377\377\000\374\374\374\000\367\367\367"
  "\000\372\372\372\000\367\367\367\000\367\367\367\000\364\364\364\000\366\366\366\000"
  "\370\370\370\000\370\370\370\000\372\372\372\000VVV\377\364\364\364\364VVV\377"
  "\374\374\374\000\377\377\377\000\372\372\372\000\367\367\367\000\370\370\370\000\370"
  "\370\370\000\370\370\370\000\372\372\372\000\371\371\371\000\367\367\367\000\370\370"
  "\370\000\367\367\367\000\371\371\371\000\374\374\374\000uuu\377\377\377\377\000\377"
  "\377\377\000\374\374\374\000\370\370\370\000\372\372\372\000\371\371\371\000\371\371"
  "\371\000\365\365\365\000\363\363\363\000\364\364\364\000\370\370\370\000\364\364\364"
  "\000\371\371\371\000\371\371\371\000\365\365\365\000\372\372\372\000\374\374\374\000"
  "\371\371\371\000\367\367\367\000\374\374\374\000\363\363\363\000\371\371\371\000\363"
  "\363\363\000\371\371\371\000\365\365\365\000\363\363\363\000\366\366\366\000\365\365"
  "\365\000\365\365\365\000\370\370\370\000\370\370\370\000\372\372\372\000\371\371\371"
  "\000\370\370\370\000\365\365\365\000\370\370\370\000\364\364\364\000\372\372\372\000"
  "\370\370\370\000\364\364\364\000\366\366\366\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Blue select icon
 */
static const Icon icon_select_bl = {
  16, 16, 4,
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\000OV\377\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\000OV\377\000\354\377\364\000OV\377\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\000OV\377\000\354\377\364\000\354\377\364\000\354\377\364\000OV\377\377\377"
  "\377\000\377\377\377\000\000OV\377\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\000OV\377\000\354\377\364"
  "\000\354\377\364\000\354\377\364\000OV\377\377\377\377\000\377\377\377\000\000OV\377"
  "\000\354\377\364\000OV\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\000OV\377\000\354\377\364\000\354\377\364\000\354\377\364\000"
  "OV\377\377\377\377\000\377\377\377\000\000OV\377\000\354\377\364\000\354\377\364\000"
  "\354\377\364\000OV\377\377\377\377\000\377\377\377\000\377\377\377\000\000OV\377\000"
  "\354\377\364\000\354\377\364\000\354\377\364\000OV\377\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\000OV\377\000\354\377\364\000\354\377\364\000\354"
  "\377\364\000OV\377\377\377\377\000\000OV\377\000\354\377\364\000\354\377\364\000\354"
  "\377\364\000OV\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\000OV\377\000\354\377\364\000\354\377\364\000\354\377"
  "\364\000OV\377\000\354\377\364\000\354\377\364\000\354\377\364\000OV\377\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\000OV\377\000\354\377\364\000\354\377\364\000\354\377"
  "\364\000\354\377\364\000\354\377\364\000OV\377\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\000OV\377\000\354\377\364\000\354\377\364\000"
  "\354\377\364\000OV\377\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\000OV\377\000\354\377\364\000OV\377"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\000OV\377\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377"
  "\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377"
  "\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377"
  "\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000\377\377\377\000"
  "\377\377\377\000\377\377\377\000\377\377\377\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Duplicates icon
 */
static const Icon icon_dupl = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\034\003\003\000=\013\013\000<\013\013\000<\013\013"
  "\000=\013\013\000\034\003\003\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\277\216a\377\335\244o\377\334\243l\377\334\242j\377\314\226a\334\211"
  "d?\"\211d?\"\314\226a\334\334\242i\377\334\242i\377\335\242i\377\277\214"
  "Z\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\335\245r\377\377\277\203\377\377\276"
  "\200\377\377\275}\377\353\256q\334\236sI\"\236sJ\"\353\255q\334\377\274{"
  "\377\377\274{\377\377\275{\377\335\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\334\245t\377\377\300\205\377\377\276\202\377\377\275\177\377\353\256s"
  "\334\235rJ\"\235rI\"\353\255q\334\377\274{\377\377\274{\377\377\274{\377"
  "\334\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\246v\377\377\300\207\377"
  "\377\277\204\377\377\276\202\377\353\256u\334\235sK\"\235rI\"\353\255q\334"
  "\377\274{\377\377\274{\377\377\274{\377\334\242i\377\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\334\247x\377\377\301\212\377\377\300\207\377\377\277\204\377"
  "\353\257w\334\235tM\"\235rI\"\353\255q\334\377\274{\377\377\274{\377\377"
  "\274{\377\334\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\247z\377\377\302"
  "\214\377\377\300\211\377\377\300\206\377\353\260y\334\235tN\"\235sI\"\353"
  "\255q\334\377\274{\377\377\274{\377\377\274{\377\334\242i\377\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\334\250|\377\377\302\216\377\377\301\213\377\377\300"
  "\210\377\353\260{\334\235tP\"\235sK\"\353\256s\334\377\274{\377\377\274{"
  "\377\377\274{\377\334\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\250~\377"
  "\377\303\220\377\377\302\215\377\377\301\213\377\353\261}\334\235uQ\"\235"
  "sM\"\353\256u\334\377\275}\377\377\274{\377\377\274{\377\334\242i\377\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\251\200\377\377\304\223\377\377\302\217"
  "\377\377\302\215\377\353\262\177\334\235uR\"\235tN\"\353\257w\334\377\276"
  "\200\377\377\275}\377\377\274{\377\334\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\334\251\202\377\377\304\225\377\377\303\222\377\377\302\217\377\353"
  "\262\201\334\235vT\"\235tO\"\353\260y\334\377\276\202\377\377\275\177\377"
  "\377\275}\377\334\242i\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\252\203\377"
  "\377\305\227\377\377\304\224\377\377\303\221\377\353\263\204\334\235vU\""
  "\235uP\"\353\260{\334\377\277\204\377\377\276\201\377\377\276\177\377\334"
  "\242j\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\334\253\205\377\377\306\231\377"
  "\377\304\226\377\377\304\224\377\353\264\206\334\235wW\"\235uR\"\353\261"
  "}\334\377\300\206\377\377\277\203\377\377\276\201\377\334\243l\377\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\335\254\210\377\377\307\234\377\377\306\231\377"
  "\377\305\226\377\353\265\210\334\236xY\"\236wT\"\353\262\177\334\377\301"
  "\211\377\377\300\206\377\377\277\203\377\335\244o\377\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\277\224v\377\335\253\207\377\334\253\204\377\334\252\202\377"
  "\314\234w\334\211hN\"\211gI\"\314\232o\334\334\246w\377\334\245t\377\335"
  "\245r\377\277\216`\377\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\034\006\006\000=\025\025\000<\025\025\000<\025\025\000=\025\025\000\034\006\006\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Info icon
 */
static const Icon icon_info = {
  16, 16, 4,
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\\333\010\000\\\333/\000\\\333\065\000"
  "\\\333\062\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\\333\063\000\\\333\325\000\\\333\354\000\\\333"
  "\304\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\\333P\000\\\333\347\000\\\333\360\000\\\333\235"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\\\333#\000\\\333K\000\\\333K\000\\\333'\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\\\333\013\000\\\333\207\000\\\333\270\000\\\333\253\000\\\333-\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\\\333\036\000\\\333\323\000\\\333\377\000\\\333\337\000\\\333*\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\\\333\070\000\\\333\351\000\\\333\377\000\\\333\303\000\\\333\024\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\\\333[\000\\\333\367\000\\\333\377\000\\\333\237\000\\\333\007\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\"
  "\334\004\000\\\333\213\000\\\333\376\000\\\333\372\000\\\333m\000Z\332\001\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\"
  "\333\016\000\\\333\265\000\\\333\377\000\\\333\357\000\\\333E\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\"
  "\333\040\000\\\333\324\000\\\333\377\000\\\333\334\000\\\333'\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\"
  "\333:\000\\\333\353\000\\\333\377\000\\\333\300\000\\\333\022\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\"
  "\332T\000\\\333\337\000\\\333\346\000\\\333\215\000\\\332\006\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\\\333"
  "\025\000\\\333/\000\\\333/\000\\\333\031\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000"
  "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000",
};
/*----------------------------------------------------------------------------*/
static const struct {
  int 	         width;
  int 	         height;
  int 	         bytes_per_pixel; /* 2:RGB16, 3:RGB, 4:RGBA */ 
  unsigned char	 pixel_data[93 * 120 * 3 + 1];
} image_about = {
  93, 120, 3,
  "Kq\217Oo\212!Y~\022T{No\213Zv\220\\y\222\000Nw^y\223Vt\217;d\205\\y\222-^\177"
  "\031V{([\177f\177\230&Z~\036V{\035V{\035W|%X}\032W{$Y~\067b\202\035W|+[\177?f\205"
  "Us\217\003RxRr\216Kn\212\036X|^y\223-]\177\061^\201\064`\202\065`\202\065`\202\065"
  "`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065"
  "`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065"
  "`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065"
  "`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065"
  "`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065"
  "`\202\065`\202\065`\202\065`\202\065`\202\065`\202\065`\202\064_\202\063^\200=h\211"
  "b~\226\225\243\261\232\250\265\214\235\254\200\221\241n\201\225v\211\233"
  "\000\065f\206\226\246x\211\234l\200\225\177\220\240\227\244\263j}\223@`~\245"
  "\262\276\241\255\272\222\240\257\214\233\252\223\243\260\234\252\266\235"
  "\253\270\233\247\263o\202\227\000>is\207\231|\217\241q\205\231\000Bll\200\226"
  "e{\221\025Nq{\216\242\035Or\000Fn\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000I"
  "o\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000I"
  "o\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000I"
  "o\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Io\000Hn'Y}\000S{Ws\212Di\205Ss\216Hg\205"
  "Ac\201Ih\204\000\000I\000Dm\000;kIg\204Jh\204Po\211\000=k\000\000O\066a\177Lk\207&Y|\061"
  "\\|Zv\217Eh\205Kl\210Bd\202\000%b\000\000@\000Kt\000Ls\000\062h\000\064fOl\207\040Tx\000$`\000"
  "Am\000\000Q\000\000Q\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S"
  "\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000"
  "\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000"
  "S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000\000S\000"
  "\000S\000\000V\000<m\203\225\246\277\305\316\267\276\306\265\275\307\266\275\307"
  "\266\276\310\271\301\311\267\300\310\271\300\312\270\277\307\267\300\310"
  "\266\277\310\266\276\310\270\277\311\270\300\310\267\276\310\266\275\307"
  "\266\275\307\266\275\307\265\275\307\265\274\307\265\275\307\267\276\310"
  "\271\300\310\272\301\311\271\300\312\271\300\310\271\300\312\271\300\312"
  "\270\301\311\270\300\311\271\300\312\272\301\313\273\302\312\274\303\313"
  "\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313"
  "\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313"
  "\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313"
  "\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313"
  "\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313"
  "\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313"
  "\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313"
  "\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313"
  "\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313\274\303\313"
  "\274\303\313\275\304\314\302\312\321\211\230\252\274\300\307\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\274\301\310\260\270\301\377\377\377\371\371\372\371\370\372\373\371\375"
  "\373\371\375\371\370\373\367\370\371\367\370\371\370\370\371\370\371\371"
  "\367\370\371\367\370\371\367\370\371\370\370\372\371\371\373\371\371\373"
  "\370\370\372\367\370\371\367\370\371\370\371\371\370\370\371\367\370\371"
  "\367\370\371\370\371\371\372\372\371\372\372\371\370\371\371\367\370\371"
  "\367\370\371\370\370\371\370\371\371\367\370\371\367\370\371\367\370\371"
  "\367\372\372\367\372\373\367\371\372\367\370\371\367\370\371\367\370\371"
  "\370\371\371\370\370\371\367\370\371\367\370\371\367\370\371\371\372\372"
  "\372\373\372\371\371\372\367\370\371\367\370\371\367\370\371\367\370\371"
  "\370\371\371\371\371\371\370\371\371\367\370\371\367\370\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370"
  "\367\370\371\370\371\372\377\377\377\260\270\301\256\266\277\377\377\377"
  "\370\370\372\371\367\374\341\356\342\332\354\333\370\367\373\367\367\371"
  "\366\367\370\366\367\370\362\363\364\367\370\371\366\367\370\367\367\371"
  "\366\367\370\362\364\365\346\360\347\366\367\371\366\367\370\367\370\371"
  "\362\363\364\365\366\367\366\367\370\366\367\370\372\372\371\354\356\361"
  "\357\360\363\373\372\371\366\367\370\366\367\370\365\366\366\362\363\364"
  "\367\370\371\366\367\370\366\371\372\363\365\366\363\360\361\363\366\367"
  "\366\371\372\366\367\370\367\370\371\362\363\364\365\366\370\366\367\370"
  "\366\367\367\370\371\370\367\370\367\340\340\353\364\364\365\367\370\370"
  "\365\366\367\365\366\367\367\367\367\363\365\366\340\345\363\367\367\370"
  "\366\367\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\367\370\370\377\377\377"
  "\256\266\277\256\266\277\377\377\377\370\370\372\361\364\364\215\334\202"
  "\204\342x\355\362\360\370\367\372\367\370\371\345\346\347\301\302\306\361"
  "\362\365\366\367\370\367\370\371\315\345\314\227\335\220\317\351\316\367"
  "\370\372\366\367\370\365\366\367\305\306\310\340\341\344\367\370\371\367"
  "\370\370\367\367\366\205\253\343q\264\341\355\362\363\370\370\370\367\370"
  "\371\342\343\345\303\306\310\363\364\367\366\367\370\366\371\372\352\276"
  "\277\353xv\352\311\312\366\371\372\366\367\370\363\364\365\301\304\306\344"
  "\345\347\367\370\371\367\367\370\370\371\370\316\321\346\235\244\324\360"
  "\361\363\367\370\370\365\366\367\365\366\367\370\370\370\337\346\363\264"
  "\304\354\370\371\370\366\367\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\367"
  "\370\370\377\377\377\256\266\277\256\266\277\377\377\377\370\370\372\372"
  "\367\374\333\352\332\322\350\321\371\367\373\367\367\371\366\367\370\366"
  "\367\370\360\361\362\367\370\371\366\367\370\370\367\372\356\363\361\333"
  "\355\334\367\367\371\367\367\372\366\366\370\367\370\371\360\363\364\365"
  "\366\367\366\367\370\367\367\370\366\366\366\316\330\347\326\345\353\364"
  "\365\366\367\367\370\366\367\370\365\366\367\360\361\364\367\370\371\366"
  "\367\370\366\371\372\363\362\363\362\352\353\363\363\364\366\371\372\366"
  "\367\370\367\370\371\360\361\362\367\370\370\366\367\370\367\370\370\357"
  "\360\365\271\275\340\274\301\341\364\365\366\367\370\370\365\366\367\365"
  "\366\367\367\370\370\351\354\365\337\344\363\371\371\370\366\367\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\367\370\370\377\377\377\256\266\277\256"
  "\266\277\377\377\377\367\370\371\367\367\371\372\370\374\370\370\372\367"
  "\367\372\366\366\370\365\366\367\366\367\370\366\367\370\366\367\370\365"
  "\366\367\366\366\370\370\367\372\370\367\373\367\367\371\366\366\370\365"
  "\366\367\366\366\367\366\367\370\366\367\370\365\366\367\366\366\367\367"
  "\370\370\372\372\371\372\372\371\370\370\370\366\366\367\366\367\370\367"
  "\370\371\370\371\372\370\371\371\367\370\371\367\370\371\367\372\373\367"
  "\372\373\367\371\372\366\370\371\366\367\370\367\370\371\370\371\371\370"
  "\371\372\367\370\371\367\370\371\371\372\371\371\374\371\373\374\372\372"
  "\373\372\367\370\371\366\367\370\367\370\370\367\370\371\371\371\371\371"
  "\371\370\367\370\370\366\367\370\366\367\370\366\367\370\366\367\370\366"
  "\367\370\366\367\370\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\367"
  "\370\370\377\377\377\256\266\277\256\266\277\377\377\377\367\370\370\365"
  "\366\367\366\366\370\366\366\370\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\366\366\367\366\366\367\365"
  "\366\367\365\366\367\366\367\370\366\367\366\352\353\356\366\367\367\370"
  "\371\371\370\371\371\370\371\372\371\372\373\370\371\372\372\373\374\371"
  "\373\374\372\373\374\370\371\372\357\360\360\364\365\367\372\373\373\370"
  "\370\370\370\371\371\365\364\364\367\367\370\371\372\373\373\373\374\367"
  "\370\371\367\370\371\371\371\374\370\372\373\371\372\372\367\370\371\370"
  "\371\374\371\372\372\371\372\373\371\372\372\367\370\372\370\370\371\366"
  "\367\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\367\370\370\377\377\377\256\266\277\256"
  "\266\277\377\377\377\367\370\370\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\367\370\371\354"
  "\353\354\303\306\313\326\331\331\307\310\316\304\303\306\313\320\323\344"
  "\346\350\317\320\323\312\311\314\313\314\316\304\310\315\344\344\347\304"
  "\305\305\303\310\314\320\322\330\353\354\356\343\344\344\276\301\301\310"
  "\316\321\313\314\316\317\322\324\313\314\320\311\310\314\320\324\326\326"
  "\326\330\336\340\344\327\327\332\321\322\325\307\310\314\312\314\317\307"
  "\311\313\310\315\321\362\364\366\366\367\370\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\367"
  "\370\370\377\377\377\256\266\277\256\266\277\377\377\377\367\370\370\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\367\370\371\360\360\360\321\322\325\340\342\343\331"
  "\330\334\316\317\321\324\330\334\354\356\361\340\341\343\321\322\323\324"
  "\325\330\315\317\322\355\356\360\335\334\335\323\326\330\324\327\333\354"
  "\355\357\353\352\353\315\317\320\330\334\337\326\326\331\324\327\331\326"
  "\331\335\322\323\325\327\333\336\331\332\334\336\342\344\344\344\345\327"
  "\327\330\313\313\316\334\337\341\324\324\326\316\320\324\363\366\366\366"
  "\367\370\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\367\370\370\377\377\377\256\266\277\256"
  "\266\277\377\377\377\367\370\371\366\367\370\366\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\370\370\370"
  "\371\372\367\370\371\372\372\373\372\373\374\372\373\374\372\372\373\372"
  "\373\374\371\372\373\372\373\374\372\373\374\372\373\373\373\374\374\371"
  "\372\373\372\373\373\371\372\373\372\373\373\372\373\372\370\371\372\372"
  "\373\374\372\373\374\372\373\374\372\373\374\372\373\374\372\373\374\365"
  "\365\366\366\370\371\371\372\373\372\373\374\371\372\374\372\373\374\372"
  "\373\374\371\372\372\370\371\372\366\367\370\366\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\367"
  "\370\371\377\377\377\256\266\277\256\266\277\377\377\377\364\365\366\361"
  "\362\363\361\362\363\361\362\363\361\362\363\361\362\363\362\363\363\362"
  "\363\363\362\363\363\362\363\363\362\363\363\362\363\363\362\363\363\362"
  "\363\363\362\363\363\362\363\363\362\363\363\362\363\363\362\363\363\362"
  "\363\363\362\363\363\362\363\363\362\363\363\362\363\363\362\363\363\362"
  "\363\363\362\363\363\362\363\363\362\363\364\363\364\364\363\364\364\363"
  "\364\364\363\364\364\363\364\364\363\363\364\363\364\364\363\364\364\363"
  "\364\364\363\364\364\362\363\364\363\364\364\363\364\364\363\364\364\362"
  "\363\364\362\363\364\363\364\364\363\364\364\363\364\364\363\364\364\363"
  "\364\364\363\364\364\363\364\364\363\364\365\363\364\364\363\364\364\363"
  "\364\364\363\364\364\363\364\364\363\364\364\363\363\364\362\363\364\362"
  "\363\363\362\363\363\362\363\363\362\363\363\362\363\363\362\363\363\362"
  "\363\363\362\363\363\362\363\363\362\363\363\362\363\363\362\363\363\362"
  "\363\363\361\362\363\362\362\363\362\363\363\362\363\363\362\363\363\362"
  "\363\363\362\363\363\362\362\363\362\362\363\362\363\363\362\363\363\362"
  "\363\363\362\363\363\362\363\363\364\365\366\377\377\377\256\266\277\256"
  "\266\277\377\377\377\365\366\366\364\365\365\364\365\365\364\365\365\364"
  "\365\365\360\361\364\357\360\362\360\361\364\360\361\364\360\361\364\357"
  "\360\362\357\360\364\357\360\364\357\360\362\357\360\364\357\360\364\357"
  "\360\362\357\360\364\357\360\364\357\360\362\357\360\364\357\360\364\357"
  "\360\362\357\360\364\357\360\364\357\360\364\357\360\362\357\360\364\357"
  "\360\364\357\360\362\357\360\364\357\360\364\360\361\363\360\361\365\360"
  "\361\365\360\361\363\360\361\364\357\360\364\357\360\362\357\360\364\360"
  "\361\364\360\361\365\360\361\363\360\361\365\360\361\364\360\360\362\360"
  "\360\364\360\361\364\360\361\363\360\361\365\360\361\365\360\361\362\360"
  "\360\364\357\360\364\357\360\362\357\360\364\357\360\363\357\360\363\357"
  "\360\362\357\360\363\357\360\363\357\360\362\357\360\363\357\360\363\357"
  "\360\362\357\360\363\357\360\363\357\360\362\357\360\363\357\360\363\357"
  "\360\362\357\360\363\357\360\363\357\360\363\362\363\364\361\363\364\357"
  "\360\364\360\361\363\360\361\365\360\361\364\357\360\362\361\363\364\363"
  "\363\365\357\360\364\360\360\364\360\363\364\360\361\364\357\360\364\362"
  "\363\364\377\377\377\257\266\300\257\267\277\377\377\377\373\372\367\372"
  "\371\366\371\372\370\366\367\367\362\363\366\360\361\365\357\362\366\360"
  "\362\364\357\360\365\362\365\370\363\366\371\363\365\371\362\365\371\363"
  "\363\367\362\365\370\361\364\367\361\362\366\362\365\367\362\364\370\363"
  "\364\370\363\366\371\362\363\367\361\362\366\361\364\366\362\365\371\363"
  "\365\367\363\365\371\363\365\371\362\364\366\360\361\365\360\362\365\360"
  "\363\367\361\362\366\360\362\365\360\362\366\361\364\367\362\364\370\360"
  "\363\366\360\361\365\361\362\365\361\364\367\361\362\366\362\363\367\362"
  "\363\370\361\364\367\363\366\370\361\364\370\362\363\367\362\363\366\363"
  "\364\367\362\362\366\362\364\370\361\364\367\363\365\371\361\362\366\360"
  "\362\364\356\361\365\356\357\363\356\357\363\356\361\365\356\357\363\356"
  "\357\363\356\361\365\356\361\363\356\357\363\356\361\363\356\361\365\356"
  "\357\363\356\357\363\356\361\365\356\357\363\356\357\363\356\361\365\357"
  "\357\363\356\360\362\356\357\363\357\360\363\357\360\364\353\356\361\357"
  "\362\365\355\360\363\356\357\363\357\357\363\355\360\363\356\361\365\355"
  "\355\362\356\360\363\357\360\363\357\360\365\376\376\377\257\267\300\262"
  "\270\300\377\377\377\304\324\360\302\324\360\357\361\364\340\341\337\361"
  "\363\365\377\377\377\356\356\355\355\352\353\325\330\332\352\352\354\362"
  "\363\363\360\361\361\367\366\366\357\360\361\356\357\357\372\373\373\377"
  "\377\377\356\355\356\346\350\352\357\360\360\356\357\357\347\347\351\377"
  "\377\377\371\370\367\357\356\357\360\357\360\362\361\361\357\360\357\354"
  "\355\356\377\377\377\374\372\371\354\354\354\352\350\351\347\347\347\326"
  "\330\332\336\341\345\351\351\353\354\354\354\374\375\376\377\377\376\345"
  "\345\347\333\334\335\337\336\337\333\334\336\335\336\340\362\362\363\356"
  "\356\356\347\347\347\332\335\337\323\324\326\333\333\337\364\366\367\356"
  "\355\356\362\361\361\360\360\360\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\361\364\370\366\367\370\377"
  "\377\377\360\355\356\312\313\317\360\362\366\377\377\377\366\367\371\360"
  "\362\365\377\377\377\371\367\371\325\326\330\351\353\357\377\377\377\372"
  "\374\375\375\375\376\257\267\277\263\272\300\370\373\376l\242\350a\234\350"
  "\332\341\354\323\321\317\361\363\363\377\377\377\356\356\355\354\354\355"
  "\345\344\345\310\307\312\311\313\315\303\302\305\315\314\321\306\310\312"
  "\305\306\310\335\342\347\367\367\362\310\312\313\310\313\317\302\303\307"
  "\314\317\324\324\322\326\372\374\373\327\325\324\303\305\311\312\311\314"
  "\305\306\311\304\307\312\322\323\330\364\365\366\373\371\370\350\352\353"
  "\346\346\347\356\356\355\333\331\330\324\325\330\345\344\347\352\352\351"
  "\367\370\372\377\377\374\342\341\344\326\323\324\314\316\317\324\326\330"
  "\325\324\325\314\320\322\346\346\347\336\336\335\313\314\317\306\307\312"
  "\322\325\327\344\347\346\306\305\306\305\306\307\302\305\310\367\371\372"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\362\363\367\364\365\367\377\377\377\355\353\354\316\317\320\356\357\363"
  "\377\377\377\365\366\371\357\361\366\377\377\377\367\365\366\321\323\323"
  "\341\344\350\376\377\377\373\372\374\375\375\376\256\266\277\262\271\300"
  "\377\377\377\263\310\356\250\302\353\355\360\365\363\362\361\365\366\371"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\376\377\376\377\376"
  "\376\375\376\377\377\377\377\377\377\375\375\375\371\370\371\363\363\362"
  "\361\362\365\377\377\377\374\374\374\377\377\377\374\374\373\367\366\367"
  "\352\352\352\363\364\365\377\377\377\377\377\377\377\376\375\377\377\377"
  "\370\367\366\370\372\373\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\376\377\377\377\377\377\377\377\370\370\367\370\370\371\377\377\377"
  "\377\377\376\374\375\374\376\377\376\377\376\377\377\377\377\377\377\377"
  "\377\377\377\377\376\377\377\377\376\377\377\377\374\374\373\354\355\354"
  "\370\367\370\350\351\352\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\362\363\367\365\366\370\377\377\377"
  "\375\375\376\373\373\373\374\375\375\377\377\377\365\366\370\360\361\364"
  "\376\375\377\377\375\375\364\364\364\373\374\374\377\377\377\372\373\375"
  "\375\375\376\257\267\277\260\267\300\377\377\377\376\376\372\375\375\371"
  "\374\374\371\370\371\371\363\365\366\361\364\370\363\366\370\365\367\371"
  "\366\367\371\364\367\371\365\367\372\365\367\372\365\367\372\364\367\372"
  "\366\367\372\365\370\372\365\366\372\365\370\372\367\370\372\365\367\372"
  "\364\367\371\364\367\371\365\366\372\365\366\372\365\370\372\364\367\371"
  "\364\367\371\364\367\371\364\367\371\364\365\371\364\365\371\363\366\370"
  "\363\365\370\363\365\370\363\366\370\364\366\371\363\366\370\363\366\370"
  "\364\365\371\364\365\371\363\366\370\363\366\371\364\367\371\365\367\372"
  "\365\367\372\364\367\371\364\366\371\363\366\370\363\366\371\364\367\371"
  "\366\367\372\367\370\373\367\372\374\372\373\376\367\370\374\367\370\374"
  "\363\366\370\361\364\367\361\364\367\362\365\370\363\366\370\363\366\370"
  "\363\366\370\362\365\367\362\365\367\362\365\367\362\365\370\365\366\370"
  "\365\366\370\362\365\370\362\365\367\362\364\367\361\364\367\362\363\367"
  "\360\361\364\357\361\365\360\363\367\361\364\370\362\365\371\361\364\367"
  "\360\363\366\357\362\365\357\362\365\360\361\367\361\364\367\364\365\371"
  "\362\364\370\360\363\367\360\363\366\376\376\377\257\267\277\260\267\300"
  "\377\377\377\373\372\371\370\371\370\374\374\373\365\365\365\364\365\367"
  "\370\371\373\366\367\371\363\364\366\363\364\367\373\374\376\374\375\377"
  "\373\374\376\367\370\372\374\375\377\374\375\377\365\365\366\366\371\373"
  "\371\371\373\367\370\372\374\375\377\373\374\377\373\374\376\373\374\376"
  "\372\373\375\372\373\375\372\373\375\372\373\375\373\374\376\374\375\377"
  "\374\375\376\364\365\367\370\371\375\373\374\376\371\371\374\365\366\372"
  "\373\374\377\373\374\377\374\375\377\371\370\372\370\371\373\372\373\376"
  "\372\373\374\373\373\376\374\375\375\367\370\372\373\373\375\373\374\376"
  "\371\372\374\373\374\375\364\365\370\366\367\371\364\365\367\355\356\360"
  "\357\360\364\363\364\366\360\363\365\357\360\363\372\373\376\367\370\370"
  "\364\363\370\361\362\364\362\363\365\357\362\364\365\370\372\373\374\376"
  "\366\367\371\362\363\366\362\363\365\362\363\365\362\363\367\372\372\375"
  "\371\372\374\372\373\375\370\371\373\361\363\367\361\363\367\366\367\371"
  "\364\363\365\347\350\353\364\364\370\366\367\371\361\363\367\357\360\365"
  "\366\367\371\364\365\367\350\351\354\360\363\366\367\367\371\364\366\370"
  "\376\376\377\257\267\277\263\271\300\375\375\377\217\262\351\220\263\351"
  "\344\350\360\324\322\320\360\361\363\377\377\377\351\347\347\325\324\325"
  "\303\306\312\325\325\326\326\327\331\321\322\322\320\321\325\327\326\330"
  "\335\334\335\307\310\311\360\363\366\370\367\365\321\321\325\324\324\326"
  "\330\332\332\330\331\333\331\331\333\325\325\327\371\373\373\371\367\366"
  "\335\336\337\324\324\326\327\330\332\334\333\334\303\310\311\321\322\324"
  "\354\357\361\375\374\371\322\324\327\332\330\330\331\332\333\331\331\333"
  "\320\320\320\313\316\321\374\375\376\365\363\360\327\330\333\325\325\326"
  "\317\322\326\324\325\327\322\325\327\333\336\342\377\377\377\351\347\347"
  "\346\346\347\346\346\351\337\335\333\304\305\312\304\305\307\312\315\323"
  "\326\327\331\377\377\377\362\360\356\333\333\334\312\314\314\324\324\326"
  "\315\316\321\327\330\332\340\341\344\335\334\336\330\327\332\305\304\305"
  "\307\310\314\333\334\337\353\354\353\323\324\326\336\335\337\371\372\370"
  "\364\365\371\365\366\370\377\377\377\353\351\350\277\300\304\353\356\362"
  "\377\377\377\365\366\370\360\361\366\377\377\377\370\366\366\320\322\324"
  "\342\343\351\377\377\377\374\373\375\375\375\376\256\266\277\263\272\300"
  "\371\373\377t\244\350_\234\346\335\342\356\340\336\334\363\364\366\377\377"
  "\377\370\366\365\347\346\346\331\334\335\347\350\351\332\333\335\326\327"
  "\332\346\350\350\342\341\342\340\340\341\324\325\326\357\360\363\365\366"
  "\366\345\345\346\324\324\327\340\342\342\341\341\343\345\345\345\320\320"
  "\323\356\356\361\361\357\357\332\334\335\317\321\323\341\341\345\341\337"
  "\340\325\330\331\331\330\332\347\353\353\370\370\367\347\346\347\324\324"
  "\325\331\333\335\343\341\342\330\330\331\320\324\325\362\363\364\347\344"
  "\342\317\323\326\322\322\325\331\333\336\347\350\350\332\333\334\327\330"
  "\335\372\374\373\364\363\363\364\364\365\362\362\363\363\363\364\341\340"
  "\337\335\334\335\336\341\341\336\337\341\371\372\372\367\366\366\355\355"
  "\354\333\332\335\332\334\334\343\343\343\341\341\341\345\347\351\355\356"
  "\357\343\343\344\336\336\335\336\337\340\343\344\347\336\337\336\306\311"
  "\314\321\322\323\364\363\362\364\365\371\365\366\371\377\377\377\364\362"
  "\363\342\343\344\362\363\365\377\377\377\365\366\371\357\361\366\377\377"
  "\377\372\370\371\326\330\330\354\355\357\377\377\377\373\372\374\375\375"
  "\376\256\266\277\261\270\300\377\377\377\335\346\364\331\342\362\370\370"
  "\367\367\367\367\365\366\370\375\375\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\374\373\374\372\373\373\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\372\374\373\374\373\374\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\376\375"
  "\376\371\371\372\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\374\375\374\370\370\371\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\376\377\371\371\371\376\375\376\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\371\370\371\374\375\376\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\374\374\373\374\375\376\373\372\373\373\372\373\362\365"
  "\367\364\365\370\374\374\375\375\375\375\374\376\376\373\374\375\374\373"
  "\375\364\365\370\357\361\365\373\374\374\375\375\377\373\373\375\374\375"
  "\375\374\374\375\370\371\373\375\375\376\257\266\277\257\267\300\377\377"
  "\377\377\377\372\377\376\371\373\373\371\371\371\371\363\366\366\357\362"
  "\366\362\363\367\361\364\370\362\365\371\363\364\370\363\364\370\362\364"
  "\370\362\364\370\362\364\370\362\364\370\362\364\370\363\364\370\362\363"
  "\367\362\363\367\362\363\367\361\364\370\363\364\370\362\364\370\363\364"
  "\370\363\364\370\362\363\367\362\363\367\360\363\367\362\364\370\362\364"
  "\370\362\364\370\362\364\370\362\364\370\362\363\367\361\362\366\361\363"
  "\367\362\364\367\361\364\370\363\364\370\364\366\372\364\367\372\364\367"
  "\373\363\366\371\361\364\367\362\363\367\363\364\370\363\366\372\363\366"
  "\372\363\366\372\362\365\371\362\364\370\363\364\370\362\365\371\363\366"
  "\372\364\366\372\363\365\371\363\364\370\363\364\370\362\363\367\361\363"
  "\366\357\362\366\356\361\365\356\361\365\356\361\365\355\360\365\355\360"
  "\365\356\360\365\356\361\365\356\361\365\356\361\365\360\362\366\361\362"
  "\366\361\362\366\357\362\366\360\361\365\357\360\365\356\362\365\360\361"
  "\367\357\362\366\360\363\366\357\361\365\357\360\365\357\362\363\357\360"
  "\365\357\362\366\357\362\366\360\361\366\357\361\365\360\361\366\376\377"
  "\377\257\266\277\261\270\300\377\377\377\344\351\364\341\351\364\366\367"
  "\370\354\352\353\362\364\366\375\376\377\364\364\364\355\354\355\353\354"
  "\360\371\373\373\372\371\374\374\373\373\372\373\374\366\367\370\372\371"
  "\373\371\373\373\371\371\373\370\371\372\375\377\377\374\374\372\345\346"
  "\351\367\370\372\374\374\374\373\374\374\372\371\371\371\372\372\377\377"
  "\377\363\363\365\371\371\373\372\373\373\373\374\375\373\374\375\371\372"
  "\373\371\370\372\377\377\377\366\366\366\362\362\364\361\360\362\350\350"
  "\352\341\342\344\351\350\354\342\342\344\340\341\345\375\376\377\372\372"
  "\373\356\355\357\346\350\352\352\351\353\345\347\350\355\356\362\373\373"
  "\373\362\362\364\355\354\356\346\347\351\345\346\351\352\353\355\370\373"
  "\373\366\366\370\372\373\373\370\370\372\377\377\377\376\376\376\375\375"
  "\376\375\375\376\375\375\376\375\375\376\375\375\376\375\375\376\375\375"
  "\376\375\375\376\375\375\376\375\375\376\376\375\376\376\377\377\361\362"
  "\365\364\365\370\374\375\377\362\360\362\331\332\336\362\363\367\374\375"
  "\374\364\365\370\357\361\365\373\373\374\370\370\370\335\336\340\355\356"
  "\361\374\375\377\371\370\373\375\375\376\257\266\277\263\272\300\371\373"
  "\377m\241\346q\245\350\335\343\354\317\315\314\360\361\363\377\377\377\352"
  "\350\350\327\327\330\276\277\302\301\302\304\314\315\321\307\304\305\301"
  "\306\311\313\316\315\306\312\314\314\313\314\316\317\322\277\301\303\350"
  "\353\357\372\366\367\310\304\305\315\317\320\302\302\303\272\272\275\277"
  "\300\303\322\327\334\377\377\377\326\323\326\304\305\310\305\307\311\313"
  "\312\317\314\314\317\304\303\304\310\313\320\375\376\377\362\360\357\345"
  "\345\347\341\343\346\346\346\343\312\310\310\324\326\332\341\341\341\320"
  "\320\322\370\372\374\373\371\366\335\333\334\305\305\310\316\317\320\317"
  "\317\317\313\313\315\323\326\331\336\335\336\324\324\327\304\305\310\272"
  "\274\300\322\325\330\346\347\346\305\304\306\307\312\316\316\316\322\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\361\363\366\364\366\371\377\377\377\353\351\347\274"
  "\276\300\353\356\362\377\377\377\365\366\371\357\361\366\377\377\377\367"
  "\365\366\320\321\321\340\343\347\377\377\377\373\373\375\375\375\376\256"
  "\266\277\263\271\300\374\376\377\223\265\351\201\252\347\345\351\362\353"
  "\352\350\364\365\367\377\377\377\376\376\375\370\370\370\363\362\363\356"
  "\357\356\366\370\370\364\362\363\362\364\364\371\371\372\364\363\364\362"
  "\363\362\371\371\371\361\357\357\363\364\365\370\366\367\364\362\363\362"
  "\364\363\363\363\364\360\362\361\361\360\361\366\365\366\367\371\370\362"
  "\363\362\361\360\361\357\361\360\363\362\363\366\366\365\362\362\363\355"
  "\356\355\365\364\365\371\370\371\374\374\375\373\373\374\375\375\374\367"
  "\367\366\366\365\366\376\376\375\363\362\361\364\364\365\371\373\372\372"
  "\371\372\363\363\362\357\357\360\364\364\365\364\363\364\366\367\366\374"
  "\374\375\370\370\367\363\364\363\364\363\364\365\366\366\360\357\356\330"
  "\331\333\347\347\347\331\332\335\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\362\363\367\364"
  "\366\367\377\377\377\372\372\373\363\363\363\371\372\372\377\377\377\365"
  "\366\371\360\361\366\377\377\377\375\373\374\352\351\352\364\365\367\377"
  "\377\377\373\373\375\375\375\376\257\267\277\260\270\300\377\377\377\366"
  "\367\367\365\366\367\374\373\372\371\372\371\364\365\370\370\371\374\374"
  "\373\376\375\375\377\376\377\377\376\375\377\375\375\377\375\375\377\375"
  "\375\377\375\375\377\375\375\377\375\375\377\375\375\377\375\375\377\372"
  "\373\375\370\371\373\374\375\377\376\375\377\376\377\377\376\377\377\376"
  "\375\377\374\375\375\370\371\373\374\375\375\376\375\377\376\375\377\376"
  "\375\377\376\377\377\376\375\377\374\375\377\367\371\373\370\371\374\373"
  "\373\375\374\373\375\374\374\376\375\375\377\375\375\377\375\377\377\374"
  "\375\377\371\371\373\371\372\374\374\374\376\375\375\377\376\376\377\376"
  "\376\377\376\376\377\375\375\377\375\374\376\375\375\377\376\377\377\376"
  "\376\377\377\376\377\376\375\377\375\376\377\376\377\377\371\372\374\373"
  "\373\375\371\371\373\371\370\373\371\370\372\371\370\372\371\370\372\371"
  "\370\372\371\370\372\371\370\372\371\370\372\371\370\372\371\370\372\371"
  "\370\373\371\372\374\360\362\366\362\363\366\367\367\372\370\367\373\371"
  "\372\374\370\367\373\367\367\372\362\363\366\357\360\365\365\367\372\370"
  "\371\373\371\370\374\371\372\373\370\371\373\366\367\371\376\376\377\257"
  "\267\300\260\267\277\377\377\377\377\376\372\377\375\372\374\374\372\370"
  "\370\370\363\366\367\363\364\370\361\362\366\361\364\367\363\365\371\367"
  "\370\374\366\367\373\366\367\373\364\367\373\366\367\373\364\365\371\363"
  "\364\370\363\364\370\364\365\371\366\367\373\366\367\373\365\366\372\365"
  "\366\371\366\367\373\363\366\371\363\365\371\362\363\367\365\367\373\364"
  "\366\371\362\363\367\365\366\372\362\364\367\365\370\373\366\370\373\365"
  "\366\372\362\365\371\364\365\371\361\363\367\361\364\370\362\364\367\357"
  "\361\365\356\360\365\361\362\367\365\366\372\362\363\367\361\364\370\362"
  "\365\371\362\364\367\363\364\370\364\365\370\362\365\370\362\364\371\367"
  "\370\373\363\366\371\362\365\371\364\365\370\362\365\371\361\364\370\364"
  "\366\372\365\366\372\366\367\373\363\366\371\362\363\367\357\362\366\356"
  "\361\365\356\361\365\356\361\365\356\361\365\356\361\365\356\361\365\356"
  "\361\365\356\361\365\356\361\365\357\362\365\360\363\366\360\361\364\357"
  "\360\365\361\362\365\357\362\366\353\356\362\361\362\367\361\362\365\357"
  "\360\365\357\362\365\361\362\365\360\363\367\355\356\363\360\362\366\361"
  "\364\367\343\346\351\375\375\376\260\270\300\262\271\300\377\377\377\270"
  "\313\356\270\313\356\354\357\363\333\333\332\362\363\363\377\377\377\344"
  "\341\342\327\330\330\334\337\343\356\355\357\355\354\354\352\353\353\350"
  "\351\353\355\355\355\343\344\346\367\370\372\363\363\360\345\346\351\354"
  "\353\354\352\355\353\346\347\350\350\351\354\353\352\352\363\364\366\377"
  "\377\377\332\333\333\355\356\360\355\354\354\341\341\345\377\377\377\334"
  "\334\336\346\350\352\354\354\354\347\346\346\340\343\345\377\377\377\372"
  "\370\366\351\351\354\346\346\346\345\345\345\337\340\341\335\337\341\333"
  "\333\333\324\325\331\370\371\373\377\376\375\343\343\345\331\332\332\331"
  "\332\333\327\332\332\333\334\336\355\357\361\351\350\350\343\343\343\325"
  "\330\332\321\320\321\332\333\336\363\364\365\352\351\352\354\355\356\354"
  "\354\356\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\362\363\367\365\366\370\377\377\377\357\355\353\307"
  "\310\315\357\362\364\377\377\377\365\367\370\360\361\365\377\376\376\370"
  "\366\366\324\326\327\347\352\355\377\377\377\341\340\343\371\372\373\261"
  "\270\301\263\272\300\370\372\376o\243\350[\235\346\332\341\354\325\323\321"
  "\362\363\365\377\377\377\333\331\332\327\330\331\316\317\317\302\304\306"
  "\303\304\311\313\314\317\326\327\334\315\311\312\310\311\316\360\361\364"
  "\354\352\350\311\310\311\306\310\313\316\321\324\330\331\334\306\310\312"
  "\311\313\313\323\327\333\375\375\374\326\325\326\321\322\325\315\314\321"
  "\326\330\334\376\375\375\326\326\327\320\315\316\311\312\315\306\310\310"
  "\324\326\334\365\367\370\371\371\366\352\353\355\347\347\350\356\355\355"
  "\360\360\361\352\351\352\312\311\312\313\312\317\356\361\364\376\376\375"
  "\343\343\346\327\325\326\316\315\316\330\331\332\324\324\324\322\323\326"
  "\350\350\350\340\336\337\316\317\322\311\313\315\325\330\333\344\347\346"
  "\304\305\304\305\304\307\303\305\311\371\372\373\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\361\362\366\364\365\367"
  "\377\377\377\357\355\354\321\323\323\355\360\363\377\377\377\365\366\371"
  "\357\361\366\377\377\377\367\365\366\323\324\325\344\347\353\377\377\377"
  "\341\342\345\371\373\374\261\270\301\262\271\300\377\377\377\276\317\356"
  "\263\311\355\360\362\366\365\363\362\365\367\371\377\377\377\374\374\375"
  "\377\377\377\375\375\374\356\357\360\376\375\375\377\377\377\377\377\377"
  "\377\377\377\377\377\376\371\371\370\370\371\370\377\376\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\372\371\372\371\370\371"
  "\375\377\375\377\377\377\377\376\376\374\373\374\367\370\367\375\375\376"
  "\377\377\377\377\377\377\377\377\377\377\377\377\370\367\370\372\372\373"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\376\371\370\371\371\372\373\377\377\377\377\377\377\377\376\375"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\376\373\372\357\360\361\371\372\371\355\354\356"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\362\363\367\365\366\370\376\377\377\375\375\375\375\375\375"
  "\375\375\375\376\375\377\365\366\370\360\361\364\376\375\376\377\377\377"
  "\366\366\367\375\375\376\377\377\377\340\340\344\371\373\374\261\271\301"
  "\260\267\277\377\377\377\377\376\372\377\375\372\374\373\371\370\371\371"
  "\363\366\366\362\363\367\364\366\371\365\366\372\366\367\373\364\367\373"
  "\365\366\372\364\365\371\364\365\371\363\365\371\363\365\371\362\365\371"
  "\363\365\371\365\366\372\364\365\371\364\365\371\363\365\370\364\365\371"
  "\364\366\372\365\366\372\362\365\371\364\365\371\364\365\371\365\366\372"
  "\365\366\372\363\366\372\364\365\371\364\365\371\364\365\371\365\366\372"
  "\365\366\372\365\367\372\365\367\372\365\366\372\364\366\371\363\365\370"
  "\362\364\370\363\365\371\365\366\372\366\367\373\366\367\373\363\366\372"
  "\364\365\371\364\365\371\365\366\372\366\367\373\366\367\373\365\366\372"
  "\364\365\371\364\365\371\364\365\371\364\365\371\363\364\370\363\365\371"
  "\362\365\371\364\365\371\362\365\370\362\363\367\360\362\366\360\361\365"
  "\360\361\365\360\361\365\360\361\365\360\361\365\360\361\365\360\361\365"
  "\360\361\365\360\361\365\360\362\365\360\363\366\360\361\364\357\360\365"
  "\360\361\365\361\362\370\362\363\371\361\362\367\360\361\365\357\360\365"
  "\357\362\365\360\361\365\361\362\366\362\364\371\362\363\370\362\363\370"
  "\331\334\337\373\373\374\261\271\301\260\270\300\377\377\377\366\367\367"
  "\365\366\367\373\374\371\363\364\364\364\365\367\371\372\374\357\361\363"
  "\361\362\366\365\366\370\371\372\374\374\376\377\376\375\377\373\374\376"
  "\372\373\375\376\375\377\372\373\373\374\374\377\374\375\377\367\367\370"
  "\372\373\375\373\374\376\365\366\371\374\375\376\371\371\372\363\364\370"
  "\373\374\376\362\364\366\373\374\376\370\371\371\367\370\372\370\371\373"
  "\372\373\375\364\365\367\365\366\370\360\360\362\351\352\356\352\355\357"
  "\357\360\364\356\357\363\364\365\370\374\375\376\365\364\366\361\362\364"
  "\361\362\363\357\360\364\360\361\364\373\374\375\370\371\373\364\365\367"
  "\360\361\363\357\361\362\360\361\363\365\370\372\370\371\373\374\375\377"
  "\372\373\375\373\374\374\370\371\374\370\371\373\367\371\373\367\371\373"
  "\367\370\373\367\370\373\367\370\372\367\370\372\367\370\372\367\370\372"
  "\367\370\372\367\370\372\367\370\372\367\370\372\367\370\372\367\370\373"
  "\371\372\374\360\362\366\362\363\366\370\370\373\364\363\365\345\346\352"
  "\364\365\370\370\367\373\362\364\367\357\360\365\366\367\373\366\366\367"
  "\346\347\353\361\362\365\372\373\375\335\335\342\373\373\374\261\271\301"
  "\263\271\300\374\374\377\207\257\347\210\257\351\343\347\356\322\320\321"
  "\360\361\362\377\377\377\340\336\336\333\335\337\333\332\335\317\316\317"
  "\320\321\324\323\325\325\320\323\325\332\335\340\377\377\377\332\332\331"
  "\331\332\332\316\321\324\306\311\311\345\352\356\377\377\375\321\321\321"
  "\323\322\325\317\322\324\334\341\347\377\377\377\327\330\333\324\325\330"
  "\317\320\320\313\313\321\353\354\357\377\377\375\335\337\342\345\345\344"
  "\350\347\350\342\344\344\326\326\326\312\313\315\300\302\302\342\345\351"
  "\377\377\377\340\336\335\320\320\323\314\317\322\314\314\316\323\324\326"
  "\324\327\331\343\343\343\335\333\335\317\315\315\277\301\303\312\313\321"
  "\350\353\353\333\334\335\324\325\326\325\326\330\367\366\371\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\362\363\367\365\366\370"
  "\377\377\377\353\351\347\277\300\302\353\356\362\377\377\377\365\366\371"
  "\360\361\366\377\377\377\370\366\366\320\322\324\341\344\350\377\377\377"
  "\341\342\346\371\373\374\261\271\301\263\272\300\371\373\377y\250\350e\235"
  "\346\336\344\356\341\340\336\363\364\367\377\377\376\341\337\340\361\362"
  "\363\362\360\360\343\343\344\337\336\337\337\340\341\336\337\340\336\337"
  "\341\367\366\365\323\324\325\335\335\340\330\327\332\344\345\345\346\347"
  "\351\371\371\367\337\341\342\340\340\337\326\331\334\347\351\355\371\370"
  "\371\346\347\350\321\320\321\327\332\335\351\344\347\353\355\356\373\373"
  "\372\360\360\363\365\365\364\365\364\364\370\371\370\367\365\366\342\341"
  "\342\336\337\336\353\354\355\374\374\375\361\361\360\351\347\347\341\336"
  "\337\341\343\343\344\344\344\342\343\346\363\363\363\360\360\357\344\344"
  "\346\336\336\336\345\344\345\354\355\355\317\320\321\323\324\326\305\306"
  "\310\361\365\365\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\361\363\366\364\365\371\377\377\377\365\363\364\345\347\347\364\365"
  "\367\377\377\377\365\366\371\357\361\366\377\377\377\372\370\371\332\331"
  "\332\356\360\362\377\377\377\341\342\345\371\373\374\261\271\301\261\270"
  "\300\377\377\377\344\353\364\337\347\364\371\371\371\370\371\370\365\366"
  "\370\374\376\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\371\372\373\372\373\374\377\377"
  "\377\377\377\377\377\377\377\376\375\376\372\371\374\377\377\377\377\377"
  "\377\377\377\377\376\377\376\372\371\372\377\377\377\373\372\373\376\377"
  "\377\377\377\377\373\373\373\370\372\372\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\375\375\375\371\372"
  "\373\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\371\373\373\377\377\377\371\371\373\377\377\377\377\376\377\376\375"
  "\376\376\375\376\376\376\376\376\376\377\376\376\376\376\376\376\376\376"
  "\376\376\376\376\376\375\376\376\375\376\376\375\376\376\376\376\376\376"
  "\376\376\376\376\376\376\376\376\377\377\361\362\365\363\364\370\372\374"
  "\374\373\373\375\374\374\376\373\373\375\372\374\373\364\365\370\357\361"
  "\365\373\372\374\373\375\375\373\373\375\375\374\376\375\376\377\336\337"
  "\344\372\373\374\261\271\301\257\267\300\377\377\377\377\377\372\377\376"
  "\371\373\373\371\371\371\371\363\366\366\360\363\367\361\362\366\362\365"
  "\371\362\365\371\363\364\370\363\364\370\363\364\370\363\364\370\363\364"
  "\370\363\365\371\363\364\370\361\363\367\362\363\367\362\364\370\363\364"
  "\370\363\364\370\362\364\370\363\364\370\362\365\371\364\365\371\362\365"
  "\371\363\365\370\363\364\370\362\363\367\360\363\370\363\364\370\363\364"
  "\370\361\364\370\364\365\370\362\365\370\363\364\370\362\364\370\362\364"
  "\370\362\363\367\362\363\367\361\364\370\363\364\370\362\364\370\362\363"
  "\367\361\362\366\362\363\367\363\364\370\361\364\370\363\364\370\363\364"
  "\370\363\364\370\361\363\367\362\363\367\363\364\370\364\365\371\364\365"
  "\371\363\364\370\361\363\367\361\362\366\360\363\367\362\365\371\362\363"
  "\367\364\365\371\362\365\371\362\365\371\361\362\366\361\362\366\361\362"
  "\366\360\364\367\362\363\371\363\364\371\362\365\371\361\364\370\360\363"
  "\366\361\361\365\357\360\365\357\362\365\360\361\367\360\363\366\360\361"
  "\366\357\361\365\357\360\365\357\362\363\357\360\365\360\362\366\357\362"
  "\366\361\362\367\361\364\367\331\332\337\373\373\374\261\271\301\261\270"
  "\300\377\377\377\335\344\363\333\344\362\365\366\367\350\351\350\363\364"
  "\366\377\376\377\354\351\352\344\345\347\346\351\353\365\366\370\372\371"
  "\371\370\371\371\370\372\372\371\371\373\367\367\367\370\372\372\377\377"
  "\377\373\373\373\363\363\365\370\367\371\371\373\373\375\374\375\366\366"
  "\366\360\360\362\366\366\366\362\363\365\367\366\370\366\370\370\377\377"
  "\377\365\364\363\362\365\365\374\375\375\355\360\360\362\361\363\351\353"
  "\353\364\365\367\371\372\372\370\370\370\370\367\371\377\377\377\355\356"
  "\357\367\370\372\367\370\370\373\374\375\377\377\377\373\372\373\366\367"
  "\370\363\364\365\364\363\365\362\362\364\366\367\367\373\374\375\377\377"
  "\377\366\366\366\366\367\370\370\371\372\370\371\372\367\370\370\377\377"
  "\377\370\367\366\337\340\342\343\344\346\361\363\363\352\352\353\343\344"
  "\346\343\344\346\373\375\377\373\372\371\354\354\356\341\343\344\345\346"
  "\350\344\345\345\352\353\355\376\377\377\363\365\371\364\365\370\375\375"
  "\377\362\360\360\323\324\330\363\364\367\375\375\376\364\365\370\357\361"
  "\365\373\374\376\370\370\370\332\333\335\354\357\362\377\376\377\337\340"
  "\343\371\372\373\261\270\301\263\272\300\371\373\376g\240\346o\243\350\333"
  "\341\354\315\313\313\360\361\364\377\377\377\335\333\332\322\324\324\315"
  "\320\323\320\317\322\313\315\315\316\321\322\311\310\311\272\274\275\271"
  "\272\275\303\306\315\374\375\376\353\350\346\305\307\314\306\305\310\310"
  "\315\320\320\317\323\316\316\322\310\304\306\275\276\300\304\311\317\320"
  "\320\324\300\302\305\367\370\373\347\344\342\304\310\311\321\322\324\306"
  "\311\315\307\306\313\275\304\305\313\316\322\317\314\317\300\300\302\312"
  "\315\322\376\377\377\325\322\321\305\311\314\265\266\271\320\321\325\377"
  "\377\377\322\317\316\273\276\277\315\322\325\315\311\315\277\275\275\274"
  "\302\304\355\360\363\371\367\364\300\304\305\316\315\322\312\312\314\307"
  "\310\313\265\266\273\365\370\371\364\361\357\303\302\303\302\304\306\302"
  "\304\306\305\304\307\302\303\306\315\320\323\374\376\376\371\367\366\335"
  "\333\336\305\307\312\314\315\320\316\316\316\314\315\320\363\362\361\364"
  "\365\371\365\366\371\377\377\377\354\350\351\300\304\306\352\355\361\377"
  "\377\377\365\366\371\360\361\366\377\377\377\367\365\366\320\321\321\340"
  "\343\347\377\377\377\355\355\357\372\374\375\260\270\300\262\271\300\375"
  "\375\377\233\270\353\212\260\351\346\353\362\355\355\354\364\367\370\377"
  "\377\377\364\362\363\361\361\362\365\367\365\374\372\373\365\364\365\372"
  "\372\373\373\372\372\365\365\366\361\361\357\340\342\344\367\366\367\364"
  "\365\366\372\373\372\365\367\365\366\365\366\362\361\362\373\373\373\370"
  "\366\366\361\361\361\366\367\370\374\372\373\362\362\361\363\364\365\362"
  "\361\360\363\363\364\362\362\362\370\367\370\366\366\366\365\366\365\374"
  "\373\374\357\355\353\335\340\342\361\362\362\365\366\366\361\362\361\365"
  "\365\365\355\353\353\351\352\354\371\370\371\364\363\364\365\367\366\373"
  "\372\373\374\373\373\364\364\364\365\366\365\370\367\370\364\363\364\360"
  "\362\361\372\372\373\367\367\365\370\367\370\363\362\363\366\367\367\364"
  "\366\365\367\366\367\370\371\370\375\375\374\370\370\371\365\364\363\361"
  "\360\361\365\364\365\371\371\372\375\375\374\367\366\365\362\364\363\367"
  "\367\370\365\365\366\376\375\376\364\365\370\365\366\370\377\377\377\374"
  "\372\372\367\366\367\372\372\374\377\377\377\365\366\370\360\361\366\376"
  "\377\377\375\373\374\354\353\355\366\367\371\377\377\377\373\374\376\376"
  "\376\377\257\267\300\260\267\300\377\377\377\371\372\371\370\367\370\374"
  "\374\372\371\371\371\363\365\370\367\370\372\373\375\377\374\376\377\374"
  "\375\377\374\375\377\373\375\377\373\374\377\373\374\377\374\375\377\375"
  "\376\377\372\373\375\370\371\373\371\372\374\373\374\376\373\374\377\374"
  "\375\377\374\375\377\374\375\377\374\375\377\374\375\377\374\375\377\373"
  "\375\377\374\375\375\370\371\374\372\373\376\374\375\377\374\375\377\374"
  "\375\377\374\375\377\374\375\377\374\375\377\373\375\377\373\374\376\376"
  "\375\377\371\372\375\373\374\376\375\376\377\373\375\377\372\373\375\371"
  "\372\374\373\374\376\375\376\377\374\375\377\373\375\377\374\375\377\373"
  "\375\377\371\370\373\367\370\373\373\374\374\373\374\376\373\374\376\373"
  "\374\376\373\374\374\367\370\372\367\370\372\373\374\376\373\374\374\373"
  "\374\376\373\374\376\373\374\377\373\372\375\366\370\372\370\371\373\372"
  "\373\375\372\373\376\373\374\375\373\374\376\371\372\374\367\370\372\360"
  "\363\365\360\363\367\365\366\370\366\367\371\367\370\374\366\367\371\365"
  "\366\370\361\363\367\357\360\365\366\367\370\366\367\371\367\371\374\367"
  "\370\373\366\367\370\364\366\370\376\376\377\257\267\277\260\267\300\377"
  "\377\377\377\376\373\375\375\372\375\374\372\370\370\370\364\366\367\363"
  "\366\370\361\362\366\361\362\366\362\364\370\366\371\373\365\366\372\364"
  "\367\371\365\367\371\365\366\372\361\364\367\367\370\374\366\367\372\364"
  "\367\371\362\363\367\365\366\372\366\367\373\366\370\373\365\366\372\365"
  "\366\372\366\371\373\366\370\372\366\367\373\367\371\374\365\366\371\364"
  "\367\373\367\370\374\367\370\374\367\370\374\366\371\373\366\367\373\365"
  "\366\372\364\365\371\364\366\371\362\363\367\363\364\367\362\363\367\364"
  "\367\373\367\370\374\364\365\371\362\365\370\363\364\370\362\365\371\363"
  "\364\367\365\366\372\365\370\373\366\367\373\364\365\371\362\365\367\361"
  "\364\366\360\363\366\360\363\366\360\363\366\360\363\366\361\363\366\361"
  "\363\366\360\363\366\360\363\366\360\363\366\360\363\366\360\363\366\360"
  "\363\366\361\363\366\360\363\366\360\363\366\360\363\366\360\363\366\360"
  "\363\366\361\364\366\362\363\367\360\361\364\357\361\365\361\364\367\361"
  "\362\366\354\355\362\361\362\367\361\363\367\357\362\365\357\362\365\361"
  "\362\367\362\363\367\353\354\361\360\362\366\361\364\367\360\363\366\376"
  "\376\377\257\267\277\262\271\300\377\377\377\255\304\354\255\304\354\353"
  "\356\363\327\326\326\360\361\364\377\377\377\341\341\342\333\334\332\322"
  "\325\327\345\346\350\342\337\341\340\341\343\370\371\373\375\373\372\321"
  "\321\322\345\344\346\347\350\352\377\377\377\360\361\360\357\357\361\347"
  "\347\351\353\353\353\344\344\344\341\341\345\356\357\361\363\363\361\345"
  "\344\347\345\346\346\334\335\336\336\337\341\352\353\354\350\347\350\350"
  "\347\350\351\350\351\345\346\346\363\364\365\355\355\354\340\340\340\321"
  "\322\324\332\331\333\323\324\330\342\343\345\355\356\356\344\343\345\336"
  "\335\335\313\314\316\322\323\325\340\342\344\362\361\360\345\345\347\350"
  "\351\351\361\361\363\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\362"
  "\363\367\365\366\370\377\377\377\357\353\353\305\307\312\355\360\363\377"
  "\377\377\365\366\370\360\361\364\376\376\377\370\366\366\324\326\325\346"
  "\347\353\377\377\377\372\373\375\375\375\376\257\267\277\263\272\300\370"
  "\373\376o\243\350Z\232\346\333\341\354\331\327\325\362\363\365\377\377\377"
  "\334\332\333\337\336\335\317\322\323\326\330\332\326\324\330\310\311\314"
  "\350\353\355\370\367\367\323\323\326\321\321\323\316\321\324\372\373\374"
  "\335\334\333\316\320\324\324\322\326\322\320\320\275\277\303\317\315\317"
  "\326\331\336\341\341\340\276\276\300\307\310\313\316\317\321\312\313\315"
  "\313\314\317\306\307\307\275\277\303\314\315\316\310\313\316\353\354\357"
  "\361\361\360\346\344\345\315\316\317\326\327\330\327\330\333\325\326\326"
  "\342\343\346\346\345\350\335\335\336\313\314\316\320\324\326\336\336\340"
  "\331\332\327\303\306\311\301\300\303\330\333\337\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\361\362\366\364\365\367\377\377\377\361\357\356"
  "\325\327\327\357\360\364\377\377\377\365\366\371\357\361\366\377\377\377"
  "\371\367\366\323\324\326\345\350\354\377\377\377\373\372\374\375\375\376"
  "\256\266\277\262\270\300\377\377\377\310\325\357\300\317\357\361\364\366"
  "\366\365\364\365\366\371\377\377\377\376\375\376\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\373\372\373\371\372\371\377\377\377"
  "\377\377\377\377\377\375\371\371\367\363\364\365\377\376\376\377\377\377"
  "\375\372\371\362\364\366\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\373\374\373\377\377\377\377\377\377\372\371\372"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\367\366\365\371\370\372\366\366\366"
  "\366\367\367\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\361\363\367"
  "\365\366\370\376\375\377\375\375\375\375\374\376\375\375\377\376\375\377"
  "\365\366\370\360\361\364\376\375\375\377\376\377\370\367\371\374\374\376"
  "\376\375\377\372\373\375\375\375\376\257\267\277\260\267\277\377\377\377"
  "\377\377\372\377\376\371\374\373\371\370\371\371\363\366\366\362\363\367"
  "\364\365\371\365\366\372\363\366\372\362\365\371\362\365\371\362\365\371"
  "\362\365\371\362\365\367\363\366\371\363\366\371\363\366\371\363\366\372"
  "\363\366\372\362\365\371\362\365\371\363\366\372\364\366\372\363\366\371"
  "\362\365\371\362\364\370\362\364\370\362\365\370\363\365\371\363\366\372"
  "\363\366\372\363\366\372\363\366\372\363\366\372\362\364\370\361\363\367"
  "\361\364\370\362\365\371\365\366\372\363\366\372\365\367\372\366\367\372"
  "\365\366\372\363\365\371\362\364\370\362\365\371\365\366\372\366\367\373"
  "\365\370\374\367\370\374\366\367\373\363\366\372\362\365\371\362\365\371"
  "\362\365\371\364\365\371\361\364\370\361\363\370\360\363\367\360\363\367"
  "\357\362\366\357\361\366\356\361\365\356\361\366\356\361\366\356\361\366"
  "\356\361\366\356\361\366\356\361\366\356\361\366\356\361\366\356\361\366"
  "\357\361\366\360\363\365\360\361\364\357\361\365\360\361\365\361\362\366"
  "\362\363\367\361\362\366\360\361\365\357\362\365\357\362\365\356\361\365"
  "\361\362\366\362\364\367\362\363\366\360\361\365\360\363\366\376\376\377"
  "\257\267\277\260\270\300\377\377\377\363\366\370\363\363\367\372\373\371"
  "\362\362\362\364\365\370\372\372\374\360\357\361\362\365\367\366\367\371"
  "\373\374\374\374\375\375\374\374\377\375\376\377\374\375\375\370\371\372"
  "\372\373\375\372\372\374\373\374\374\373\374\374\374\375\376\376\377\377"
  "\372\373\374\374\375\375\374\375\376\374\375\377\373\374\374\374\375\376"
  "\376\377\377\370\370\372\367\370\371\374\375\377\377\377\377\373\372\374"
  "\365\366\370\373\374\376\375\376\376\363\362\365\365\366\370\362\361\363"
  "\352\355\357\366\367\371\360\361\363\356\357\360\360\360\364\376\377\377"
  "\364\365\366\360\361\364\357\360\362\356\357\361\357\360\361\370\371\374"
  "\372\373\373\364\365\367\356\357\361\356\357\361\357\356\362\363\365\367"
  "\371\372\374\372\373\375\373\374\374\372\373\375\372\373\376\371\372\373"
  "\371\372\373\371\372\373\371\372\373\371\372\373\371\372\373\371\372\373"
  "\371\372\373\371\372\373\371\372\373\371\372\373\372\373\374\357\362\366"
  "\362\363\366\370\371\373\362\363\365\342\345\350\364\365\370\370\371\373"
  "\362\363\367\357\362\365\370\371\373\366\366\367\344\345\351\357\361\365"
  "\370\371\373\365\366\372\375\376\377\257\267\277\263\271\300\372\374\377"
  "~\251\347\177\252\350\340\345\356\321\320\316\360\361\362\377\377\377\341"
  "\337\335\320\321\322\310\311\315\321\322\323\315\320\322\324\325\326\335"
  "\337\341\322\322\324\320\317\322\307\310\314\316\323\324\321\322\326\316"
  "\313\316\353\356\361\377\375\373\324\324\323\321\323\325\320\320\322\314"
  "\315\322\313\314\315\355\360\363\374\372\371\330\327\326\317\321\325\324"
  "\325\325\336\337\342\317\315\320\304\305\304\344\347\354\377\377\377\342"
  "\340\341\344\344\345\350\347\350\335\337\340\314\313\314\301\301\303\276"
  "\300\304\320\323\331\377\377\377\350\346\345\327\324\323\303\307\311\320"
  "\320\320\317\320\323\322\323\324\341\343\343\334\334\335\323\322\323\273"
  "\274\277\306\307\310\335\340\343\337\336\335\321\322\324\316\317\321\354"
  "\355\357\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\362\363\367\365\366\371\377\377\377\353\351\347\274"
  "\276\302\353\356\361\377\377\377\365\366\371\360\361\366\377\377\377\370"
  "\366\366\320\322\322\340\343\347\377\377\377\373\373\375\375\375\376\256"
  "\266\277\263\272\300\371\373\377}\252\350j\237\346\337\345\357\345\343\341"
  "\365\366\370\377\377\377\346\346\345\353\355\356\347\350\351\356\357\356"
  "\347\346\351\343\345\345\337\337\341\351\350\351\353\353\354\335\335\335"
  "\342\344\344\356\356\360\345\343\342\353\354\357\361\361\360\310\311\314"
  "\345\347\351\337\337\341\337\337\337\337\340\337\353\356\357\365\364\363"
  "\344\345\345\350\350\350\345\346\347\340\337\340\342\342\343\340\341\340"
  "\347\350\353\372\373\372\364\363\364\370\370\371\367\366\366\371\370\370"
  "\353\353\352\347\346\347\345\346\346\350\351\352\372\372\373\367\367\366"
  "\361\357\360\345\345\346\344\346\346\351\351\351\345\345\346\363\364\365"
  "\365\363\364\350\350\351\345\344\345\350\351\352\357\356\357\330\327\326"
  "\324\327\332\316\317\317\350\351\355\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\361\363\366\364\365\371"
  "\377\377\377\367\365\366\351\352\353\365\367\371\377\377\377\365\366\371"
  "\360\361\366\377\377\377\372\372\371\335\335\337\357\360\362\377\377\377"
  "\373\373\374\375\375\376\256\266\277\261\270\300\377\377\377\352\356\366"
  "\346\353\365\372\371\371\370\371\370\365\366\370\374\374\376\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\374\375\376\371\373\373\371\372\373\377\377\377\377\377\377\377\377\377"
  "\377\377\377\374\373\376\372\373\374\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\376\375\376\371\372\373\376\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\376\375\376\371\370\373\376\375\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\372\373\374\377\377\377\373\374\374\373\374\377"
  "\375\377\377\374\375\376\374\375\376\374\375\376\374\375\376\374\375\376"
  "\374\375\376\374\375\376\374\375\376\374\375\376\374\375\376\374\375\376"
  "\375\375\375\361\362\366\362\365\366\372\372\374\373\373\375\374\374\376"
  "\373\373\374\372\372\374\364\365\366\357\361\365\371\372\374\373\373\375"
  "\373\372\374\374\373\375\372\372\374\367\370\373\375\375\376\257\266\277"
  "\260\267\300\377\377\377\377\377\372\377\376\371\374\373\372\371\371\372"
  "\363\366\366\360\363\370\362\363\367\364\365\371\364\365\371\364\365\371"
  "\363\365\370\363\364\370\363\364\370\363\364\370\361\364\370\362\363\367"
  "\362\363\367\362\365\367\360\363\367\363\365\371\364\365\371\364\366\371"
  "\365\366\371\363\366\371\364\365\371\363\365\371\363\365\371\363\365\370"
  "\363\364\370\362\364\370\362\364\370\362\365\371\364\365\371\364\365\371"
  "\364\365\371\363\366\371\363\364\370\361\364\370\362\364\370\364\365\371"
  "\364\365\371\363\364\370\362\365\371\363\365\371\363\366\370\362\363\367"
  "\360\361\365\357\361\365\357\360\365\357\360\365\357\360\364\357\360\364"
  "\357\360\364\357\360\364\357\360\365\357\360\365\357\361\365\360\361\365"
  "\360\361\365\360\361\365\357\361\365\357\360\364\356\357\364\356\357\364"
  "\356\357\364\356\357\364\356\357\364\356\357\364\356\357\364\356\357\364"
  "\356\357\364\356\357\364\356\360\364\360\361\365\360\361\364\357\360\365"
  "\357\362\365\360\362\367\360\361\366\360\361\366\357\361\365\357\362\365"
  "\357\362\363\357\361\365\360\363\366\360\361\366\361\362\367\357\362\365"
  "\360\361\366\376\377\377\257\266\277\261\270\300\377\377\377\325\337\363"
  "\325\337\362\363\365\365\345\346\345\362\363\365\377\376\377\351\350\347"
  "\334\336\340\334\337\341\361\362\364\370\367\370\367\371\371\367\367\371"
  "\361\362\361\351\353\356\377\377\377\374\372\372\351\350\351\337\341\341"
  "\371\372\373\367\366\367\367\366\370\361\362\362\346\347\350\365\366\367"
  "\370\370\370\366\366\366\370\367\370\365\366\366\366\367\370\373\372\371"
  "\353\353\355\336\337\337\343\343\345\341\342\344\347\351\353\367\370\370"
  "\357\357\357\352\351\352\341\343\343\333\336\340\342\343\345\367\370\371"
  "\362\363\364\367\366\367\365\365\367\377\377\377\377\377\377\377\377\377"
  "\377\376\377\377\376\377\377\376\377\377\376\377\377\376\377\377\376\377"
  "\377\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\376\377\377\376\377\377\376\377\377\376\377\377\376\377\377\376\377"
  "\377\376\377\377\376\377\377\376\377\377\376\377\377\376\377\377\377\377"
  "\377\377\377\361\364\367\364\364\370\375\377\377\361\357\360\315\321\322"
  "\361\364\367\375\376\376\364\365\370\357\361\365\375\374\376\370\370\370"
  "\326\327\331\354\355\360\376\375\377\371\372\373\375\375\376\257\266\277"
  "\263\272\300\370\373\376h\240\346j\243\350\333\341\355\315\313\311\360\362"
  "\364\377\377\377\335\333\330\323\323\326\304\303\304\306\311\314\276\277"
  "\302\310\307\312\277\300\305\320\321\324\320\321\326\372\372\373\350\346"
  "\343\315\315\322\345\347\351\351\347\346\266\266\271\277\300\303\274\302"
  "\306\303\304\310\310\311\314\304\303\306\274\275\276\305\305\307\272\275"
  "\300\324\327\336\356\360\361\340\337\340\313\313\315\313\315\316\323\322"
  "\323\315\314\317\320\324\326\341\341\342\326\325\330\307\311\312\300\277"
  "\302\322\325\330\344\346\345\303\302\303\303\304\311\311\312\317\376\375"
  "\376\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\361\363\366\364\365\367\377\377"
  "\377\354\352\351\306\310\312\354\355\361\377\377\377\365\366\371\360\361"
  "\366\377\377\377\367\365\366\320\321\323\340\343\347\377\377\377\373\373"
  "\374\375\375\376\256\266\277\262\271\300\375\375\377\242\276\353\224\265"
  "\350\351\354\364\360\357\355\366\367\371\377\377\377\366\365\365\372\372"
  "\371\370\371\370\370\371\370\372\371\370\372\371\370\366\365\366\370\372"
  "\370\372\372\372\363\363\363\367\367\371\373\373\373\377\377\377\377\377"
  "\377\370\370\367\370\370\371\367\370\371\366\365\365\357\360\362\370\370"
  "\370\353\353\352\366\367\367\371\370\371\375\376\377\377\377\377\376\376"
  "\375\372\371\371\367\367\366\373\372\371\372\371\372\373\374\373\377\377"
  "\377\375\374\373\373\372\371\372\373\372\373\372\373\364\364\363\342\342"
  "\344\360\357\360\337\340\344\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\362\363\367\365\366\370\377\377\377\374\374\374\370\370\370\374\373"
  "\374\377\377\377\365\366\370\360\361\366\376\375\377\375\375\375\357\357"
  "\357\367\371\373\377\377\377\373\373\375\375\375\376\256\267\277\260\267"
  "\300\377\377\377\373\373\371\373\372\370\375\374\372\371\371\371\363\366"
  "\370\365\366\372\372\373\375\373\374\376\373\374\376\372\373\376\372\373"
  "\375\371\373\375\371\373\375\371\372\375\371\372\375\367\371\373\367\370"
  "\372\371\372\374\370\371\373\370\371\373\371\372\375\372\373\375\372\373"
  "\376\373\374\376\371\374\376\373\374\376\371\372\374\372\373\375\372\373"
  "\375\371\372\374\371\372\374\371\373\375\373\374\376\373\374\376\372\373"
  "\376\372\373\375\371\372\374\371\372\374\371\373\375\372\374\376\373\374"
  "\376\373\374\376\373\373\375\372\373\375\374\375\377\372\373\375\372\373"
  "\375\370\371\373\367\370\372\366\370\372\366\367\372\366\367\372\366\367"
  "\371\365\366\371\365\366\371\365\366\371\365\366\371\365\366\371\365\366"
  "\371\365\366\371\365\366\371\365\366\371\365\366\371\365\366\371\365\366"
  "\371\365\366\371\365\366\371\365\366\371\365\366\371\365\366\371\365\366"
  "\371\365\366\371\365\367\371\365\366\372\360\361\364\360\361\365\364\365"
  "\370\364\366\371\365\367\372\364\366\371\364\365\370\361\362\365\357\360"
  "\365\364\365\370\364\366\371\367\371\372\365\366\371\364\365\370\363\364"
  "\370\376\376\377\257\267\277\260\267\300\377\377\377\377\375\373\374\374"
  "\370\375\375\372\366\367\367\364\365\367\365\366\372\361\363\365\362\363"
  "\367\362\365\370\370\371\374\370\371\375\366\370\373\367\370\373\367\370"
  "\372\370\371\373\370\372\375\370\372\375\370\371\375\366\367\373\367\370"
  "\373\370\371\373\366\370\372\371\372\376\371\372\374\371\372\376\370\371"
  "\375\367\370\374\367\370\373\362\364\370\364\367\371\363\364\366\355\357"
  "\362\357\362\365\362\363\367\363\366\371\365\366\371\370\371\373\365\366"
  "\370\364\365\367\362\363\367\363\364\367\362\363\367\366\367\373\371\372"
  "\374\366\367\371\362\365\367\363\364\370\362\364\367\362\364\367\367\370"
  "\372\366\371\373\370\371\374\365\366\372\365\366\370\362\365\367\362\364"
  "\367\362\364\367\362\364\367\362\364\367\362\364\367\362\364\367\362\364"
  "\367\362\364\367\362\364\367\362\364\367\362\364\367\362\364\367\362\364"
  "\367\362\364\367\362\364\367\362\364\367\362\364\367\362\365\367\363\364"
  "\370\360\361\364\357\362\365\363\364\367\361\363\366\352\355\360\361\364"
  "\367\363\364\367\361\362\365\357\362\365\362\364\367\362\363\367\353\354"
  "\360\360\362\366\363\365\367\362\364\370\376\376\377\257\267\277\262\271"
  "\300\376\376\377\243\277\353\244\275\353\350\353\361\326\324\324\360\361"
  "\364\377\377\377\342\340\341\316\316\320\323\326\330\346\347\347\345\344"
  "\345\350\353\355\377\377\377\346\346\345\340\341\342\346\346\346\345\344"
  "\346\336\335\335\357\360\362\377\377\377\340\340\340\327\326\330\342\345"
  "\345\341\342\343\343\342\343\342\341\341\351\354\357\377\377\377\346\344"
  "\345\350\350\351\350\350\353\334\332\332\322\323\325\332\332\332\331\332"
  "\334\330\331\336\377\377\377\357\355\352\336\335\336\317\320\320\330\327"
  "\331\321\322\326\336\337\337\351\352\353\342\341\342\334\333\334\307\310"
  "\312\316\320\322\337\340\342\356\357\356\340\337\342\344\345\346\356\357"
  "\357\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\362\363\367\365\366\370\377\377"
  "\377\355\353\351\303\304\306\355\360\364\377\377\377\365\366\370\360\361"
  "\366\376\376\377\370\366\366\322\324\326\344\347\353\377\376\377\374\373"
  "\375\375\375\376\256\267\277\263\272\300\370\373\376o\243\350Z\232\346\333"
  "\341\354\333\331\326\364\365\365\377\377\377\334\334\335\330\330\330\321"
  "\322\325\330\327\330\322\323\324\325\330\335\375\374\374\325\325\326\322"
  "\324\327\333\330\333\323\323\324\302\304\310\344\347\352\373\372\370\323"
  "\322\323\314\316\322\324\325\326\335\335\337\321\315\316\317\320\323\324"
  "\330\332\376\376\377\360\360\357\361\361\362\357\357\360\357\357\360\340"
  "\340\340\322\322\324\335\336\337\325\326\331\375\376\375\363\363\363\347"
  "\347\350\320\321\323\327\331\331\332\332\334\330\332\332\344\345\350\351"
  "\351\352\337\336\337\320\321\322\326\327\332\336\337\342\333\334\331\303"
  "\306\313\305\304\305\330\331\340\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\361"
  "\363\366\364\365\367\377\377\377\361\357\357\331\332\333\361\362\364\377"
  "\377\377\365\366\371\357\361\366\377\377\377\371\367\367\325\326\326\346"
  "\351\354\377\377\377\373\372\374\375\375\376\256\266\277\261\270\300\377"
  "\377\377\320\333\361\310\326\360\364\366\370\366\366\365\365\366\371\376"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\376\375\371\372\371\375\376\375\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\376\375\370\371\371\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\375\374\375\367\370\371\375\377\376\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\367\370\370\376\376\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\370\371\370\372\373\374\371\370\367\367\371\371\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\361\364\367\363\364\370\376\375\376\375"
  "\375\375\375\376\376\375\375\377\376\375\375\364\365\370\360\361\365\374"
  "\374\375\375\375\377\371\371\373\374\375\376\376\375\375\372\371\375\375"
  "\375\376\257\267\277\260\267\277\377\377\377\377\377\372\377\376\371\374"
  "\373\371\371\371\371\363\366\366\362\363\367\363\366\370\364\367\371\364"
  "\367\371\363\366\372\363\366\370\363\365\370\362\365\367\362\364\367\362"
  "\365\367\362\365\370\363\366\370\363\366\372\363\366\370\363\365\370\362"
  "\365\367\362\363\367\362\365\367\362\365\367\362\365\370\362\365\370\362"
  "\365\367\361\362\366\361\364\366\361\364\366\362\365\367\363\365\370\364"
  "\366\371\364\367\372\364\367\371\364\367\373\363\365\370\361\364\367\362"
  "\365\367\364\366\371\364\367\373\364\367\373\364\366\371\362\365\370\362"
  "\365\367\363\366\372\364\367\371\365\367\372\365\367\373\364\367\373\364"
  "\367\371\364\366\372\362\365\371\360\361\365\357\360\364\356\357\364\356"
  "\357\364\356\357\364\356\357\364\356\357\364\356\357\364\356\357\364\356"
  "\357\364\356\357\364\356\357\364\356\357\364\356\357\364\356\357\364\356"
  "\357\364\356\357\364\356\357\364\356\357\364\356\360\364\360\361\365\360"
  "\361\364\357\361\365\357\361\365\360\363\366\361\364\367\361\362\366\356"
  "\361\365\357\362\365\357\362\363\357\361\365\357\362\366\361\364\367\362"
  "\363\366\356\361\365\360\363\366\376\376\377\257\267\277\260\270\300\377"
  "\377\377\356\361\366\356\360\365\371\372\372\357\357\357\363\365\366\373"
  "\374\376\356\356\360\351\353\355\347\350\353\365\366\372\374\375\375\370"
  "\370\372\367\370\372\376\377\377\366\367\370\367\370\372\370\371\373\371"
  "\370\372\365\366\370\375\375\377\373\374\374\377\377\377\366\366\370\370"
  "\372\372\375\374\376\375\376\376\373\373\375\374\375\376\375\374\377\361"
  "\363\365\363\364\367\361\360\362\345\346\350\346\347\351\350\350\352\346"
  "\347\353\360\363\365\377\377\377\363\364\365\357\356\361\354\357\361\354"
  "\355\357\355\356\360\371\372\375\370\371\372\362\363\364\355\356\361\353"
  "\354\356\354\355\357\365\366\370\371\372\373\373\374\374\373\372\374\373"
  "\374\376\373\375\375\372\374\374\372\373\374\372\373\374\372\373\374\372"
  "\373\374\372\373\374\372\373\374\372\373\374\372\373\374\372\373\374\372"
  "\373\374\372\373\374\372\373\374\372\373\374\372\373\374\372\373\374\372"
  "\373\374\372\374\374\374\373\375\357\362\366\362\363\366\372\373\375\362"
  "\362\363\340\341\345\364\365\370\372\373\374\362\363\366\357\362\365\372"
  "\371\373\366\366\370\343\344\346\357\357\363\372\373\375\367\370\372\375"
  "\376\377\257\267\277\263\271\300\373\374\377v\245\347x\250\350\336\344\356"
  "\321\317\315\360\361\362\377\377\377\340\336\334\336\337\340\330\327\332"
  "\311\313\313\314\315\320\311\314\316\321\322\326\371\371\374\352\350\345"
  "\307\310\311\316\322\325\313\314\320\307\312\312\312\311\313\316\317\324"
  "\375\377\377\343\340\337\307\313\315\313\313\315\311\313\315\306\310\310"
  "\351\354\360\377\377\377\337\335\337\344\344\345\347\347\350\345\344\345"
  "\340\337\342\343\343\343\320\317\320\334\341\344\377\377\377\343\343\342"
  "\321\317\320\305\313\315\312\313\314\320\322\322\320\317\321\341\342\343"
  "\334\332\335\317\316\317\267\270\275\304\305\311\341\346\346\330\327\331"
  "\317\320\322\313\316\321\360\360\362\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\362\363\366"
  "\365\366\371\377\377\377\353\351\347\274\276\300\353\356\361\377\377\377"
  "\365\366\371\360\361\366\377\377\377\370\366\366\320\321\322\340\343\347"
  "\377\377\377\373\373\375\375\375\376\256\266\277\263\271\300\373\374\377"
  "\204\256\351q\243\347\341\347\357\347\345\343\365\366\370\377\377\377\352"
  "\350\351\362\363\364\370\370\371\355\355\355\347\346\347\347\350\352\357"
  "\360\361\366\366\365\356\356\355\345\350\350\360\361\362\354\353\354\333"
  "\335\333\321\321\325\346\350\350\367\370\367\360\357\357\355\354\355\351"
  "\350\351\351\350\351\350\347\350\353\355\355\371\373\372\365\367\366\372"
  "\371\371\370\367\367\372\373\373\372\372\371\372\371\372\363\363\362\355"
  "\356\357\372\371\372\367\367\366\363\361\362\351\350\351\353\352\353\356"
  "\355\356\352\354\354\366\367\370\366\364\365\356\355\356\352\353\354\355"
  "\354\355\361\362\361\324\325\327\335\336\340\321\322\324\360\361\364\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\362\363\366\364\366\371\377\377\377\371\367\367\354"
  "\356\356\367\370\370\377\377\377\365\366\371\360\361\366\377\377\377\374"
  "\372\372\343\342\343\361\362\364\377\377\377\373\373\375\375\375\376\256"
  "\266\277\261\270\300\377\377\377\356\361\366\354\360\365\373\372\371\370"
  "\370\370\365\366\370\372\374\376\377\376\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\371\372\373\373\373\375\377"
  "\377\377\377\377\377\377\377\377\376\376\377\375\376\376\377\377\377\372"
  "\373\374\374\375\375\377\377\377\377\377\377\377\377\377\377\377\377\373"
  "\373\375\370\371\372\375\375\377\375\376\377\375\376\377\375\376\377\375"
  "\376\377\376\377\377\376\377\377\374\374\375\370\370\372\376\376\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\373\374\374\377"
  "\377\377\373\374\374\376\377\377\375\376\376\373\375\375\373\374\375\373"
  "\374\375\373\374\375\373\374\375\373\375\375\373\374\375\373\374\375\373"
  "\374\375\373\374\375\373\374\375\372\374\374\372\373\374\372\373\374\372"
  "\373\374\372\373\374\372\373\374\372\374\374\374\373\375\357\362\366\362"
  "\363\366\371\372\374\371\373\375\373\374\375\372\373\374\371\372\374\362"
  "\363\366\357\361\365\371\370\372\371\373\375\373\372\374\372\373\375\371"
  "\372\374\367\370\371\375\376\377\257\267\277\260\267\277\377\377\377\377"
  "\377\372\377\376\371\374\373\372\371\372\372\363\366\366\362\363\367\362"
  "\363\367\364\365\371\364\365\370\364\367\373\363\366\370\363\366\372\362"
  "\365\367\361\364\367\362\364\367\362\365\370\363\366\372\364\365\371\363"
  "\364\370\362\365\367\363\366\370\362\365\371\364\365\371\362\365\367\361"
  "\362\366\362\364\367\363\366\370\363\366\372\362\365\367\361\362\366\362"
  "\365\367\363\364\371\363\366\372\363\366\372\363\366\370\363\364\370\362"
  "\365\367\363\365\370\362\365\371\363\364\370\362\365\367\361\364\366\363"
  "\364\370\363\364\370\364\365\371\364\365\371\365\366\371\363\365\371\362"
  "\363\367\361\364\367\363\366\372\363\364\370\363\366\372\364\365\371\362"
  "\365\371\363\364\370\364\365\371\363\364\370\362\365\371\363\364\370\364"
  "\365\371\364\365\370\362\363\367\363\364\370\363\364\370\362\365\371\361"
  "\364\366\357\360\364\356\360\364\356\357\364\356\357\364\356\357\364\356"
  "\360\364\360\361\365\360\361\364\357\361\365\357\362\365\361\362\365\356"
  "\361\365\361\361\367\357\361\365\357\362\365\357\362\363\357\361\365\360"
  "\363\366\356\361\364\361\362\367\357\362\365\360\363\366\376\376\377\257"
  "\267\277\261\270\300\377\377\377\317\332\361\314\330\361\362\363\365\343"
  "\344\343\361\363\365\377\377\377\347\345\346\331\332\335\335\340\344\363"
  "\363\365\364\364\364\364\363\364\361\362\363\377\377\377\375\373\374\365"
  "\364\365\363\364\365\347\351\350\361\363\366\377\377\377\366\365\364\344"
  "\346\350\355\355\357\370\372\372\377\377\377\372\372\372\364\363\364\364"
  "\364\364\366\365\367\377\377\377\365\363\363\347\347\347\357\361\361\364"
  "\364\364\362\362\362\352\351\355\377\377\377\366\365\364\344\346\350\355"
  "\355\357\370\371\372\377\377\377\355\355\356\347\346\347\337\340\342\334"
  "\336\337\330\331\335\340\337\341\333\336\342\337\340\344\377\377\377\363"
  "\360\361\347\346\347\333\336\341\337\336\337\333\334\336\354\355\357\365"
  "\364\364\352\352\354\340\340\342\331\331\332\336\335\341\347\352\354\366"
  "\365\364\360\360\362\363\364\364\370\367\371\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\361\364\367\363"
  "\364\370\377\377\377\361\357\357\313\315\320\361\362\365\377\376\376\364"
  "\365\370\360\361\365\375\376\376\370\370\370\326\325\327\352\353\356\376"
  "\377\377\372\371\373\375\375\376\257\267\277\263\272\300\370\373\376h\240"
  "\346g\241\350\332\341\355\317\315\313\362\361\364\377\377\377\333\332\331"
  "\314\314\312\301\302\307\323\321\325\301\302\305\303\302\303\274\300\305"
  "\375\376\377\347\345\342\311\313\316\316\315\316\305\310\311\324\330\335"
  "\376\376\375\331\332\331\313\314\321\317\316\320\334\340\344\376\375\375"
  "\326\326\331\307\304\307\304\305\310\312\316\324\377\377\376\320\320\317"
  "\300\300\303\314\313\316\301\303\305\300\300\304\323\324\331\375\375\374"
  "\331\333\332\313\314\321\321\316\320\334\337\343\377\377\377\351\347\347"
  "\327\327\330\311\315\317\323\322\323\314\315\316\337\342\343\351\350\347"
  "\326\330\331\377\377\377\357\356\356\335\334\336\306\307\310\316\321\323"
  "\320\323\326\316\317\321\335\340\341\341\341\341\327\325\327\300\303\306"
  "\307\313\315\333\334\335\331\331\330\303\304\307\275\276\302\333\337\343"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\361\363\366\364\365\367\377\377\377\355\352\352\312\314\316"
  "\354\357\361\377\377\377\365\366\371\357\361\366\377\377\377\367\365\366"
  "\321\321\323\341\344\350\376\377\377\373\372\374\375\375\376\256\266\277"
  "\262\271\300\376\376\377\252\303\354\234\272\352\354\357\363\362\360\357"
  "\366\367\371\377\377\377\371\371\370\374\374\373\374\374\375\377\377\377"
  "\374\374\373\376\376\375\371\371\372\366\367\366\354\355\354\366\370\371"
  "\374\375\374\377\376\377\370\370\370\363\365\364\370\370\370\375\375\376"
  "\365\364\363\361\363\363\366\365\366\365\366\365\372\372\371\371\372\371"
  "\366\365\366\364\366\365\367\367\370\372\374\375\376\376\376\375\374\375"
  "\374\374\374\371\371\371\364\363\364\370\370\371\375\375\376\365\364\363"
  "\361\362\363\366\365\366\375\375\376\377\377\376\375\375\376\376\375\376"
  "\375\375\374\377\377\377\377\377\377\367\366\366\364\363\364\375\375\376"
  "\377\377\376\374\373\373\373\372\371\374\375\374\375\374\375\377\377\377"
  "\377\377\377\375\375\375\375\374\375\375\376\375\376\376\375\353\353\352"
  "\357\360\361\354\352\352\361\362\364\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\362\363\367\365\366\370"
  "\377\377\377\375\373\374\372\371\372\374\373\375\377\377\377\365\366\370"
  "\360\361\366\376\375\377\375\375\375\361\362\362\371\372\372\377\377\377"
  "\374\373\375\375\375\376\256\267\277\260\267\300\377\377\377\375\374\371"
  "\374\374\370\374\374\372\371\371\371\363\365\370\363\366\371\370\371\373"
  "\371\372\374\371\372\374\370\371\373\370\371\373\370\371\373\367\371\373"
  "\366\367\371\366\370\372\370\371\373\370\371\373\370\371\373\370\371\373"
  "\366\367\371\367\371\373\370\371\373\367\372\374\367\370\374\366\367\371"
  "\370\371\373\367\371\373\367\371\373\370\371\373\366\367\371\370\371\373"
  "\370\371\373\370\371\373\370\371\373\370\371\374\370\372\374\367\370\372"
  "\370\372\374\370\371\373\366\371\373\366\367\373\366\367\371\367\371\373"
  "\370\371\374\371\372\374\371\372\374\371\372\374\370\371\373\367\370\372"
  "\367\370\373\366\367\371\370\371\373\370\372\374\371\372\374\371\372\374"
  "\370\371\373\370\371\373\370\371\373\370\371\374\371\372\374\371\372\374"
  "\370\371\373\370\371\374\367\370\374\371\372\375\367\370\374\365\370\372"
  "\364\366\370\363\365\367\363\364\367\363\364\367\363\364\367\364\365\367"
  "\363\366\370\360\361\364\360\361\365\362\365\367\363\366\371\365\366\372"
  "\363\365\371\362\365\366\361\362\365\357\362\365\362\363\366\363\365\371"
  "\366\367\372\365\366\371\362\365\366\362\364\370\376\376\377\257\267\277"
  "\260\267\300\377\377\377\374\373\371\373\373\370\374\373\372\367\367\367"
  "\364\365\367\367\370\372\362\363\365\360\362\365\364\367\371\374\375\377"
  "\371\372\376\366\367\371\370\373\375\371\372\375\371\372\376\372\373\375"
  "\372\373\375\371\372\376\366\370\372\367\372\374\371\372\376\367\370\372"
  "\366\366\372\366\371\373\373\374\376\371\372\375\370\373\375\371\371\375"
  "\371\373\375\372\374\376\373\374\376\373\374\376\364\365\370\371\373\375"
  "\360\361\365\370\373\375\367\370\372\361\362\366\370\373\375\371\372\374"
  "\364\365\370\365\367\371\365\364\370\355\356\362\356\357\361\357\360\364"
  "\361\364\366\357\362\364\367\372\374\366\370\372\363\365\371\362\363\365"
  "\363\364\366\361\364\366\365\366\372\373\374\376\366\367\371\364\365\367"
  "\363\364\366\363\365\366\362\363\367\370\371\374\367\371\374\373\374\376"
  "\371\372\374\370\371\373\366\367\371\365\366\371\365\366\371\365\366\371"
  "\365\366\371\365\366\371\365\367\371\365\366\372\360\361\364\360\361\365"
  "\364\366\371\362\363\366\350\353\357\363\364\367\364\365\371\361\362\365"
  "\357\360\365\364\365\371\364\365\367\351\352\356\360\363\366\365\366\371"
  "\364\364\370\376\376\377\257\267\277\262\271\300\375\377\377\232\267\353"
  "\232\270\353\347\352\361\324\324\322\360\361\364\377\377\377\340\340\340"
  "\316\315\316\311\314\317\343\344\345\330\331\332\331\332\336\377\377\377"
  "\341\340\341\326\327\330\350\351\355\346\343\344\346\346\346\330\333\333"
  "\330\327\331\363\364\367\372\371\367\321\323\322\325\333\337\353\352\354"
  "\332\330\332\371\372\375\373\371\366\331\332\333\345\347\347\334\334\334"
  "\336\335\335\333\336\340\377\377\377\320\313\316\335\340\344\334\330\330"
  "\305\311\313\346\350\353\377\377\377\357\355\352\346\347\350\346\345\350"
  "\343\341\342\341\341\342\324\324\325\314\313\316\324\325\330\374\375\376"
  "\370\366\365\336\334\337\320\317\322\324\325\327\321\320\321\325\330\332"
  "\344\346\346\336\336\340\331\331\333\315\314\314\303\304\312\332\333\335"
  "\357\360\360\331\332\332\342\341\343\342\344\344\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\362\363\367\365\366\370\377\377\377\355\351\351\301\302\304"
  "\355\356\362\377\377\377\365\366\370\360\361\366\376\377\377\370\366\366"
  "\322\324\324\342\345\351\377\377\377\374\373\375\375\375\376\256\267\277"
  "\263\272\300\370\373\376r\244\350]\234\346\335\342\356\334\332\330\363\365"
  "\367\377\377\377\336\336\337\341\340\341\326\330\332\334\335\334\316\317"
  "\322\331\330\335\371\373\372\342\343\344\335\337\337\321\322\326\324\322"
  "\325\336\336\336\334\336\340\321\321\323\351\353\356\364\364\361\324\325"
  "\326\324\331\335\325\323\325\315\316\321\360\362\364\360\356\355\322\321"
  "\322\315\316\321\323\322\325\325\327\327\332\335\340\374\373\373\342\340"
  "\341\323\325\325\336\332\336\336\335\336\322\325\331\374\374\375\365\365"
  "\364\363\362\363\356\360\360\357\360\361\365\365\364\357\356\356\330\332"
  "\333\334\335\336\366\367\370\370\370\367\353\353\354\331\330\327\327\330"
  "\333\340\341\342\334\336\336\336\340\342\353\353\354\342\341\342\333\332"
  "\333\324\327\331\340\341\342\340\341\340\302\303\306\316\317\320\311\313"
  "\322\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\361\363\366\364\365\367\377\377"
  "\377\362\360\361\334\336\340\360\363\366\377\377\377\365\366\371\357\361"
  "\366\377\377\377\371\367\367\326\326\330\350\353\355\377\377\377\373\372"
  "\374\375\375\376\256\266\277\261\270\300\377\377\377\327\341\363\321\335"
  "\360\365\367\370\367\370\365\365\366\370\376\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\376\370\372\371\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\374\374\374\372\372\373\377\377\377\377\377\377\377\377\377\377\377"
  "\377\374\374\373\372\374\375\377\377\377\373\375\375\377\377\377\377\377"
  "\377\375\375\375\371\372\373\377\377\377\377\377\377\377\377\377\377\377"
  "\377\370\371\372\371\371\371\374\375\376\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\371\371\372\374\374"
  "\375\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\375\374"
  "\373\371\372\373\376\376\374\366\367\370\377\377\377\377\377\377\377\377"
  "\377\377\376\377\377\376\377\377\376\377\377\376\377\377\377\377\377\377"
  "\377\361\364\367\363\364\370\374\375\375\375\375\375\375\376\376\375\374"
  "\376\374\375\375\364\365\370\356\361\365\374\374\375\375\375\377\373\373"
  "\373\374\375\375\376\375\376\370\371\373\375\375\376\257\267\277\260\267"
  "\300\377\377\377\377\377\372\377\376\371\374\373\371\371\371\371\363\366"
  "\366\360\363\367\363\364\370\364\365\371\364\365\371\364\365\371\363\364"
  "\370\363\364\371\363\364\371\363\364\370\362\363\367\362\363\367\362\363"
  "\367\363\364\370\363\364\370\362\364\370\363\364\370\363\364\370\362\363"
  "\367\362\363\367\363\364\370\363\364\370\362\364\370\362\364\370\362\363"
  "\367\362\363\367\362\363\367\363\364\370\364\365\371\364\366\371\364\366"
  "\371\364\365\371\363\364\370\362\364\370\362\363\367\362\364\370\363\364"
  "\370\364\365\371\364\365\371\363\365\370\362\364\370\362\363\367\363\364"
  "\370\364\366\371\365\366\372\364\366\371\363\364\370\363\364\370\362\364"
  "\370\362\363\367\361\362\366\360\361\365\357\361\365\357\361\365\360\361"
  "\365\360\361\365\360\361\365\360\362\366\361\362\366\361\362\366\360\362"
  "\366\357\361\364\356\360\364\356\360\364\356\360\364\356\360\364\356\360"
  "\364\356\360\364\356\360\364\360\361\365\360\361\364\357\360\365\357\361"
  "\365\360\363\366\361\362\367\360\362\366\357\361\365\357\362\365\357\362"
  "\363\357\361\365\357\362\366\361\362\367\360\363\366\357\361\365\360\361"
  "\366\376\376\377\257\267\277\261\270\300\377\377\377\352\356\366\350\355"
  "\366\370\370\370\355\356\355\363\364\366\374\374\376\355\356\357\352\353"
  "\355\351\354\354\365\367\371\371\372\372\367\370\371\364\365\365\372\373"
  "\376\372\373\373\377\377\377\366\366\366\361\363\365\373\374\375\373\373"
  "\375\373\375\375\365\366\366\372\373\375\370\370\372\365\366\370\373\375"
  "\375\375\374\375\372\373\374\373\374\375\377\377\377\361\362\363\363\364"
  "\365\361\361\363\345\346\350\352\353\357\366\366\367\366\366\370\363\365"
  "\367\377\377\377\364\364\364\357\356\361\352\353\355\353\352\354\352\353"
  "\355\365\367\370\372\372\372\362\362\364\353\355\357\352\351\353\353\352"
  "\354\360\363\365\371\373\373\371\371\373\372\373\373\372\373\375\376\377"
  "\377\374\374\376\374\373\376\374\373\376\374\374\376\374\374\376\374\374"
  "\376\374\374\376\374\374\376\374\374\376\374\373\376\374\373\376\374\373"
  "\376\374\373\376\374\373\376\374\373\376\374\373\376\374\374\376\374\375"
  "\375\361\362\366\362\365\366\374\373\375\362\362\362\335\335\341\362\365"
  "\370\374\373\374\362\365\366\357\361\365\371\373\374\370\367\370\341\342"
  "\344\355\360\363\374\373\375\367\370\373\375\376\376\257\267\277\263\272"
  "\300\371\373\377r\243\346v\246\350\334\342\354\321\317\315\360\361\362\377"
  "\377\377\341\337\336\310\307\310\302\301\302\310\312\315\312\317\322\315"
  "\314\317\301\304\305\312\312\312\307\310\313\365\370\371\357\353\353\304"
  "\306\311\317\322\323\305\306\311\307\313\313\305\306\312\362\363\366\356"
  "\354\353\303\302\307\310\311\313\303\305\311\307\310\311\334\341\345\377"
  "\377\377\344\343\343\346\345\347\350\350\352\332\332\333\304\305\310\310"
  "\310\312\312\312\314\317\323\331\377\377\377\351\351\350\330\326\327\301"
  "\304\307\314\315\316\317\320\322\316\317\322\337\340\341\334\333\334\322"
  "\322\322\272\272\275\306\305\310\331\335\337\335\334\332\313\314\317\306"
  "\310\314\346\350\352\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\362\363\366\364\366\371\377\377\377\353"
  "\351\347\272\276\300\353\356\361\377\377\377\365\366\371\360\361\366\377"
  "\377\377\367\365\366\320\321\321\340\341\347\377\377\377\373\373\375\375"
  "\375\376\256\266\277\263\271\300\372\374\377\212\261\351x\247\347\344\350"
  "\361\352\350\347\364\365\370\377\377\377\364\364\363\357\360\357\357\356"
  "\357\355\356\354\363\364\365\362\362\361\344\345\344\325\326\327\351\350"
  "\353\365\366\366\365\364\364\356\355\354\361\362\363\361\361\360\356\355"
  "\356\353\352\353\363\363\364\363\363\362\360\360\360\356\357\356\356\356"
  "\356\355\354\355\354\353\356\370\371\370\367\370\370\373\374\374\372\372"
  "\371\372\372\373\362\360\360\362\364\363\364\363\364\357\357\360\370\371"
  "\370\370\372\371\366\365\366\355\355\354\356\356\356\361\362\361\360\357"
  "\360\367\371\370\371\371\370\362\362\361\356\360\357\360\360\360\363\365"
  "\364\336\336\335\337\340\342\327\326\331\351\353\355\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\362\363"
  "\367\364\366\371\377\377\377\371\370\371\360\361\362\371\370\372\377\377"
  "\377\365\366\371\360\361\366\377\377\377\374\373\372\346\346\346\362\364"
  "\366\377\377\377\373\373\375\375\375\376\256\266\277\260\270\300\377\377"
  "\377\363\363\367\360\363\367\372\373\372\371\372\370\364\365\370\371\372"
  "\374\375\376\377\377\377\377\377\377\377\376\377\377\377\377\377\377\377"
  "\377\377\377\377\373\374\376\377\377\377\372\373\373\371\372\375\375\376"
  "\377\377\377\377\376\377\377\376\377\377\376\377\377\372\373\373\371\373"
  "\375\376\377\377\376\377\377\377\377\377\377\377\377\373\375\375\371\370"
  "\372\374\375\375\375\374\377\373\375\377\376\376\377\375\377\377\377\377"
  "\377\377\377\377\376\375\377\370\371\373\375\374\376\377\376\377\376\377"
  "\377\376\377\377\376\377\377\377\377\377\377\376\377\377\376\377\375\377"
  "\377\376\377\377\377\377\377\377\377\377\375\376\376\377\377\377\375\376"
  "\376\374\375\375\374\374\376\371\372\375\371\372\374\371\372\374\371\372"
  "\374\371\372\374\371\372\374\371\372\374\371\372\374\371\372\374\371\372"
  "\374\371\372\374\371\372\374\371\372\374\371\372\374\371\372\374\371\372"
  "\374\371\372\374\372\373\374\357\362\366\362\363\366\367\370\372\370\371"
  "\373\371\372\374\370\371\373\367\370\372\362\363\367\357\362\365\367\370"
  "\372\370\371\373\371\372\374\371\372\373\367\370\372\365\366\372\375\376"
  "\377\257\267\277\257\267\277\377\377\377\377\375\372\376\375\371\373\373"
  "\371\370\371\371\363\366\367\363\364\370\360\363\367\362\365\371\362\365"
  "\371\363\364\370\363\366\372\363\366\372\363\366\372\363\366\372\363\366"
  "\372\363\365\371\362\364\370\362\365\371\363\364\370\362\365\370\363\366"
  "\372\363\365\371\362\365\371\364\365\371\361\364\370\363\366\372\363\366"
  "\371\363\366\371\363\366\372\363\366\372\361\364\370\362\365\371\361\364"
  "\370\361\364\367\363\365\371\362\364\370\360\363\367\363\364\371\363\366"
  "\371\362\365\370\362\363\366\364\365\371\363\364\370\363\364\370\362\365"
  "\371\362\363\367\362\364\370\364\365\371\364\365\371\363\365\371\362\365"
  "\371\363\366\372\363\365\371\363\364\370\364\365\370\363\365\371\362\364"
  "\370\361\363\367\360\363\366\357\362\366\357\362\366\357\362\366\357\362"
  "\366\357\362\366\357\362\366\357\362\366\357\362\366\357\362\366\357\362"
  "\366\357\362\366\357\362\366\357\362\366\360\362\366\361\363\365\361\361"
  "\365\357\362\365\361\362\366\361\362\366\355\357\363\361\362\367\361\362"
  "\365\360\362\365\360\362\366\357\362\365\360\363\367\356\357\362\357\362"
  "\367\361\362\366\360\363\367\376\376\377\257\267\277\260\267\300\375\377"
  "\377\307\324\356\302\322\355\351\355\362\340\337\341\357\360\361\374\375"
  "\374\337\337\337\343\342\344\346\347\351\353\354\356\357\357\360\353\354"
  "\354\356\357\360\360\357\360\356\355\356\357\356\360\372\373\374\374\373"
  "\372\352\353\354\340\340\342\353\354\354\365\364\364\360\357\360\375\376"
  "\375\355\352\347\352\353\354\356\357\360\356\357\357\356\357\360\357\360"
  "\357\335\336\337\366\367\370\376\375\374\347\347\347\353\352\353\352\350"
  "\350\326\325\327\324\325\327\327\326\330\337\336\340\341\344\350\377\377"
  "\377\354\351\352\340\337\337\332\335\337\330\330\330\327\330\334\354\355"
  "\356\357\356\355\347\346\347\334\333\333\321\324\326\332\331\333\347\352"
  "\354\355\354\355\354\355\356\357\360\356\370\367\370\377\376\377\376\377"
  "\376\376\376\376\376\375\376\376\377\376\376\377\376\376\375\376\376\377"
  "\376\376\377\376\376\375\376\376\376\376\376\377\376\376\376\376\376\376"
  "\376\376\377\376\377\377\375\360\361\365\363\364\366\375\374\374\355\354"
  "\354\316\321\323\357\360\363\375\374\374\363\364\366\356\360\364\373\372"
  "\374\365\364\365\325\326\330\347\352\354\373\374\374\371\371\373\376\376"
  "\377\257\267\277\260\267\300\377\377\377\335\345\362\333\343\361\360\362"
  "\364\355\356\356\363\364\365\370\371\370\360\357\360\355\357\357\357\360"
  "\361\353\354\357\353\354\355\350\351\351\351\352\355\353\354\355\351\352"
  "\353\352\353\354\362\363\366\364\363\364\352\354\354\350\351\354\351\353"
  "\355\356\357\360\351\352\355\364\367\366\356\357\356\351\352\353\351\354"
  "\355\353\354\355\351\352\355\354\354\355\347\350\351\361\362\363\367\367"
  "\370\357\356\357\360\361\362\363\364\365\361\360\361\353\352\354\352\354"
  "\354\357\360\360\356\357\362\370\371\370\357\357\360\356\355\356\355\356"
  "\361\356\357\357\355\356\357\354\355\356\355\356\357\357\357\360\357\360"
  "\361\351\352\352\354\355\357\361\362\363\357\360\357\351\352\353\352\353"
  "\354\360\361\362\365\366\367\365\366\367\364\366\367\364\366\367\365\366"
  "\367\365\366\367\365\366\367\364\366\367\364\366\367\364\366\367\364\366"
  "\367\364\366\367\364\366\367\364\366\367\364\366\367\365\366\367\362\364"
  "\364\363\364\366\367\366\367\362\363\363\352\353\355\362\364\365\365\366"
  "\367\363\364\366\363\364\365\365\366\367\364\365\366\357\360\360\360\361"
  "\363\365\366\367\366\367\367\377\377\377\256\266\300\257\267\300\377\377"
  "\377\371\370\367\370\370\364\367\367\366\366\367\367\363\364\365\363\364"
  "\365\363\364\365\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\363\364\365\362\363"
  "\364\365\366\367\366\367\367\366\367\367\365\366\367\365\366\367\363\364"
  "\365\365\366\367\365\366\367\364\365\366\364\365\366\365\366\366\365\366"
  "\367\366\367\370\365\366\367\362\363\364\363\364\365\365\366\367\365\366"
  "\365\365\367\370\366\367\370\366\367\370\366\366\367\363\364\365\362\363"
  "\364\362\363\364\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\365\366\367\364\365\366\362\363"
  "\364\364\365\366\365\366\366\366\366\366\365\366\366\364\365\366\362\363"
  "\364\361\362\363\361\362\363\362\363\364\362\363\364\362\363\364\362\363"
  "\364\362\363\364\362\363\364\361\362\363\361\362\363\360\361\362\360\361"
  "\362\360\361\362\360\361\362\361\362\363\361\362\363\361\362\363\362\363"
  "\364\364\365\366\362\363\363\361\362\363\361\362\363\361\362\363\361\362"
  "\363\361\362\363\362\363\364\362\363\363\361\362\363\364\365\366\377\377"
  "\377\256\266\277\257\267\277\377\377\377\374\374\372\370\370\371\376\375"
  "\372\362\362\364\371\373\374\372\373\374\371\371\372\366\367\370\373\373"
  "\374\365\366\367\370\371\372\371\372\373\370\371\372\371\372\373\372\373"
  "\373\372\372\373\371\372\373\372\373\373\372\373\374\371\372\373\371\372"
  "\373\366\366\367\371\373\374\371\372\373\371\372\372\365\366\366\370\370"
  "\371\365\366\370\366\367\371\365\364\365\361\363\364\366\370\371\372\372"
  "\373\372\373\373\364\366\367\370\371\373\372\373\373\372\372\373\371\372"
  "\375\371\372\373\370\372\373\370\371\372\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\371\371\370\373\372\370\370\371"
  "\371\373\372\370\362\364\364\366\367\371\372\373\373\372\372\373\365\366"
  "\367\370\371\373\372\373\373\371\372\373\371\372\375\371\372\373\370\370"
  "\373\370\371\372\366\367\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367"
  "\370\366\367\370\367\370\371\377\377\377\256\266\277\260\267\300\377\377"
  "\377\307\327\361\207\257\351\336\344\356\306\305\305\320\320\322\316\320"
  "\323\312\314\317\306\310\314\337\343\347\316\315\317\317\322\327\346\346"
  "\347\316\317\323\313\314\320\312\315\317\312\314\320\306\310\313\345\347"
  "\352\324\323\326\314\315\317\317\320\324\312\312\317\340\343\343\306\311"
  "\315\311\312\315\335\337\343\367\370\372\364\365\367\372\373\375\342\341"
  "\343\275\277\304\312\316\322\335\341\343\342\341\340\311\314\316\315\320"
  "\324\312\315\317\314\317\322\324\325\327\314\315\320\315\317\323\363\366"
  "\366\366\367\370\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\366\367"
  "\367\372\372\371\276\320\356\213\262\352\330\332\342\302\303\304\313\315"
  "\323\333\337\342\342\343\343\311\314\316\315\316\322\314\315\317\314\317"
  "\323\324\325\327\314\315\321\313\316\321\362\364\367\366\367\370\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\367\370\370\377\377"
  "\377\256\266\277\260\270\300\377\377\377\245\277\354+\215\344\314\327\353"
  "\340\340\335\313\311\313\306\310\314\312\316\320\313\315\317\343\345\351"
  "\336\333\333\323\324\331\351\354\354\334\335\335\311\314\316\322\324\330"
  "\335\337\340\314\314\317\347\350\352\320\321\323\322\323\327\326\326\332"
  "\322\325\327\345\346\345\311\314\316\320\321\325\344\346\352\367\367\371"
  "\367\367\373\376\377\377\355\356\360\332\333\333\322\324\330\337\341\346"
  "\342\343\342\331\333\336\331\330\334\310\313\317\330\333\337\316\315\316"
  "\276\300\306\320\322\326\364\366\371\367\370\370\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\367\367\367\371\371\367\226\266\351:\220\344\324"
  "\335\353\341\337\336\323\325\330\335\340\344\344\343\343\330\333\335\332"
  "\331\334\312\313\315\326\331\337\320\317\320\275\276\304\316\321\325\364"
  "\365\367\367\370\371\366\367\370\366\367\370\366\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\367\370\370\377\377\377\256\266\277\257\267\277\377\377\377\360"
  "\363\367\337\346\364\373\373\374\374\374\373\373\373\374\373\375\376\375"
  "\375\376\370\370\371\373\375\376\374\375\375\373\374\375\376\377\377\375"
  "\376\377\375\376\377\377\377\377\377\377\377\374\375\377\374\376\376\372"
  "\373\373\372\373\373\371\372\373\371\372\373\373\373\374\371\372\373\371"
  "\372\373\367\370\370\371\371\370\371\372\370\371\372\372\374\372\370\364"
  "\365\366\373\374\376\374\374\375\373\374\375\376\377\377\377\377\377\376"
  "\377\377\377\377\377\370\371\371\370\371\373\375\377\377\375\375\376\372"
  "\373\373\367\370\371\366\367\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\366\367\367\372"
  "\372\370\355\360\366\337\347\364\373\374\373\371\371\371\374\376\377\376"
  "\377\377\376\376\377\374\377\377\376\377\377\375\376\376\376\376\377\371"
  "\371\372\366\367\371\376\376\377\375\376\376\372\373\373\370\372\373\373"
  "\374\375\373\373\374\372\373\374\372\373\374\372\373\374\372\373\374\371"
  "\372\373\367\370\371\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\367\370\370\377\377\377\256"
  "\266\277\256\266\277\377\377\377\370\370\371\371\373\373\365\365\365\311"
  "\312\314\335\335\340\335\340\340\332\333\334\322\326\332\352\354\356\326"
  "\325\331\335\337\342\352\355\356\333\334\336\334\335\337\332\333\335\330"
  "\331\333\330\330\332\351\354\357\370\371\372\366\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\367\370\370\373\372\371\316"
  "\332\360\255\305\354\352\355\357\313\313\314\332\335\341\350\352\353\332"
  "\333\335\336\337\341\330\332\334\332\332\334\333\335\337\336\341\343\342"
  "\343\345\333\335\337\333\334\336\327\332\334\360\362\365\367\367\370\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\367\367\367\367\367\367\372\373\373\356"
  "\355\354\313\316\320\330\332\335\337\341\343\332\333\337\337\342\344\332"
  "\333\335\350\351\354\326\325\327\343\345\350\357\362\362\341\342\344\331"
  "\332\336\330\327\331\321\324\324\332\334\337\331\332\336\334\335\337\340"
  "\340\343\334\336\337\331\332\334\326\331\335\363\365\366\366\367\370\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\367\370\370\377\377\377\256\266\277\256\266\277\377\377\377\367"
  "\370\372\377\377\377\355\356\357\317\320\321\301\301\302\272\276\301\304"
  "\310\312\300\304\307\336\340\346\325\322\324\316\320\323\344\346\347\323"
  "\322\324\302\303\307\306\311\315\321\324\326\272\275\303\340\344\350\370"
  "\371\371\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\367\367\367\366\370\367\203\254\347\040\212\344\335\344\361\335\333"
  "\332\321\323\325\343\345\346\313\314\316\312\313\317\276\277\301\274\276"
  "\305\313\317\321\317\320\324\314\313\315\275\300\304\303\303\305\302\306"
  "\312\355\357\362\367\370\370\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\363\364"
  "\367\366\370\372\377\377\377\356\355\357\316\316\317\276\277\301\305\311"
  "\315\276\276\302\316\317\323\302\305\311\342\344\347\316\315\317\322\324"
  "\327\337\342\340\303\304\312\323\322\326\307\312\314\302\302\304\305\312"
  "\320\316\315\317\302\307\313\313\316\320\313\315\320\314\317\321\306\310"
  "\317\360\362\365\366\367\370\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\367\370\370\377\377\377\256\266"
  "\277\256\266\277\377\377\377\365\366\370\365\366\370\367\370\372\373\372"
  "\373\365\366\367\366\367\367\370\372\372\365\365\365\371\372\374\372\373"
  "\374\371\372\373\374\375\376\374\375\375\372\373\373\371\372\374\372\373"
  "\373\365\366\370\367\370\371\366\367\370\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\366\367\367\374\373\370\337\347"
  "\363\315\331\361\370\372\372\370\371\370\370\371\373\374\375\376\372\373"
  "\373\374\375\377\375\376\376\375\375\376\374\375\377\373\374\375\372\373"
  "\373\373\374\374\373\373\376\372\373\373\371\373\374\367\370\370\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\364\364\367\365\366\370\367\370"
  "\371\367\370\371\363\364\366\374\375\375\372\373\373\373\375\376\373\374"
  "\374\376\377\377\372\373\373\372\373\375\374\374\375\371\372\372\375\376"
  "\376\372\373\373\372\373\375\373\374\375\373\374\375\372\373\375\374\374"
  "\375\373\374\375\374\375\376\370\371\371\371\372\372\366\367\370\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\367\370\370\377\377\377\256\266\277\256\266\277\377\377\377\365\366"
  "\370\365\366\370\364\365\366\323\323\325\347\352\354\351\352\354\345\350"
  "\350\340\342\344\360\363\364\340\337\341\347\352\354\363\364\365\346\347"
  "\350\345\346\350\345\347\351\370\372\373\367\370\371\366\367\370\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\367\370\367\370\370\370\373\372\371\362\360\357\315\316"
  "\317\344\345\351\364\365\366\357\356\360\346\347\351\350\350\352\351\354"
  "\354\350\351\353\347\350\352\353\354\356\350\351\353\350\351\353\350\351"
  "\351\354\355\357\370\371\371\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\364\365\367\365\366\370\354\356\360\345\346\347\336\340\342\352\352"
  "\355\337\340\340\344\347\351\350\351\353\346\346\351\353\354\356\351\353"
  "\354\351\352\354\345\346\350\356\360\361\341\340\342\350\351\353\364\365"
  "\366\347\350\351\351\351\354\352\353\353\351\352\355\352\353\353\347\351"
  "\353\367\370\371\366\367\370\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\367\370\370\377\377\377\256\266"
  "\277\256\266\277\377\377\377\367\370\372\377\377\377\355\355\355\303\302"
  "\305\275\276\300\266\270\275\276\302\306\271\273\301\332\336\342\315\312"
  "\316\310\313\317\336\336\337\272\273\277\272\274\302\330\332\340\367\370"
  "\372\366\367\370\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\364\364\367\370\370"
  "\372\376\377\377\362\363\365\320\317\321\311\314\321\340\343\344\306\305"
  "\307\270\273\277\266\270\272\273\275\303\273\277\303\307\312\316\313\316"
  "\320\272\273\277\273\274\300\264\266\273\324\330\334\367\370\372\366\367"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\363\364\367\365\370\372\376\377\377\351\350"
  "\352\317\320\322\301\302\310\307\310\314\274\275\277\272\274\301\303\306"
  "\312\276\277\303\304\310\315\304\306\310\302\310\312\276\275\301\325\330"
  "\336\317\314\316\306\311\315\340\341\341\265\266\270\274\301\305\270\272"
  "\276\277\277\303\304\305\311\303\306\314\363\365\366\366\367\370\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\367\370\370\377\377\377\256\266\277\256\266\277\377\377\377\365\366"
  "\370\365\366\372\364\365\367\365\366\367\351\352\353\351\353\354\356\357"
  "\361\353\354\354\362\365\367\365\366\366\361\362\364\370\371\372\360\361"
  "\363\362\363\365\364\365\365\370\371\371\366\367\370\366\367\370\366\367"
  "\370\366\367\370\366\367\370\365\366\367\365\366\367\365\366\367\365\366"
  "\367\366\367\367\366\367\367\364\365\367\364\365\371\366\367\370\364\365"
  "\366\362\363\363\370\371\371\355\354\355\350\351\354\351\352\352\361\364"
  "\366\364\364\366\366\367\367\363\363\364\362\363\363\362\363\364\361\363"
  "\364\364\365\370\370\371\371\366\367\370\366\367\370\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\366\367\367\366\367"
  "\367\364\365\367\365\366\372\365\367\367\360\361\361\364\366\367\364\365"
  "\366\361\362\365\361\364\365\366\367\370\363\364\364\363\364\364\363\364"
  "\364\365\365\366\364\365\365\365\370\370\365\366\366\361\362\364\371\372"
  "\372\354\355\356\352\355\357\363\364\364\362\363\365\362\363\364\361\362"
  "\364\370\371\372\366\367\370\366\367\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\366\367\370\367\370\371\377\377\377\256\266"
  "\277\256\266\277\377\377\377\364\365\365\363\364\364\363\364\365\365\366"
  "\366\366\367\370\367\370\371\370\371\372\370\371\372\371\372\373\370\371"
  "\372\370\371\371\370\371\371\370\371\371\367\370\371\366\367\370\365\366"
  "\367\365\366\367\366\367\367\365\366\367\364\365\366\363\364\365\362\363"
  "\364\362\363\364\362\363\364\362\363\364\362\363\364\362\363\364\362\363"
  "\364\362\363\364\363\364\365\364\365\366\364\365\366\364\365\366\365\366"
  "\367\367\370\371\371\372\372\371\372\372\370\371\372\370\371\371\370\371"
  "\371\370\371\372\370\371\372\370\371\372\367\370\371\366\367\367\364\365"
  "\366\363\364\365\362\363\364\362\363\364\362\363\364\362\363\364\362\363"
  "\364\362\363\364\362\363\364\362\363\364\362\363\364\363\364\364\363\364"
  "\365\364\365\366\365\365\366\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\367\370\371\367\370\371\371\372\372\370\371\372\370\371"
  "\371\370\371\372\370\371\371\367\370\371\370\371\372\371\372\373\371\372"
  "\372\370\371\371\366\367\370\364\365\366\363\364\365\362\363\364\362\363"
  "\364\362\363\364\362\363\364\362\363\364\362\363\364\362\363\364\362\363"
  "\364\364\365\365\377\377\377\256\266\277\256\266\277\377\377\377\365\366"
  "\367\364\365\366\364\365\366\364\365\366\365\366\367\366\367\370\360\357"
  "\356\323\324\327\347\351\353\361\361\362\354\355\355\352\353\355\357\360"
  "\362\360\361\363\355\356\361\362\363\364\350\350\352\357\360\360\352\352"
  "\355\353\356\360\366\367\370\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\365\366\367\366\367\370\344\345\346\353\354"
  "\356\357\360\362\361\362\362\357\357\361\350\351\353\354\353\356\352\353"
  "\355\357\360\362\347\350\352\355\357\362\366\367\367\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\366\367\370\355\356\357\327\330"
  "\333\352\353\356\353\355\356\353\355\357\353\354\356\352\353\355\363\364"
  "\365\351\352\352\356\357\361\355\356\360\346\347\351\364\365\366\365\366"
  "\367\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\365\366\367\377\377\377\256\266"
  "\277\256\266\277\377\377\377\367\370\370\365\366\367\365\366\367\365\366"
  "\367\366\367\367\367\371\372\353\350\351\276\301\302\265\266\272\266\272"
  "\276\277\304\306\303\305\311\265\266\274\311\314\315\272\275\301\335\340"
  "\342\277\274\274\262\265\271\276\300\306\340\343\346\370\371\371\366\367"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\366\367"
  "\370\370\367\370\311\310\311\303\306\312\271\274\276\267\270\274\276\305"
  "\310\320\322\330\332\331\332\264\263\271\271\276\301\303\304\311\344\346"
  "\352\370\371\372\366\367\370\366\366\367\366\367\367\366\367\367\366\367"
  "\367\366\367\367\366\367\367\366\367\367\366\367\367\366\367\367\366\367"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\366\367"
  "\370\370\371\372\352\352\352\315\320\320\305\304\306\270\275\277\275\275"
  "\301\271\274\301\263\263\267\327\333\341\306\305\310\265\266\272\270\273"
  "\300\316\317\325\362\364\366\367\370\370\366\367\367\365\366\367\365\366"
  "\367\366\366\367\366\367\367\366\367\367\366\367\367\366\367\367\366\367"
  "\367\367\370\371\377\377\377\256\266\277\256\266\277\377\377\377\364\365"
  "\370\362\363\366\362\363\366\362\363\366\362\363\366\363\364\367\361\362"
  "\365\355\360\360\347\350\352\336\337\341\343\345\351\356\357\357\351\352"
  "\354\356\357\357\352\353\355\365\366\370\346\347\351\344\346\351\346\347"
  "\353\355\357\362\364\365\367\362\363\366\362\363\366\362\363\366\362\363"
  "\366\363\364\366\363\364\366\363\364\366\362\363\366\362\363\366\362\363"
  "\366\362\363\366\362\363\366\363\364\366\363\364\367\351\354\354\353\354"
  "\360\350\351\352\347\350\353\352\354\360\357\361\363\357\361\363\344\345"
  "\347\345\347\351\347\351\353\356\356\361\365\366\367\364\365\367\364\364"
  "\367\362\364\365\362\363\365\362\363\365\362\363\365\362\365\365\364\365"
  "\365\364\365\367\364\365\370\364\365\367\363\364\366\362\363\366\362\363"
  "\366\363\364\366\363\364\367\364\365\367\365\366\370\361\362\362\343\345"
  "\347\351\352\356\350\353\355\351\351\355\351\353\355\346\347\350\360\362"
  "\366\355\356\356\345\347\351\346\351\353\350\351\354\360\363\365\364\365"
  "\367\363\364\367\363\364\367\363\364\367\364\364\367\362\364\365\362\363"
  "\365\362\363\365\362\363\365\362\365\365\365\366\370\377\377\377\256\266"
  "\277\256\266\277\375\376\377\372\373\374\375\374\375\372\374\375\372\373"
  "\374\372\373\375\372\374\375\375\375\376\376\376\377\377\377\377\377\377"
  "\377\370\371\374\371\372\372\370\371\371\356\357\361\360\361\363\367\370"
  "\374\376\377\377\377\377\377\377\376\377\376\375\376\373\374\375\372\374"
  "\375\372\373\374\372\374\375\375\374\375\371\372\374\356\361\365\371\372"
  "\374\375\374\375\372\373\375\372\373\374\372\373\374\372\373\374\372\374"
  "\375\373\374\375\377\376\377\375\375\377\363\366\371\377\377\377\360\357"
  "\361\367\370\372\377\377\377\377\377\377\377\377\377\372\373\375\366\371"
  "\371\370\371\373\367\370\373\367\370\372\363\366\370\371\372\375\371\372"
  "\374\372\373\375\367\367\372\356\361\365\372\373\376\355\354\356\363\366"
  "\370\376\375\376\372\374\375\373\374\375\367\370\372\364\367\370\367\370"
  "\372\370\371\373\370\371\374\366\370\373\375\376\377\374\375\377\376\377"
  "\377\373\374\376\363\365\370\377\376\377\360\357\362\370\371\373\377\377"
  "\377\377\376\377\374\375\376\367\370\372\364\367\370\367\370\372\367\370"
  "\372\367\370\372\363\366\370\371\372\375\371\372\374\372\373\375\367\367"
  "\373\363\364\366\377\377\377\256\266\277\256\266\277\374\376\377\376\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\357\356\361\277\276\300\277\304"
  "\312\271\270\275\302\305\312\354\356\362\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\376\376\376\355\360\364\376\377\376\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\361\362\366\376\376\374\324\323\324\347\352\355\377\377\377\377\377"
  "\377\377\377\377\373\374\375\370\371\373\360\361\362\355\357\360\371\371"
  "\372\370\371\373\375\375\375\326\330\330\355\354\356\375\375\376\360\361"
  "\365\376\375\374\324\323\324\347\352\355\377\377\377\377\377\377\377\377"
  "\377\373\374\375\370\371\373\360\361\362\355\357\360\371\372\372\370\371"
  "\374\376\375\376\327\330\331\355\355\357\375\375\377\360\361\365\376\376"
  "\374\324\323\324\347\352\355\377\377\377\377\377\377\377\377\377\373\374"
  "\375\370\371\373\360\361\363\355\356\360\371\371\372\370\371\373\375\375"
  "\375\326\330\330\355\354\356\375\375\377\363\364\366\377\377\377\256\266"
  "\277\256\266\277\374\376\377\376\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\363\364\367\334\335\337\341\344\346\343\344\346\345\346\352\357\362"
  "\364\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\376\376\377\355\360\364\376\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\376\377\377\356\361\365\377\377\377\356\356"
  "\355\370\371\372\377\377\377\377\377\377\377\377\377\373\374\375\370\371"
  "\373\360\361\363\356\357\360\371\372\372\370\371\373\375\375\375\330\330"
  "\332\355\356\357\375\375\376\357\361\364\377\377\377\356\356\355\370\371"
  "\372\377\377\377\377\377\377\377\377\377\373\374\375\370\371\373\360\361"
  "\363\356\357\360\371\372\372\370\371\373\376\375\375\330\330\332\355\356"
  "\357\375\375\377\357\361\364\377\377\377\356\356\355\370\371\372\377\377"
  "\377\377\377\377\377\377\377\373\374\375\370\371\373\360\361\363\356\357"
  "\360\371\372\372\370\371\373\375\375\375\330\330\332\355\356\357\375\375"
  "\377\363\364\366\377\377\377\256\266\277\256\266\277\375\376\376\371\372"
  "\374\374\375\376\373\374\375\373\374\375\373\374\375\373\374\375\373\374"
  "\375\373\374\375\373\374\375\373\374\375\365\366\370\371\372\373\372\373"
  "\374\372\373\373\371\372\372\363\366\370\371\372\375\373\375\375\373\374"
  "\375\373\374\375\373\374\375\373\374\375\373\374\375\373\374\375\373\375"
  "\376\371\372\375\357\360\364\371\372\375\373\375\376\373\374\375\373\374"
  "\375\373\374\375\373\374\375\373\375\376\374\375\376\374\375\376\372\373"
  "\375\360\361\365\373\374\376\376\377\377\375\376\377\374\375\376\374\375"
  "\376\374\375\376\370\371\373\366\370\371\370\371\373\370\371\373\367\370"
  "\371\363\364\371\372\373\375\371\372\374\373\372\374\366\367\373\357\361"
  "\365\373\374\376\376\377\377\375\376\377\374\375\376\373\374\376\374\375"
  "\376\370\371\373\365\370\371\370\371\373\370\371\373\370\371\371\364\365"
  "\371\372\373\375\371\373\375\373\372\374\366\367\373\356\361\365\373\374"
  "\376\376\377\377\375\376\377\374\375\376\373\374\375\374\375\376\367\370"
  "\373\365\370\370\370\371\373\370\371\373\367\370\371\363\364\371\372\373"
  "\375\371\372\374\373\372\374\366\367\373\364\365\367\377\377\377\256\266"
  "\277\256\266\277\377\377\377\360\362\363\356\357\361\356\357\361\356\357"
  "\361\356\357\361\356\357\361\356\357\361\356\357\361\356\357\361\356\357"
  "\362\361\362\362\363\364\365\363\364\365\363\364\365\363\364\365\361\362"
  "\362\356\357\362\356\357\361\356\357\361\356\357\361\356\357\361\356\357"
  "\361\356\357\361\356\357\361\356\357\361\356\357\362\357\362\362\357\357"
  "\362\356\357\361\356\357\361\356\357\361\356\357\362\357\362\363\357\360"
  "\363\361\362\364\362\365\366\362\365\366\365\365\366\362\365\366\362\365"
  "\366\363\363\366\363\364\366\362\365\365\362\363\365\362\363\366\365\366"
  "\366\363\365\366\361\364\365\362\363\363\357\360\362\357\360\362\357\360"
  "\362\357\360\362\360\360\362\361\363\363\362\364\363\365\365\363\362\364"
  "\364\361\362\364\361\361\364\360\363\364\361\362\364\362\364\365\364\364"
  "\365\363\364\365\363\364\365\362\363\365\362\363\365\362\363\365\362\363"
  "\365\361\362\364\360\363\363\357\360\362\356\357\362\356\357\362\356\357"
  "\361\356\357\361\356\357\361\356\357\362\357\361\362\357\362\362\357\362"
  "\362\357\362\362\357\360\362\357\360\362\357\360\362\357\360\362\357\360"
  "\362\362\363\365\377\377\377\256\266\277\256\266\277\377\377\377\366\366"
  "\367\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\365\366\367\366\367\370\337\336\337\325\330\333\351\352\354\351\351"
  "\352\350\351\353\351\351\354\351\352\352\342\345\347\333\332\336\345\347"
  "\352\357\360\360\341\342\344\350\350\352\342\343\345\347\351\354\367\370"
  "\370\365\366\366\364\365\366\364\365\366\364\365\366\365\366\366\372\372"
  "\367\353\356\365\344\352\365\360\360\361\351\351\350\360\362\364\366\367"
  "\367\362\362\365\355\356\356\360\361\363\365\366\366\364\365\367\357\360"
  "\360\344\346\347\357\362\364\365\365\366\363\364\366\367\370\370\365\366"
  "\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365"
  "\366\364\365\366\364\365\366\364\365\366\366\367\367\377\377\377\256\266"
  "\277\256\266\277\377\377\377\367\370\371\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\366\367\370\366\365\366\324\325"
  "\332\316\315\317\300\303\305\272\275\301\306\313\315\304\303\305\267\271"
  "\273\311\316\322\277\276\301\273\276\302\341\342\344\273\270\272\267\274"
  "\277\302\303\310\335\340\343\367\370\370\366\367\370\366\367\367\366\367"
  "\367\366\367\367\370\370\370\370\371\370\220\263\350Z\234\350\304\315\340"
  "\301\277\273\303\311\315\310\311\314\305\307\311\266\270\274\276\301\305"
  "\274\277\303\310\314\320\337\336\340\272\273\275\274\275\300\273\276\302"
  "\313\320\324\366\367\371\366\367\370\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\367\370\371\377\377\377\256\266\277\256\266\277\377\377\377\367\370\370"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\363\364\367\362\364\366\362\363\366\362\363\365\362\363\365"
  "\362\363\366\364\365\370\354\356\360\354\356\361\357\362\364\356\357\363"
  "\361\363\365\363\364\366\356\361\365\363\366\367\360\361\363\353\355\360"
  "\363\366\370\354\355\357\355\356\362\356\360\362\356\360\363\364\366\367"
  "\362\363\365\362\363\365\362\363\365\362\363\365\364\364\366\367\367\367"
  "\241\274\352l\243\346\323\334\356\357\355\352\341\343\345\340\341\343\352"
  "\354\355\344\346\346\342\343\345\341\343\344\352\354\356\364\363\365\347"
  "\350\351\344\344\346\343\344\345\342\345\351\367\370\370\366\367\370\366"
  "\367\367\366\367\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\367\367\367\370\370\377\377\377\256\266\277\256"
  "\266\277\377\377\377\367\370\370\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\362\364\366\374\373\376\376"
  "\375\376\375\375\376\375\375\376\375\375\376\376\375\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\362\364\370\376\377\377\354\351\353\365"
  "\366\371\377\377\377\377\377\377\377\377\377\373\374\376\371\374\374\373"
  "\374\375\373\373\374\367\372\373\365\366\372\373\374\376\371\372\373\374"
  "\374\376\372\371\373\365\365\366\362\364\370\355\357\366\367\372\373\372"
  "\372\373\367\371\373\367\370\373\370\371\373\365\370\372\370\371\373\370"
  "\370\373\367\370\372\366\367\371\363\366\370\366\367\373\367\370\373\365"
  "\366\372\363\364\366\360\363\365\365\366\372\362\363\367\364\365\371\364"
  "\365\367\363\364\367\363\364\367\361\363\366\363\364\366\363\364\367\364"
  "\364\367\362\364\367\360\362\365\362\363\367\362\363\367\362\363\367\363"
  "\364\366\377\377\377\256\266\277\256\266\277\377\377\377\367\370\370\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\362\363\366\376\377\376\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\376\377\377\357"
  "\361\366\376\375\374\323\323\326\347\352\355\377\377\377\377\377\377\377"
  "\377\377\373\374\375\370\371\371\355\357\360\351\352\354\371\371\372\370"
  "\371\373\374\373\374\315\316\320\347\351\351\375\375\377\361\362\365\377"
  "\377\377\340\336\335\361\362\363\377\377\377\377\377\377\377\377\377\377"
  "\377\377\371\372\374\371\372\374\370\373\373\370\373\373\371\372\374\371"
  "\372\374\377\377\377\365\365\366\375\374\376\371\373\374\360\363\367\376"
  "\374\374\332\331\334\364\365\370\377\377\377\377\377\377\377\377\377\370"
  "\371\374\370\371\373\370\372\373\370\372\373\371\371\374\370\371\373\377"
  "\377\377\364\364\366\375\374\376\373\374\376\375\375\376\256\266\277\256"
  "\266\277\377\377\377\367\370\370\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\362\363\366\376\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\356\361\365\377\377\377\365\365\364\373"
  "\374\375\377\377\377\377\377\377\377\377\377\373\374\375\370\371\373\364"
  "\365\365\362\363\364\371\371\372\370\371\373\375\375\377\342\343\344\362"
  "\363\364\375\374\376\360\361\365\376\375\374\327\327\331\352\355\360\377"
  "\377\377\377\377\377\377\377\377\377\377\377\371\372\373\370\371\372\345"
  "\346\351\345\346\351\371\372\372\370\371\373\367\367\371\270\272\274\353"
  "\353\355\373\373\374\357\362\366\375\373\372\326\326\327\357\362\365\377"
  "\377\377\377\377\377\377\377\377\371\372\373\370\371\371\345\346\351\345"
  "\346\351\371\371\372\370\371\373\367\367\371\270\272\274\353\353\355\375"
  "\374\376\375\375\376\256\266\277\256\266\277\377\377\377\367\370\370\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\361\364\366\367\370\373\371\371\373\371\371\373\371\371\373\371"
  "\371\373\371\371\373\371\371\373\371\371\373\371\371\373\367\370\373\357"
  "\360\364\370\371\373\373\373\375\372\372\374\371\371\373\371\371\373\370"
  "\371\374\365\366\371\365\366\370\365\370\371\366\370\371\365\366\370\361"
  "\364\366\367\367\372\366\370\373\370\371\373\364\365\371\360\361\365\377"
  "\377\377\376\376\374\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\372\373\374\370\371\373\370\371\371\370\371\371\371\372\374\370"
  "\371\374\376\377\377\361\361\361\375\374\375\371\372\374\360\362\366\377"
  "\377\377\374\374\374\377\377\377\377\377\377\377\377\377\377\377\377\372"
  "\373\374\370\371\373\370\371\371\370\371\371\371\372\374\370\371\374\377"
  "\377\377\361\361\361\375\374\375\373\374\376\375\375\377\257\266\277\256"
  "\266\277\377\377\377\367\370\371\366\367\370\366\367\367\366\367\367\366"
  "\366\367\366\366\367\366\366\367\366\366\367\366\366\367\366\366\367\366"
  "\366\367\366\366\367\366\366\367\366\366\367\366\366\367\366\367\367\366"
  "\367\367\366\367\367\366\366\367\366\366\367\366\366\367\366\366\367\365"
  "\366\367\365\366\367\365\366\367\366\367\367\366\366\367\363\364\367\363"
  "\364\366\363\364\366\363\364\366\363\364\366\363\364\366\363\364\366\363"
  "\364\366\363\364\366\363\365\367\364\365\367\364\365\367\363\364\367\363"
  "\364\366\363\364\366\363\364\366\363\364\366\363\364\367\364\365\367\364"
  "\365\367\364\365\367\364\365\367\364\365\367\364\365\367\364\365\367\364"
  "\365\367\364\365\367\362\365\365\363\364\370\365\366\372\364\365\371\364"
  "\365\367\363\364\367\363\364\367\364\365\367\361\364\366\362\364\367\364"
  "\365\367\364\365\367\362\365\367\360\363\365\363\364\367\363\364\370\363"
  "\364\370\361\363\365\361\363\365\364\366\370\365\366\372\364\365\370\363"
  "\365\367\363\365\367\364\365\367\361\364\366\362\364\367\364\365\367\364"
  "\365\367\362\365\367\360\363\365\363\364\367\363\364\370\363\364\370\362"
  "\365\367\376\377\377\257\266\277\256\266\277\377\377\377\364\365\366\363"
  "\364\365\363\364\365\363\364\365\363\364\364\363\364\364\363\364\364\363"
  "\364\364\363\364\364\363\364\364\363\363\364\363\363\364\363\363\364\363"
  "\363\364\363\364\364\363\364\365\363\364\365\363\364\364\363\364\364\363"
  "\364\364\363\363\364\363\363\364\362\363\364\362\363\364\363\363\364\363"
  "\364\364\363\364\364\363\364\364\363\364\364\362\364\364\362\363\364\362"
  "\364\364\363\364\364\363\364\364\362\363\364\362\363\364\363\364\364\363"
  "\364\364\363\364\364\362\363\364\362\363\364\362\363\364\362\363\364\362"
  "\363\364\362\363\364\362\363\364\362\363\364\362\363\364\362\363\364\362"
  "\363\364\362\363\364\362\363\364\362\363\364\363\363\364\363\364\364\361"
  "\362\364\361\362\364\360\361\364\360\361\364\360\361\364\360\361\364\361"
  "\361\364\361\362\364\363\363\364\362\363\364\362\363\364\363\364\364\361"
  "\362\364\361\362\364\361\362\364\361\362\364\361\362\364\363\364\364\361"
  "\362\364\361\362\364\360\361\364\360\361\364\360\361\364\361\361\364\361"
  "\362\364\363\363\364\362\363\364\362\363\364\363\364\364\361\362\364\361"
  "\362\364\361\362\364\361\362\364\364\365\365\377\377\377\256\266\277\256"
  "\266\300\377\377\377\364\365\366\364\365\365\365\366\366\365\366\370\363"
  "\365\366\362\365\366\362\365\366\362\365\366\362\365\366\362\365\365\361"
  "\364\365\361\364\364\363\364\364\363\364\364\361\364\365\364\365\366\365"
  "\366\370\364\365\366\362\365\365\362\365\365\362\364\365\361\364\364\363"
  "\364\364\366\366\366\367\367\367\370\370\367\367\370\370\367\370\370\366"
  "\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366\367\370\366"
  "\367\370\365\366\367\365\366\367\366\367\370\366\367\370\366\367\370\366"
  "\367\370\366\367\370\366\367\367\365\366\367\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364"
  "\365\366\364\365\366\364\365\366\364\365\366\364\365\366\364\365\366\366"
  "\366\367\377\377\377\256\266\277\256\266\277\375\376\377\370\371\373\365"
  "\367\371\345\346\352\364\364\370\372\372\375\371\372\374\371\372\374\371"
  "\372\374\371\370\374\370\371\373\371\371\374\370\371\373\357\361\365\365"
  "\365\371\370\371\371\352\352\356\354\357\363\367\370\372\372\372\375\372"
  "\371\375\370\371\373\371\372\374\366\366\370\370\371\367\360\363\367\364"
  "\366\371\361\357\356\355\355\357\367\371\372\361\361\362\367\370\371\370"
  "\370\372\357\360\360\362\365\366\370\371\371\370\371\372\367\370\370\370"
  "\371\371\370\371\371\370\371\372\370\371\372\367\367\370\370\371\371\366"
  "\370\371\370\371\371\366\367\370\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365"
  "\366\367\365\366\367\365\366\367\367\370\371\377\377\377\256\266\277\256"
  "\266\277\375\375\377\375\374\376\364\361\361\301\303\303\302\303\305\311"
  "\314\320\324\323\325\314\315\317\312\314\316\314\315\321\301\302\306\346"
  "\351\355\376\377\377\356\361\365\371\372\375\366\366\364\333\333\335\330"
  "\331\333\315\316\322\322\321\323\311\312\316\320\321\325\374\375\375\373"
  "\373\373\343\350\363l\240\345\223\265\352\316\315\317\322\324\327\317\321"
  "\323\303\306\316\340\341\343\311\312\314\275\274\304\300\300\304\300\303"
  "\311\337\341\345\316\321\323\302\305\307\305\310\316\316\314\316\300\305"
  "\311\306\311\313\301\303\307\310\312\320\365\365\370\366\367\370\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366"
  "\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\367\370"
  "\370\377\377\377\256\266\277\257\267\277\375\375\376\374\374\376\373\371"
  "\372\354\354\354\337\340\340\341\344\346\352\351\353\331\331\333\341\342"
  "\344\352\351\353\333\334\334\356\361\363\377\376\376\356\361\364\371\372"
  "\374\374\372\373\344\344\344\347\347\351\343\343\343\341\342\342\333\334"
  "\336\336\337\343\377\376\377\373\373\373\340\347\362i\241\347\177\252\352"
  "\337\337\341\337\341\342\335\336\340\334\337\343\353\352\354\324\325\327"
  "\337\337\344\332\332\334\330\334\336\356\360\362\345\346\346\326\327\333"
  "\340\343\347\335\334\336\322\324\330\343\345\345\332\332\334\330\334\340"
  "\366\367\371\366\367\370\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367\365\366\367"
  "\365\366\367\365\366\367\367\370\370\377\377\377\256\266\277\260\270\301"
  "\377\377\377\370\371\375\374\374\376\376\376\377\376\377\377\376\377\377"
  "\377\377\377\376\377\377\376\377\377\377\377\377\375\376\377\375\375\377"
  "\373\372\375\360\363\366\367\370\372\374\374\376\374\375\376\377\376\377"
  "\376\377\377\376\377\377\376\377\377\375\376\377\375\374\376\367\370\372"
  "\367\367\370\347\354\366\352\356\367\375\374\373\373\373\373\374\374\375"
  "\373\374\375\373\374\375\372\373\373\374\375\375\374\375\375\373\374\375"
  "\373\373\374\373\374\374\372\373\375\374\375\375\374\375\375\373\373\374"
  "\374\375\375\374\374\375\373\373\374\370\371\372\367\370\371\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370"
  "\367\370\370\367\370\370\367\370\370\367\370\370\367\370\370\370\371\372"
  "\377\377\377\260\270\300\272\277\310\377\377\377\377\377\377\375\375\376"
  "\375\375\377\375\376\377\375\376\377\375\376\377\376\376\377\376\376\377"
  "\375\376\377\375\376\377\375\375\376\375\376\376\376\376\377\375\376\377"
  "\375\375\377\375\375\377\375\376\377\375\376\377\376\376\377\376\376\377"
  "\375\376\377\375\375\376\376\376\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377\377"
  "\377\377\377\377\377\377\377\377\377\377\377\377\272\277\310w\206\232\272"
  "\301\310\260\270\301\257\267\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256\266\277\257"
  "\267\277\257\267\277\257\267\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\257\266\277\257\266\277\256\266\277\256\266\277\256\266\277\257"
  "\266\277\257\267\277\257\266\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256\266\277\256"
  "\266\277\256\266\277\256\266\277\256\266\277\256\266\277\260\267\300\272"
  "\301\310w\206\232",
};
/*----------------------------------------------------------------------------*/
/**
 * @brief  Make icon from Icon struct.
 *
 * @param[in]  ic_name  Name of Icon struct
 * @return     Pixbuf with icon
 */
static GdkPixbuf *
make_icon (const Icon *ic_name)
{
    return gdk_pixbuf_new_from_data (
            ic_name->pixel_data,
            GDK_COLORSPACE_RGB,
            TRUE,
            8,
            ic_name->width,
            ic_name->height,
            ic_name->width * ic_name->bytes_per_pixel,
            NULL,
            NULL
            );
}
/*----------------------------------------------------------------------------*/
/**
 * @brief  Get image from stored data.
 */
GdkPixbuf *
get_image (const IconImg i_img)
{
    GdkPixbuf *gp_pbuf = NULL; /* Return pixbuf */

    switch (i_img) {

        case W_ICON_ADD:
            gp_pbuf = make_icon (&icon_add);
            break;

        case W_ICON_ADD_DIR:
            gp_pbuf = make_icon (&icon_add_dir);
            break;

        case W_ICON_REMOVE:
            gp_pbuf = make_icon (&icon_remove);
            break;

        case W_ICON_REVERT:
            gp_pbuf = make_icon (&icon_rev);
            break;

        case W_ICON_SORT:
            gp_pbuf = make_icon (&icon_srt);
            break;

        case W_ICON_SELECT:
            gp_pbuf = make_icon (&icon_select);
            break;

        case W_ICON_SELECT_BW:
            gp_pbuf = make_icon (&icon_select_bw);
            break;

        case W_ICON_SELECT_BL:
            gp_pbuf = make_icon (&icon_select_bl);
            break;

        case W_ICON_DUPL:
            gp_pbuf = make_icon (&icon_dupl);
            break;

        case W_ICON_INFO:
            gp_pbuf = make_icon (&icon_info);
            break;

        case W_ICON_ABOUT:
            gp_pbuf = gdk_pixbuf_new_from_data (
                image_about.pixel_data,
                GDK_COLORSPACE_RGB,
                FALSE,
                8,
                image_about.width,
                image_about.height,
                image_about.width * image_about.bytes_per_pixel,
                NULL,
                NULL
                );
            break;

        case W_ICON_COUNT:
            break;

        default:
            break;
    }
    return gp_pbuf;
}
/*----------------------------------------------------------------------------*/


