<!--
Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
This program is free software: you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation, either version 3 of the License, or    
(at your option) any later version.                                  
                                                                     
This program is distributed in the hope that it will be useful,      
but WITHOUT ANY WARRANTY; without even the implied warranty of       
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
GNU General Public License for more details.                         
                                                                     
You should have received a copy of the GNU General Public License    
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>
  <title>Slipstream</title>
  <link rel="stylesheet" href="/stylesheet" type="text/css">
</head>

<body>
  <?lua return fragments.logo ?>

  <form name="replay" action="/slipstream/sessions/start" method="post">
  </form>

  <form name="restart" action="/slipstream/sessions/restart" method="post">
  </form>

  <table class="navigation">
    <tr><th>Slipstream</th><tr>
    <tr><td>
	<a href="/slipstream/sessions/end">home</a>&nbsp;&middot;&nbsp;<a href="javascript: document.replay.submit()">replay</a>&nbsp;&middot;&nbsp;<a href="javascript: document.restart.submit()">restart</a>&nbsp;&middot;&nbsp;<a href="/slipstream/quit">quit</a>
    </td></tr>
  </table>

  <?lua
  if query.save or query.import then
     if query.save then
        session.recorded = true
	session.description = query.description
	session.comments = query.comments
     else
        session.imported = true
     end

     uri = string.format ("/slipstream/sessions/%d", os.time())

     if query.save then
        sessions.recorded[uri] = session.description
     else
        sessions.imported[uri] = session.description
     end

     sessions.mime[uri] = "text/html"
     sessions.pages[uri] = string.format([[
<?lua
blueprint, layout, session = %s, %s, %s
?>

<head></head>
<body onload="javascript:window.location = '/slipstream/sessions/current';"></body>
]], string.serialize (blueprint),
    string.serialize (layout),
    string.serialize (session))

     html = [[
<table class="notification"><tr><td><ul>
  <li>The session has been ]] ..
      (query.save and "saved" or "imported") .. [[.
  </li>
</ul></td></tr></table>
]]

     return html
  end
  ?>

<?lua
   local html = ""


   if session.description then
      html = html .. [[
  <h3>]] .. session.description ..[[</h3>
]]
   end

   if session.comments then
      html = html .. [[
<p>]] .. session.comments ..[[</p>
]]
   end

   return html
 ?>

<?lua
   local html

   if session.laps and #session.laps > 1 then
      html = [[
  <table class="configuration">
    <tr><th colspan=4>Completed laps</th></tr>
    <tr><th>Lap</th><th>Time</th><th>Avg. Speed</th><th>Top Speed</th></tr>
	 ]]

      for i = 2, #session.laps do
	 local last = session.laps[i - 1]
	 local this = session.laps[i]

	 html = html .. string.format ([[
    <tr><td>%d</td><td>%.2f</td><td>%.1f</td><td>%.1f</td></tr>
				       ]], i - 1, this[1] - last[1],
				           this[2] / units.kilometersperhour(1),
					   this[3] / units.kilometersperhour(1))
      end
      
      html = html .. [[
  </table>
]]
   else
      html = [[
  <p>No laps were completed.</p>
]]
   end

   return html
 ?>

<?lua
   if session.recorded then
      return [[
  <p>This is a locally recorded session.  You can
  either <a href="javascript: document.replay.submit()">replay
  it</a>, <a href="javascript: document.restart.submit()">start a new
  one</a> with the exact same setup
  or <a href="/slipstream/sessions/export">export it</a> to a file
  that you or others can import.</p>
]]
   elseif session.imported then
      return [[
  <p>This is an imported session.  You can
  either <a href="javascript: document.replay.submit()">replay
  it</a> or <a href="javascript: document.restart.submit()">start a new
  one</a> with the exact same setup.</p>
]]
   else
      return [[
  <p> This session has been recorded.  If you want to save it please
  fill out the form below:</p>

  <script type="text/javascript">
    function submit (action)
    {
	var form;
	 
	form = document.forms.save;
        form.action = action;
	form.submit();
    }
  </script>

  <form name="save" method="post">
  <input type="hidden" name="save" value="true" />
  <label for="description">Description:</label>
  <input type="text" name="description" class="description"
		     value="<?lua return string.format('Race session recorded on %s', os.date('%a, %d %b %Y %T'))?>"/><br/>
  <label for="comments" style="vertical-align: top">Comments:</label>
  <textarea name="comments" class="comments"></textarea>
  </form>

  <p>By <a href="javascript:submit('/slipstream/sessions/current');">saving
  it</a> you'll be able to replay it at a later time.  You can
  also <a href="javascript:submit('/slipstream/sessions/export');">export
  it to a file</a> for safe-keeping or to share with others. </p>
]]
   end
?>
  

</body>
