<!--
Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
This program is free software: you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation, either version 3 of the License, or    
(at your option) any later version.                                  
                                                                     
This program is distributed in the hope that it will be useful,      
but WITHOUT ANY WARRANTY; without even the implied warranty of       
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
GNU General Public License for more details.                         
                                                                     
You should have received a copy of the GNU General Public License    
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>
  <title>Tyres</title>
  <link rel="stylesheet" href="/stylesheet" type="text/css">
</head>

<body>
  <?lua return fragments.logo ?>
  <?lua return fragments.motorcyclenavigation ?>

  <?lua return fragments.processconfiguration {model = "motorcycle",
					       prefix = "/motorcycle",
					       redirect = "/motorcycle"}
  ?>

  <p>This is the <?lua return query.wheel ?> tyre section. Use the
  plots to the left and the configuration options to tune the tyre
  characteristics.  You'll probably need to consult the documentation
  for more details.</p>

  <?lua
    require "automotive"

    local wheel
    local F_x0, F_y0, M_z0 = {}, {}, {}
    local F_x, F_y, F_xy, M_z = {}, {}, {}, {}

    -- Make a couple of plots.

    if query.wheel == "rear" then
       wheel = automotive.wheel {
	    resistance = blueprint.rearresistance,
	    radii = blueprint.rearradii,
	    elasticity = blueprint.rearelasticity,
	    load = blueprint.rearload,
	    relaxation = blueprint.rearrelaxation,

	    longitudinal = blueprint.rearlongitudinal,  	    
	    lateral = blueprint.rearlateral,
	    moment = blueprint.rearmoment,

	    scaling = blueprint.rearscaling,
       }
    else
       wheel = automotive.wheel {
	    resistance = blueprint.frontresistance,
	    radii = blueprint.frontradii,
	    elasticity = blueprint.frontelasticity,
	    load = blueprint.frontload,
	    relaxation = blueprint.frontrelaxation,

	    longitudinal = blueprint.frontlongitudinal,  	    
	    lateral = blueprint.frontlateral,
	    moment = blueprint.frontmoment,

	    scaling = blueprint.frontscaling,
       }
    end
    -- F_x0.

    for i = 1, 3 do
       table.insert(F_x0, {})

       for j = 0, 1000 do
	  wheel.state = {0, -1 + j * 0.002, 0, i * 1000}

	  table.insert(F_x0[i], {wheel.state[2], wheel.state[8]})
       end
    end

    network.mime['/motorcycle/purelongitudinal'] = "image/svg+xml"
    network.pages['/motorcycle/purelongitudinal'] =  plotting.cartesian {
       size = {600, 600},
       window = {-1, 1, -4000, 4000},
       background = {1, 1, 1},
       foreground = {0, 0, 0},

       grid = true,
       box = true,
       ticks = true,
       
       labels = {"Longitudinal slip",
		 "Longitudinal force (N)",
		 ""},

       fontscale = 3,
       
       plotting.line {
	  color = plotting.colors[1],
	  style = plotting.styles[1],
	  unpack(F_x0[1])
       },
       
       plotting.line {
	  color = plotting.colors[2],
	  style = plotting.styles[2],
	  unpack(F_x0[2])
       },
       
       plotting.line {
	  color = plotting.colors[3],
	  style = plotting.styles[3],
	  unpack(F_x0[3])
       },
    }

    -- F_y0, M_z0.

    for i = 1, 6 do
       table.insert(F_y0, {})
       table.insert(M_z0, {})

       for j = 0, 1000 do
	  wheel.state = {math.rad((i - 1) * 10), 0, -0.25 + j * 0.005, 1600}

	  table.insert(F_y0[i], {wheel.state[3], wheel.state[9]})
	  table.insert(M_z0[i], {wheel.state[3], wheel.state[10]})
       end
    end

    network.mime['/motorcycle/purelateral'] = "image/svg+xml"
    network.pages['/motorcycle/purelateral'] =  plotting.cartesian {
       size = {600, 600},
       window = {-0.25, 0.25, -2500, 2500},
       background = {1, 1, 1},
       foreground = {0, 0, 0},

       grid = true,
       box = true,
       ticks = true,
       
       labels = {"Sideslip",
		 "Lateral force (N)",
		 "Normal load = 1600N"},

       fontscale = 3,
       
       plotting.line {
	  color = plotting.colors[1],
	  style = plotting.styles[1],
	  unpack(F_y0[1])
       },
       
       plotting.line {
	  color = plotting.colors[2],
	  style = plotting.styles[2],
	  unpack(F_y0[2])
       },
       
       plotting.line {
	  color = plotting.colors[3],
	  style = plotting.styles[3],
	  unpack(F_y0[3])
       },
       
       plotting.line {
	  color = plotting.colors[4],
	  style = plotting.styles[4],
	  unpack(F_y0[4])
       },
       
       plotting.line {
	  color = plotting.colors[5],
	  style = plotting.styles[5],
	  unpack(F_y0[5])
       },
       
       plotting.line {
	  color = plotting.colors[6],
	  style = plotting.styles[6],
	  unpack(F_y0[6])
       },
    }

    network.mime['/motorcycle/puremoment'] = "image/svg+xml"
    network.pages['/motorcycle/puremoment'] =  plotting.cartesian {
       size = {600, 600},
       window = {-0.25, 0.25, -60, 60},
       background = {1, 1, 1},
       foreground = {0, 0, 0},

       grid = true,
       box = true,
       ticks = true,
       
       labels = {"Sideslip",
		 "Aligning moment (Nm)",
		 "Normal load = 1600N"},

       fontscale = 3,
       
       plotting.line {
	  color = plotting.colors[1],
	  style = plotting.styles[1],
	  unpack(M_z0[1])
       },
       
       plotting.line {
	  color = plotting.colors[2],
	  style = plotting.styles[2],
	  unpack(M_z0[2])
       },
       
       plotting.line {
	  color = plotting.colors[3],
	  style = plotting.styles[3],
	  unpack(M_z0[3])
       },
       
       plotting.line {
	  color = plotting.colors[4],
	  style = plotting.styles[4],
	  unpack(M_z0[4])
       },
       
       plotting.line {
	  color = plotting.colors[5],
	  style = plotting.styles[5],
	  unpack(M_z0[5])
       },
       
       plotting.line {
	  color = plotting.colors[6],
	  style = plotting.styles[6],
	  unpack(M_z0[6])
       },
    }

    -- F_x due to beta, F_y due to kappa

    for i = 1, 5 do
       table.insert(F_x, {})
       table.insert(F_y, {})
       table.insert(F_xy, {})
       table.insert(M_z, {})

       for j = 0, 1000 do
	  wheel.state = {0, -1 + j * 0.002,
			 math.tan(math.rad(-9 + (i - 1) * 3)), 1600}

	  table.insert(F_x[i], {wheel.state[2], wheel.state[5]})
	  table.insert(F_y[i], {wheel.state[2], wheel.state[6]})
	  table.insert(F_xy[i], {wheel.state[5], wheel.state[6]})
	  table.insert(M_z[i], {wheel.state[2], wheel.state[7]})
       end
    end

    network.mime['/motorcycle/longitudinal'] = "image/svg+xml"
    network.pages['/motorcycle/longitudinal'] =  plotting.cartesian {
       size = {600, 600},
       window = {-1, 1, -4000, 4000},
       background = {1, 1, 1},
       foreground = {0, 0, 0},

       grid = true,
       box = true,
       ticks = true,
       
       labels = {"Longitudinal slip",
		 "Longitudinal force (N)",
		 "Normal load = 1600N, zero camber"},

       fontscale = 3,   
       
       plotting.line {
	  color = plotting.colors[1],
	  style = plotting.styles[1],
	  unpack(F_x[1])
       },
       
       plotting.line {
	  color = plotting.colors[2],
	  style = plotting.styles[2],
	  unpack(F_x[2])
       },
       
       plotting.line {
	  color = plotting.colors[3],
	  style = plotting.styles[3],
	  unpack(F_x[3])
       },
       
       plotting.line {
	  color = plotting.colors[4],
	  style = plotting.styles[4],
	  unpack(F_x[4])
       },
       
       plotting.line {
	  color = plotting.colors[5],
	  style = plotting.styles[5],
	  unpack(F_x[5])
       },
    }

    network.mime['/motorcycle/lateral'] = "image/svg+xml"
    network.pages['/motorcycle/lateral'] =  plotting.cartesian {
       size = {600, 600},
       window = {-1, 1, -2500, 2500},
       background = {1, 1, 1},
       foreground = {0, 0, 0},

       grid = true,
       box = true,
       ticks = true,
       
       labels = {"Longitudinal slip",
		 "Lateral force (N)",
		 "Normal load = 1600N, zero camber"},

       fontscale = 3,
       
       plotting.line {
	  color = plotting.colors[1],
	  style = plotting.styles[1],
	  unpack(F_y[1])
       },
       
       plotting.line {
	  color = plotting.colors[2],
	  style = plotting.styles[2],
	  unpack(F_y[2])
       },
       
       plotting.line {
	  color = plotting.colors[3],
	  style = plotting.styles[3],
	  unpack(F_y[3])
       },
       
       plotting.line {
	  color = plotting.colors[4],
	  style = plotting.styles[4],
	  unpack(F_y[4])
       },
       
       plotting.line {
	  color = plotting.colors[5],
	  style = plotting.styles[5],
	  unpack(F_y[5])
       },
    }

    network.mime['/motorcycle/forces'] = "image/svg+xml"
    network.pages['/motorcycle/forces'] =  plotting.cartesian {
       size = {600, 600},
       window = {-2500, 2500, -2500, 1500},
       background = {1, 1, 1},
       foreground = {0, 0, 0},

       grid = true,
       box = true,
       ticks = true,
       
       labels = {"Longitudinal force (N)",
		 "Lateral force (N)",
		 "Normal load = 1600N, zero camber"},

       fontscale = 3,
       
       plotting.line {
	  color = plotting.colors[1],
	  style = plotting.styles[1],
	  unpack(F_xy[1])
       },
       
       plotting.line {
	  color = plotting.colors[2],
	  style = plotting.styles[2],
	  unpack(F_xy[2])
       },
       
       plotting.line {
	  color = plotting.colors[3],
	  style = plotting.styles[3],
	  unpack(F_xy[3])
       },
       
       plotting.line {
	  color = plotting.colors[4],
	  style = plotting.styles[4],
	  unpack(F_xy[4])
       },
       
       plotting.line {
	  color = plotting.colors[5],
	  style = plotting.styles[5],
	  unpack(F_xy[5])
       },
    }

    network.mime['/motorcycle/moment'] = "image/svg+xml"
    network.pages['/motorcycle/moment'] =  plotting.cartesian {
       size = {600, 600},
       window = {-1, 1, -30, 30},
       background = {1, 1, 1},
       foreground = {0, 0, 0},

       grid = true,
       box = true,
       ticks = true,
       
       labels = {"Longitudinal slip",
		 "Aligning moment (Nm)",
		 "Normal load = 1600N, zero camber"},

       fontscale = 3,
       
       plotting.line {
	  color = plotting.colors[1],
	  style = plotting.styles[1],
	  unpack(M_z[1])
       },
       
       plotting.line {
	  color = plotting.colors[2],
	  style = plotting.styles[2],
	  unpack(M_z[2])
       },
       
       plotting.line {
	  color = plotting.colors[3],
	  style = plotting.styles[3],
	  unpack(M_z[3])
       },
       
       plotting.line {
	  color = plotting.colors[4],
	  style = plotting.styles[4],
	  unpack(M_z[4])
       },
       
       plotting.line {
	  color = plotting.colors[5],
	  style = plotting.styles[5],
	  unpack(M_z[5])
       },
    }
  ?>

  <label for="list">Select plot:</label>
  <select id="list" onChange="javascript: document.getElementById('graph').src = '/motorcycle/' + this.options[this.selectedIndex].value">
     <option value="purelongitudinal"
             selected="selected">Pure slip longitudinal force</option>
     <option value="purelateral">Pure slip lateral force</option>
     <option value="puremoment" >Pure sideslip aligning moment</option>
     <option value="longitudinal">Combined slip longitudinal force</option>
     <option value="lateral">Combined slip lateral force</option>
     <option value="forces">Longitudinal-lateral force plot</option>
     <option value="moment">Combined slip aligning moment</option>
  </select>

  <br/>

  <img style="float:left" width="100%" type="image/svg+xml"
       id="graph" src="/motorcycle/purelongitudinal" />

  <?lua return fragments.beginconfiguration {onapply = "/motorcycle/tyre?wheel=" .. query.wheel,
					     onsave = "/motorcycle",
					     chunk = query.wheel .. "tyre"} ?>

  <table class="configuration">
    <tr><th colspan="2">General</th></tr>
    <tr><td>Tyre radius</td>
        <td><input pre="$ * 1000"
                   post="$ / 1000"
                   type="text"
                   name="blueprint.<?lua return query.wheel ?>radii"
	           value="<?lua return string.format ("%g", blueprint[query.wheel .. 'radii'][1]) ?>" /> mm</td>
    </tr>

    <tr><td>Crown radius</td>
        <td><input pre="$ * 1000"
                   post="$ / 1000"
                   type="text"
                   name="blueprint.<?lua return query.wheel ?>radii"
	           value="<?lua return string.format ("%g", blueprint[query.wheel .. 'radii'][2]) ?>" /> mm</td>
    </tr>

    <tr><td>Radial stiffness</td>
        <td><input type="text"
                   name="blueprint.<?lua return query.wheel ?>elasticity"
	           value="<?lua return string.format ("%g", blueprint[query.wheel .. 'elasticity'][1]) ?>" />
	<table class="fraction">
	  <tr><td>N</td></tr>
	  <tr><td>m</td></tr>
        </table></td>
    </tr>

    <tr><td>Radial damping</td>
        <td><input type="text"
                   name="blueprint.<?lua return query.wheel ?>elasticity"
	           value="<?lua return string.format ("%g", blueprint[query.wheel .. 'elasticity'][2]) ?>" />
	<table class="fraction">
	  <tr><td>Ns</td></tr>
	  <tr><td>m</td></tr>
        </table></td>
    </tr>

    <tr><td>Rolling resistance</td>
        <td><input type="text"
                   name="blueprint.<?lua return query.wheel ?>resistance"
	           value="<?lua return string.format ("%g", blueprint[query.wheel .. 'resistance']) ?>" /></td>
    </tr>
    <tr><td>Nominal load</td>
        <td><input type="text"
                   name="blueprint.<?lua return query.wheel ?>load"
	           value="<?lua return string.format ("%g", blueprint[query.wheel .. 'load']) ?>" /> N</td>
    </tr>

    <tr><td>Relaxation length</td>
        <td><?lua return string.format ([[
            <input type="text" name="blueprint.%srelaxation" value="%g" /> +
            <input type="text" name="blueprint.%srelaxation" value="%g" /> &middot V +
            <input type="text" name="blueprint.%srelaxation" value="%g" /> &middot V<sup>2</sup>, where V the vehicle speed.
]], query.wheel, blueprint[query.wheel .. 'relaxation'][1],
    query.wheel, blueprint[query.wheel .. 'relaxation'][2],
    query.wheel, blueprint[query.wheel .. 'relaxation'][3]) ?></td>
    </tr>

    <?lua
       local html = ""
       local keys = {
	  {  "Longitudinal force",
	     "longitudinal",
	     {"C_x", "p_Dx1", "p_Dx2", "p_Ex1",
	      "p_Ex3", "p_Ex4", "p_Kx1", "p_Kx2",
	      "p_Kx3", "r_Bx1", "r_Bx2", "C_xalpha"},
	  },

	  {
	     "Sideforce",
	     "lateral",
	     {"C_y", "p_Dy1", "p_Dy2", "p_Dy3",
	      "p_Ey1", "p_Ey2", "p_Ey4", "p_Ky1",
	      "p_Ky2", "p_Ky3", "p_Ky4", "p_Ky5",
	      "C_gamma", "p_Ky6", "p_Ky7", "E_gamma",
	      "r_By1", "r_By2", "r_By3", "C_ykappa"},
	  },

	  {
	     "Aligning moment",
	     "moment",
	     {"C_t", "q_Bz1", "q_Bz2", "q_Bz5", "q_Bz6", "q_Bz9",
	      "q_Bz10", "q_Dz1", "q_Dz2", "q_Dz3", "q_Dz4", "q_Dz8",
	      "q_Dz9", "q_Dz10", "q_Dz11", "q_Ez1", "q_Ez2", "q_Ez3",
	      "q_Ez5", "q_Hz3", "q_Hz4"}
	  }
       }

       for j = 1, #keys do
	  local title = keys[j][1]
	  local section = keys[j][2]
	  local parameters = keys[j][3]

	  html = html .. string.format([[
  </table>
  <table class="configuration">
    <tr><th colspan="8">%s</th></tr>
]], title)

          for k = 0, math.floor(#parameters / 4) do
	     html = html .. [[
    <tr>
]]

	     for i = 1, 4 do
		local ii = k * 4 + i
		if ii <= #parameters then
		   html = html .. string.format([[
      <td>%s</td><td><input type="text"
                              name="blueprint.%s%s"
	                      value="%g" /></td>
]], string.gsub(parameters[ii], "_(%w+)", "<sub>%1</sub>"), query.wheel,
    section, blueprint[query.wheel .. section][ii])
		end
	     end
	     html = html .. [[
    </tr>
]]

	  end
       end

       return html
     ?>
  </table>

  <table class="configuration">
    <tr><th colspan="4">Scaling factors</th></tr>
    <tr>
      <td>Peak longitudinal friction coefficient (&lambda;<sub>&mu;,x</sub>):</td>
      <td><input type="text"
		 name="blueprint.<?lua return query.wheel ?>scaling"
		 value="<?lua return string.format ("%g", blueprint[query.wheel .. 'scaling'][1]) ?>" /></td>

      <td>Peak lateral friction coefficient (&lambda;<sub>&mu;,y</sub>):</td>
      <td><input type="text"
		 name="blueprint.<?lua return query.wheel ?>scaling"
		 value="<?lua return string.format ("%g", blueprint[query.wheel .. 'scaling'][2]) ?>" /></td>
    </tr>

    <tr>
      <td>Brake slip stiffness (&lambda;<sub>Kx&kappa;</sub>):</td>
      <td><input type="text"
		 name="blueprint.<?lua return query.wheel ?>scaling"
		 value="<?lua return string.format ("%g", blueprint[query.wheel .. 'scaling'][3]) ?>" /></td>

      <td>Cornering stiffness (&lambda;<sub>Ky&alpha;</sub>):</td>
      <td><input type="text"
		 name="blueprint.<?lua return query.wheel ?>scaling"
		 value="<?lua return string.format ("%g", blueprint[query.wheel .. 'scaling'][4]) ?>" /></td>
    </tr>

    <tr>
      <td>Camber force stiffness (&lambda;<sub>Ky&gamma;</sub>):</td>
      <td><input type="text"
		 name="blueprint.<?lua return query.wheel ?>scaling"
		 value="<?lua return string.format ("%g", blueprint[query.wheel .. 'scaling'][5]) ?>" /></td>

      <td>Pneumatic trail (&lambda;<sub>t</sub>):</td>
      <td><input type="text"
		 name="blueprint.<?lua return query.wheel ?>scaling"
		 value="<?lua return string.format ("%g", blueprint[query.wheel .. 'scaling'][6]) ?>" /></td>    
    </tr>

    <tr>      
      <td>Camber torque stiffness (&lambda;<sub>Kz&gamma;</sub>):</td>
      <td><input type="text"
		 name="blueprint.<?lua return query.wheel ?>scaling"
		 value="<?lua return string.format ("%g", blueprint[query.wheel .. 'scaling'][7]) ?>" /></td>

      <td>Rolling resistance (&lambda;<sub>My</sub>):</td>
      <td><input type="text"
		 name="blueprint.<?lua return query.wheel ?>scaling"
		 value="<?lua return string.format ("%g", blueprint[query.wheel .. 'scaling'][8]) ?>" /></td>
    </tr>

    <tr>
      <td>Radial stiffness:</td>
      <td><input type="text"
		 name="blueprint.<?lua return query.wheel ?>scaling"
		 value="<?lua return string.format ("%g", blueprint[query.wheel .. 'scaling'][9]) ?>" /></td>

      <td>Radial damping:</td>
      <td><input type="text"
		 name="blueprint.<?lua return query.wheel ?>scaling"
		 value="<?lua return string.format ("%g", blueprint[query.wheel .. 'scaling'][10]) ?>" /></td>
    </tr>
  </table>

  <hr/>
  <?lua return fragments.endconfiguration {apply = true, save = true, export = true} ?>
  <hr/>
</body>
