<!--
Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
This program is free software: you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation, either version 3 of the License, or    
(at your option) any later version.                                  
                                                                     
This program is distributed in the hope that it will be useful,      
but WITHOUT ANY WARRANTY; without even the implied warranty of       
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
GNU General Public License for more details.                         
                                                                     
You should have received a copy of the GNU General Public License    
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>
  <title>Control</title>
  <link rel="stylesheet" href="/stylesheet" type="text/css">
</head>

<body>
  <?lua return fragments.logo ?>
  <?lua return fragments.motorcyclenavigation ?>

  <?lua return fragments.processconfiguration {model = "motorcycle",
					       prefix = "/motorcycle",
					       redirect = "/motorcycle"}
  ?>

  <p>You can configure the vehicle's control system here, mainly
  parameters that fine-tune the way user input through the mouse is
  converted into torques and forces on the steering system and control
  levers.</p>

  <?lua
     return fragments.beginconfiguration {onapply = "/motorcycle/control",
					  onsave = "/motorcycle",
					  chunk = "control"}
  ?>
  <table class="configuration">
    <tr><th colspan="2">General</th></tr>
    <tr><td>Rubberband anchor</td>
	<td>Biased 
            <input type="text"
                   pre="$ * 200 - 100"
                   post="($ + 100) / 200"
                   name="blueprint.anchor[1]"
	           value="<?lua return string.format ("%g", blueprint.anchor[1]) ?>" /> % horizontally and  
            <input type="text"
                   pre="-$ * 200 + 100"
                   post="-($ - 100) / 200"
                   name="blueprint.anchor[2]"
	           value="<?lua return string.format ("%g", blueprint.anchor[2]) ?>" /> % vertically from window center.
        </td>
    </tr>
  </table>

  <table class="configuration">
    <tr><th colspan="2">Steering</th></tr>
    <tr><td>Steering sensitivity</td>
         <td>
            (<input type="text"
                   name="blueprint.steeringsensitivity"
	           value="<?lua return string.format ("%g", blueprint.steeringsensitivity[1]) ?>" /> +
            <input type="text"
                   name="blueprint.steeringsensitivity"
	           value="<?lua return string.format ("%g", blueprint.steeringsensitivity[2]) ?>" /> V)  &middot (1 +
            <input type="text"
                   name="blueprint.steeringsensitivity"
	           value="<?lua return string.format ("%g", blueprint.steeringsensitivity[3]) ?>" /> &middot
           <table class="fraction">
             <tr><td>3&#952</td></tr>
	     <tr><td>&#960</td></tr>
           </table>)
	   <table class="fraction">
	     <tr><td>Nm</td></tr>
	     <tr><td>pixel</td></tr>
           </table>
           ,where V the speed and &#952 the chassis roll angle.
         </td>
    </tr>

    <tr><td>Steering lag</td>
        <td><input type="text"
                   name="blueprint.steeringlag"
	           value="<?lua return string.format ("%g", blueprint.steeringlag) ?>" /> s
        </td>
    </tr>

    <tr><td>Load control</td>
         <td>Attenuate input steering torque when front wheel load
	     drops below 
            <input type="text"
                   name="blueprint.loadregion"
	           value="<?lua return string.format ("%g", blueprint.loadregion[1]) ?>" /> N cutting off completely below 
            <input type="text"
                   name="blueprint.loadregion"
	           value="<?lua return string.format ("%g", blueprint.loadregion[2]) ?>" /> N.
         </td>
    </tr>

    <tr><td>Sideslip control</td>
         <td>Attenuate steering torque when front wheel sideslip angle
             tangent exceeds 
            <input type="text"
                   name="blueprint.sideslipregion"
	           value="<?lua return string.format ("%g", blueprint.sideslipregion[1]) ?>" /> cutting off completely above
            <input type="text"
                   name="blueprint.sideslipregion"
	           value="<?lua return string.format ("%g", blueprint.sideslipregion[2]) ?>" />.
         </td>
    </tr>
  </table>

  <table class="configuration">
    <tr><th colspan="2">Throttle</th></tr>
    <tr><td>Throttle sensitivity</td>
        <td><input type="text"
                   name="blueprint.throttlesensitivity"
	           value="<?lua return string.format ("%g", blueprint.throttlesensitivity) ?>" />
           <table class="fraction">
             <tr><td>1</td></tr>
	     <tr><td>pixel</td></tr>
           </table>
        </td>
    </tr>

    <tr><td>Throttle lag</td>
        <td><input type="text"
                   name="blueprint.throttlelag"
	           value="<?lua return string.format ("%g", blueprint.throttlelag) ?>" /> s</td>
    </tr>

    <tr><td>Engine speed limiter</td>
        <td>Threshold at
	  <input type="text"
		 name="blueprint.limiterthreshold"
		 value="<?lua return string.format ("%g", blueprint.limiterthreshold) ?>" /> rpm with a hysteresis of
	  <input type="text"
		 name="blueprint.limiterhysteresis"
		 value="<?lua return string.format ("%g", blueprint.limiterhysteresis) ?>" /> rpm.</td>
    </tr>
  </table>

  <table class="configuration">
    <tr><th colspan="2">Brakes</th></tr>
    <tr><td>Front brake sensitivity</td>
        <td><input type="text"
                   name="blueprint.frontbrakesensitivity"
	           value="<?lua return string.format ("%g", blueprint.frontbrakesensitivity) ?>" />
           <table class="fraction">
             <tr><td>Nm</td></tr>
	     <tr><td>pixel</td></tr>
           </table>
        </td>
    </tr>

    <tr><td>Front brake lag</td>
        <td><input type="text"
                   name="blueprint.frontbrakelag"
	           value="<?lua return string.format ("%g", blueprint.frontbrakelag) ?>" /> s</td>
    </tr>

    <tr><td>Rear brake sensitivity</td>
        <td><input type="text"
                   name="blueprint.rearbrakesensitivity"
	           value="<?lua return string.format ("%g", blueprint.rearbrakesensitivity) ?>" />
           <table class="fraction ">
             <tr><td>Nm</td></tr>
	     <tr><td>pixel</td></tr>
           </table>
        </td>
    </tr>

    <tr><td>Rear brake lag</td>
        <td><input type="text"
                   name="blueprint.rearbrakelag"
	           value="<?lua return string.format ("%g", blueprint.rearbrakelag) ?>" /> s</td>
    </tr>
  </table>

  <table class="configuration">
    <tr><th colspan="2">Rider</th></tr>
    <tr><td>Upper body roll restraint</td>
        <td><input type="text"
                   name="blueprint.riderroll"
	           value="<?lua return string.format ("%g", blueprint.riderroll[1]) ?>" />
           <table class="fraction">
             <tr><td>Nm</td></tr>
	     <tr><td>rad</td></tr>
           </table> stiffness and
        <input type="text"
		name="blueprint.riderroll"
		value="<?lua return string.format ("%g", blueprint.riderroll[2]) ?>" />
           <table class="fraction">
             <tr><td>Nms</td></tr>
	     <tr><td>rad</td></tr>
           </table> damping.
        </td>
    </tr>
    <tr><td>Upper body yaw restraint</td>
        <td><input type="text"
                   name="blueprint.rideryaw"
	           value="<?lua return string.format ("%g", blueprint.rideryaw[1]) ?>" />
           <table class="fraction">
             <tr><td>Nm</td></tr>
	     <tr><td>rad</td></tr>
           </table> stiffness and
        <input type="text"
		name="blueprint.rideryaw"
		value="<?lua return string.format ("%g", blueprint.rideryaw[2]) ?>" />
           <table class="fraction">
             <tr><td>Nms</td></tr>
	     <tr><td>rad</td></tr>
           </table> damping.
        </td>
    </tr>
    <tr><td>Upper body to front frame coupling</td>
        <td><input type="text"
                   name="blueprint.ridercoupling"
	           value="<?lua return string.format ("%g", blueprint.ridercoupling[1]) ?>" />
           <table class="fraction">
             <tr><td>N</td></tr>
	     <tr><td>m</td></tr>
           </table> stiffness and
        <input type="text"
		name="blueprint.ridercoupling"
		value="<?lua return string.format ("%g", blueprint.ridercoupling[2]) ?>" />
           <table class="fraction">
             <tr><td>Ns</td></tr>
	     <tr><td>m</td></tr>
           </table>.
        </td>
    </tr>
  </table>
  <hr/>
  <?lua return fragments.endconfiguration {apply = true, save = true, export = true} ?>
  <hr/>
</body>
