-- Copyright (C) 2010-2011 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

-- These are the magic formula parameters for a 180/55 rear
-- motorcycle tyre.  Model is taken from:
--    Advances in the Modelling of Motorcycle Dynamics
--    R.S. SHARP, S. EVANGELOU and D.J.N. LIMEBEER

blueprint.rearresistance = 0.02
blueprint.rearradii = {0.297 - 0.09, 0.09}
blueprint.rearelasticity = {141e3, 1500}
blueprint.rearload = 1600
blueprint.rearrelaxation = {9.694e-6, -1.333e-8, 1.898e-9}

blueprint.rearlongitudinal = {
      --              C_x     p_Dx1   p_Dx2      p_Ex1   p_Ex2
                      1.6064, 1.3548, -0.060295, 0.0263, 0.27056,
      --	      p_Ex3      p_Ex4   p_Kx1   p_Kx2    p_Kx3
   		      -0.076882, 1.1268, 25.939, -4.2327, 0.33686,
      --              p_Bx1   p_Bx2   C_xalpha
   	              13.476, 11.354, 1.1231}
  	    
blueprint.rearlateral = {
      --         C_y  p_Dy1 p_Dy2 p_Dy3 p_Ey1    p_Ey2   p_Ey4   p_Ky1
                 0.9, 1.3,  0,    0,    -2.2227, -1.669, -4.288, 15.791,
      --         p_Ky2   p_Ky3   p_Ky4  p_Ky5    C_gamma  p_Ky6  
   	         1.6935, 1.4604, 0.669, 0.18708, 0.61397, 0.45512,
      --         p_Ky7     E_gamma r_By1   r_By2   r_By3      C_ykappa
   	         0.013293, -19.99, 7.7856, 8.1697, -0.059138, 1.0533}
  
blueprint.rearmoment = {
      --        C_t     q_Bz1   q_Bz2       q_Bz5     q_Bz6    q_Bz9 
                1.3153, 10.041, -1.6065e-8, -0.76784, 0.73422, 16.39,
      --        q_Bz10    q_Dz1    q_Dz2     q_Dz3     q_Dz4    q_Dz8
   	        -0.35549, 0.26331, 0.030987, -0.62013, 0.98524, 0.50453,
      --        q_Dz9    q_Dz10    q_Dz11    q_Ez1     q_Ez2      q_Ez3
     	        0.36312, -0.19168, -0.40709, -0.19924, -0.017638, 0,
      --        q_Ez5   q_Hz3      q_Hz4
  	        3.6511, -0.028448, -0.0098618}
