<!--
Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
This program is free software: you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation, either version 3 of the License, or    
(at your option) any later version.                                  
                                                                     
This program is distributed in the hope that it will be useful,      
but WITHOUT ANY WARRANTY; without even the implied warranty of       
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
GNU General Public License for more details.                         
                                                                     
You should have received a copy of the GNU General Public License    
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>
  <title>Slipstream</title>
  <link rel="stylesheet" href="/stylesheet" type="text/css">
</head>

<body>
  <?lua return fragments.logo ?>
  <?lua return fragments.slipstreamnavigation ?>

  <?lua
     if query.chunk then
	return fragments.processconfiguration {model = query.chunk,
					       prefix = "/slipstream",
					       redirect = "/slipstream"}
     else
	return fragments.processconfiguration {prefix = "/slipstream",
					       redirect = "/slipstream"}
     end
  ?>

  <p>This is Slipstream the free vehicle simulator.</p>

  <?lua
     if graph.vehicle then
	return [[
  <p>You can edit the currently selected vehicle model by following
  the edit link next to the vehicle section header or load a different
  model through the tables below.</p>
]]
     else
	return [[
  <p>Use the tables below to load one of the available vehicle
     models.</p>
]]  
     end
  ?>

  <div class="section">Motorcycle<?lua return fragments.editloadedmodel {model = 'motorcycle'}?></div>
  <?lua return fragments.presets {chunk = "configuration",
				  action = "/slipstream",
				  prefix = "/slipstream/motorcycle/"} ?>

<?lua
if graph.vehicle then
   return [[
  <p>Select a track to race from the table below.</p>

  <div class="section">Tracks</div>
]] .. fragments.tracks {prefix = "/slipstream/tracks/road/"}
end
 ?>
</body>
