-- Copyright (C) 2010-2011 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local models = {
   {"/reartyre/tyre-180-55", "slipstream/tyres/motorcycle-180-55.lua",
    "Rear 180/55 motorcycle tyre"},
   {"/reartyre/tyre-160-70", "slipstream/tyres/motorcycle-160-70.lua",
    "Rear 160/70 motorcycle tyre"},
   {"/fronttyre/tyre-120-70", "slipstream/tyres/motorcycle-120-70.lua",
    "Front 120/70 motorcycle tyre"},
   {"/engine/engine-largesports",
    "slipstream/engines/motorcycle-largesports.lua",
    "Modern large displacement sports motorcycle engine"},
   {"/vehicle/vehicle-largesports",
    "slipstream/vehicles/motorcycle-largesports.lua",
    "Modern large displacement sports motorcycle vehicle"},
   {"/control/control-largesports",
    "slipstream/controls/motorcycle-largesports.lua",
    "Modern large displacement sports motorcycle control"},
}

for i = 1, #models do
   network.mime['/motorcycle' .. models[i][1]] = "text/html"
   network.pages['/motorcycle' .. models[i][1]] = [[
<?lua
resources.dofile "]] .. models[i][2] .. [["

graph.vehicle = resources.dofile "slipstream/motorcycle/model.lua"
?>

<head></head>
<body onload="javascript:window.location = '/motorcycle';"></body>
]]
   configurations.stock['/motorcycle' .. models[i][1]] = models[i][3]
end

-- The stock modern sports motorcycle

network.mime['/slipstream/motorcycle/modernsports'] = "text/html"
network.pages['/slipstream/motorcycle/modernsports'] = [[
<?lua

graph.vehicle = resources.dofile "slipstream/motorcycle/motorcycle-largesports.lua"
?>

<head></head>
<body onload="javascript:window.location = '/slipstream';"></body>
]]
configurations.stock['/slipstream/motorcycle/modernsports'] = "Modern large displacement sports motorcycle"
