/*
 *   $Id: ChannelPanel.cpp,v 1.3 2006/02/17 16:40:55 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qlayout.h>

#include "../Slag.h"
#include "../audio_engine/Channel.h"
#include "ChannelRow.h"
#include "ChannelMenu.h"
#include "ChannelPanel.h"

ChannelPanel::ChannelPanel(QWidget* parent, Slag* slag) 
    : RowSet(parent, slag->song()), slag(slag)
{}

QWidget* ChannelPanel::createRow(Channel* channel) {
    ChannelRow* channelRow = new ChannelRow(this, song, channel);

    connect(channelRow->channelMenu(), SIGNAL(channelRemoved(Channel*)), 
            slag,                      SLOT(deleteChannel(Channel*)));

    return channelRow;
}

void ChannelPanel::renameChannel(Channel* channel) {
    ChannelRow* row = (ChannelRow*) chan_row_map[channel];
    row->setName(channel->name());
}

//EOF
