/*
 *   $Id: LibaoWrapper.cpp,v 1.6 2006/02/22 04:05:49 rhizome Exp $
 *
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
//
// Wrapper C++ au dessus de libao <http://www.xiph.org/ao/>
//

#include <qobject.h>
#include <samplerate.h>
#include <math.h>
#include "LibaoWrapper.h"

LibaoWrapper::LibaoWrapper(const int bits, const int channels, 
	const int rate, const int byte_format) 
    : options(NULL)
{
    format.bits = bits;
    format.channels = channels;
    format.rate = rate;
    format.byte_format = byte_format;
    ao_initialize();
    ao_append_option(&options, "buffer_time", "70000");
    device = ao_open_live(ao_default_driver_id(), &format, options);
    if (device == NULL) {
	audio_IO::LibaoConnectionException e(
		"Impossible d'ouvrir l'interface de sortie audio avec libao.");
	throw(e);
    } else {
	qDebug("Libao audio output is open.");
    }
}

LibaoWrapper::~LibaoWrapper() {
    ao_close(device);
    ao_shutdown();
}

/// 
/// Fonction reprise et vaguement adpatee a partir de celle de libsamplerate
/// pour fonctionner avec des doubles.
/// Semble etre "fonctionnel" mais pas vraiment performant. En effet, les
/// doubles sont normalement plus performants que les floats car le C convertit
/// tout float en double en interne. Pourtant avec des doubles, a consomme
/// lgrement plus de CPU.
const int CPU_CLIPS_NEGATIVE = 1;
const int CPU_CLIPS_POSITIVE = 0;
void src_double_to_short_array (const double *in, short *out, int len) {
    
    double scaled_value ;

    while (len) {
	len -- ;

	scaled_value = in [len] * (8.0 * 0x10000000) ;
	if (CPU_CLIPS_POSITIVE == 0 && scaled_value >= (1.0 * 0x7FFFFFFF))
	{	out [len] = 32767 ;
	    continue ;
	} ;
	if (CPU_CLIPS_NEGATIVE == 0 && scaled_value <= (-8.0 * 0x10000000))
	{	out [len] = -32768 ;
	    continue ;
	} ;

	out [len] = ( (int) rintf (scaled_value) >> 16) ;
    };

} /* src_double_to_short_array */

void LibaoWrapper::play (sample_t* buffer, const int nb_frames)
{
    int buf_array_len = format.channels * nb_frames;

    short * short_buffer = new short[buf_array_len];

    // conversion sample_t => short
    src_sample_to_short_array(buffer, short_buffer, buf_array_len);

    ao_play(device, (char*)short_buffer, buf_array_len * sizeof(short));

    delete[] short_buffer;
}

//EOF
