/*
 *   $Id: ToolBar.cpp,v 1.19 2006/04/14 00:12:09 rhizome Exp $
 *
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <qmainwindow.h>
#include <qaction.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qhbuttongroup.h>
#include <qpushbutton.h>

#include "../audio_engine/Song.h"
#include "../Slag.h"
#include "ToolBar.h"

ToolBar::ToolBar(QMainWindow* parent, Slag* slag) 
    : QToolBar(parent), slag(slag), pattern_box(new QComboBox(this)) {
    setLabel(tr("Playback block"));

    // bouton "Play"
    QAction* play_action = new QAction(parent, "play" );
    play_action->setAccel( Qt::Key_Space );
    play_action->setIconSet( QPixmap::fromMimeSource("play.png") );
    connect(play_action, SIGNAL(activated()), slag,  SLOT(play()));
    play_action->addTo( this );

    // bouton "Stop"
    QAction* stop_action = new QAction(parent, "stop");
    stop_action->setAccel( Qt::Key_Space );
    stop_action->setIconSet( QPixmap::fromMimeSource("stop.png") );
    connect(stop_action, SIGNAL(activated()), slag, SLOT(stop()));
    stop_action->addTo( this );

    // Boite de choix de la pattern
    addSeparator();

    pattern_box->setMinimumWidth(100);
    connect(pattern_box, SIGNAL(activated(const QString &)), 
            slag,        SLOT(patternChange(const QString &)));

    // choix du mode de lecture : pattern ou song

    QHButtonGroup* mode_group = new QHButtonGroup(this);
    mode_group->setRadioButtonExclusive(true);
    mode_group->setLineWidth(0);
    mode_group->setInsideMargin(2);

    pattern_mode_radio = new QRadioButton(mode_group);
    pattern_mode_radio->setText(tr("Pattern"));
    connect(pattern_mode_radio, SIGNAL(clicked()), 
            slag,               SLOT(setPatternMode()));

    song_mode_radio = new QRadioButton(mode_group);
    song_mode_radio->setText(tr("Song"));
    connect(song_mode_radio, SIGNAL(clicked()), 
            slag,            SLOT(setSongMode()));

    QPushButton* loop_button = new QPushButton(tr("Loop"), this);
    loop_button->setToggleButton(true);
    loop_button->toggle();
    connect(loop_button, SIGNAL(toggled(bool)), 
            slag,        SLOT(setLoopMode(bool)));

    // Boite de rglage du tempo
    addSeparator();
    
    QLabel* tempo_label = new QLabel(this, "tempo");
    tempo_label->setText( tr( "<font size=\"-1\">BPM:</font>" ) );
    
    tempo_box = new QSpinBox(20, 500, 1, this);
    tempo_box->setValue(slag->song()->tempo());
    connect(tempo_box, SIGNAL(valueChanged(int)), slag, SLOT(setTempo(int)));

    // Boite de rglage du volume
    QLabel* vol_label = new QLabel(this, "volume");
    vol_label->setText( tr( "<font size=\"-1\">Vol:</font>" ) );
    
    vol_box = new QSpinBox(0, 100, 1, this);
    vol_box->setValue(slag->song()->getVolumePercent());
    connect(vol_box, SIGNAL(valueChanged(int)), 
            slag,    SLOT(setVolume(int)));
}

void ToolBar::sync() {
    pattern_box->clear();

    QStringList patternNames = slag->song()->patternNames();
    QStringList::Iterator end = patternNames.end();

    for (QStringList::Iterator it = patternNames.begin(); it != end; ++it) {
        pattern_box->insertItem(*it);
    }
    vol_box->setValue(slag->song()->getVolumePercent());
    tempo_box->setValue(slag->song()->tempo());
    if(slag->patternMode()) {
       pattern_mode_radio->setChecked(true); 
    } else {
       song_mode_radio->setChecked(true); 
    }
}

//EOF
