/* 
 *   $Id: MainWidget.h,v 1.34 2006/04/19 21:24:25 rhizome Exp $
 *
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef WIDGETS_H
#define WIDGETS_H

#include <qmainwindow.h> 
#include <qstring.h> 
#include <qlayout.h>
#include "../config/Config.h"

class QFileDialog;
class QProgressDialog;
class QWidgetStack;
class QAction;
class QLabel;
class QScrollView;

class Slag;
class Part;
class Channel;
class ToolBar;
class Channel;
class Pattern;
class SongPropertiesDialog;
class PreferencesDialog;
class TimeLine;
class ChannelPanel;

class MainWidget : public QMainWindow {
    Q_OBJECT

public:
    MainWidget(Slag* slag, QProgressDialog*);
    ~MainWidget();
    void songChanged(QProgressDialog*);
    void setModified(bool val) { modified = val; }
    void patternWidgetChange(const QString&);

protected:
    void closeEvent(QCloseEvent* event);
    void customEvent(QCustomEvent* event);

signals:
    void channelMovedUp(Channel*);
    void channelMovedDown(Channel*);
    void channelRename(Channel*);
    void partAdded(Part*);

public slots:
    void addChannel();
    void editPatternList();
    void deleteChannel(Channel*);
    void rewind();
    void exportWav();
    void addStackedWidget(Pattern*);
    void removeStackedWidget(Pattern*);

private slots:
    void newFile();
    void open();
    bool save();
    bool saveAs();
    void about();
    void openRecentFile(int param);
    void showSongProperties();
    void showPreferences();
    void songModified();
    void stopAndClose();

private:
    QMap<QString, QWidget*> pattern_widget_map;
    QWidget* containerWidget;
    QScrollView* scrollView;
    QHBoxLayout timeline_layout;
    TimeLine* timeline;
    QWidget* scrollWidget;
    QHBoxLayout* scrollWidgetLayout;
    QWidgetStack* stack;
    ChannelPanel* channel_panel;

    void createActions();
    QAction* createAnAction(
            const QString& label,
            const QString& shortCut,
            const QString& statusTip,
            const QString& connectionTarget,
            const QString& icon = NULL
            );
    void createMenus();
    void createToolBars();
    void createStatusBar();
    void buildStack(QProgressDialog*);
    void clearStack();
    void readSettings();
    void writeSettings();
    bool maybeSave();
    void updateRecentFileItems();
    void openSong(const QString&);
    bool overWriteFile(const QString&);

    SongPropertiesDialog* song_properties_dialog;
    PreferencesDialog* preferences_dialog;
    QFileDialog* slag_file_dialog;
    QFileDialog* wav_file_dialog;

    Slag* slag;
    QToolBar* file_toolbar;
    ToolBar* toolbar;
    bool modified;
    QStringList recentFiles;
    enum { MaxRecentFiles = 5 };
    int recentFileIds[MaxRecentFiles];
    QLabel* patternLabel;

    QPopupMenu *file_menu;
    QPopupMenu *edit_menu;
    QPopupMenu *options_menu;
    QPopupMenu *help_menu;

    /// Usual actions
    QAction *newAct;
    QAction *openAct;
    QAction *saveAct;
    QAction *saveAsAct;
    QAction *globalSettingsAct;
    QAction *aboutAct;
    QAction *aboutQtAct;
    QAction *exitAct;

    /// Specific actions
    QAction *songPropertiesAct;
    QAction *addChannelAct;
    QAction *editPatternListAct;
    QAction *exportWavAct;

    /// Status bar labels
    QLabel* modifLabel;

    bool openLastSong;
    Config* config;
};

#endif

//EOF
