/*
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef COMMON_H
#define COMMON_H

typedef unsigned int uint;

// decommenter cette ligne pour passer en double au lieu de float
//#define USE_DOUBLE
#ifdef USE_DOUBLE
typedef double				sample_t;
#define sf_readf_sample			sf_readf_double
#define src_sample_to_short_array	src_double_to_short_array
#else
typedef float				sample_t;
#define sf_readf_sample			sf_readf_float
#define src_sample_to_short_array	src_float_to_short_array
#endif

const int sample_size = sizeof(sample_t);

#endif
