/*
 *   $Id: Pattern.cpp,v 1.15 2006/03/27 02:25:35 rhizome Exp $
 * 
 *      Copyright (C) 2004, 2005, 2006 Alex Marandon
 *
 *  This file is part of slag, a pattern-based audio sequencer.
 *
 *  slag is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  slag is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with slag; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#include "Pattern.h"
#include "Part.h"
#include "Channel.h"

Pattern::Pattern(const QDomElement & dom_elem, NameChanMap & chan_map, 
        NamePartMap & part_map) 
    : _name(dom_elem.attribute("id").latin1())
{
    QDomNodeList channel_nodes = dom_elem.childNodes();
    // Associations des patterns avec leurs parts
    for (unsigned int i = 0; i < channel_nodes.length(); ++i) {
        QDomElement chan_elem = channel_nodes.item(i).toElement();

        // Testing than channels and parts exist (already declared in the XML)
        if (chan_map[chan_elem.attribute("ref")] == NULL) {
            continue;
        } else if (part_map[chan_elem.attribute("part")] == NULL) {
            qDebug(tr("Part with id \"%1\" not found.").arg(chan_elem.attribute("part")));
            continue;

        } else {
            channels_parts[chan_map[chan_elem.attribute("ref")]]
                = part_map[chan_elem.attribute("part")];
        }
    }
}

Pattern::~Pattern() {
    qDebug("Destruction Pattern " + _name);
}

QDomElement Pattern::getDom(QDomDocument& doc) {
    QDomElement dom_elem = doc.createElement("pattern");
    dom_elem.setAttribute("id", name());
    for (ChanPartMap::Iterator it = channels_parts.begin();
            it != channels_parts.end(); ++it) {
        QDomElement channel_elem = doc.createElement("channel");
        channel_elem.setAttribute("ref", it.key()->name());
        if (it.data() != NULL)
            channel_elem.setAttribute("part", it.data()->name());
        dom_elem.appendChild(channel_elem);

    }
    return dom_elem;
}

void Pattern::setPart(Channel* channel, Part* part) {
    channels_parts.replace(channel, part);
    emit modified();
}
