/*
   This file is part of Numerix.  Numerix is free software; you can
   redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA 
*/

/* +------------------------------------------------------------------------+
   |                                                                        |
   |                      Entiers de longueur arbitraire                    |
   |                                                                        |
   |                              Comparaisons                              |
   |                                                                        |
   +------------------------------------------------------------------------+ */

/* M. Quercia, 31/01/2001 */

#include "long_int.h"
#include "long_int-s.h"


  /* +----------------------------------------------------------+
     |  compare a et b, retourne la longueur algbrique de a-b  |
     +----------------------------------------------------------+ */

#ifndef have_sn_cmp
longueur xn(cmp)(naturel a, longueur la, naturel b, longueur lb) {
  longueur l;

  /* limine les zros de tte */
  while ((la) && (a[la-1] == 0)) la--;
  while ((lb) && (b[lb-1] == 0)) lb--;

  /* si les longeurs sont gales, compare les chiffres */
  if (la==lb) {
    for (l=la-1; (l>=0) && (a[l] == b[l]); l--);
    l++;
    if ((l) && (a[l-1] < b[l-1])) l = -l;
  }
  else {l = (la > lb) ? la : -lb;}

  return(l);
}
#endif

                      /* +------------------+
                         |  Compare a et b  |
                         +------------------+ */

#ifndef have_sz_cmp
long xz(cmp)(entier *a, entier *b) {
  longueur la = Lg(a), lb = Lg(b);
  longueur sa = Signe(a), sab = sa ^ Signe(b);
  zdouble s;
 
  if (sab) return((sa) ?  -1 : 1);
  s = xn(cmp)(a->val,la,b->val,lb);
  return ((s < 0) ? ((sa) ? 1 : -1) :
	  (s > 0) ? ((sa) ? -1 : 1) : 0);
}
#endif
