/*
   This file is part of Numerix.  Numerix is free software; you can
   redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA 
*/

/* +------------------------------------------------------------------------+
   |                                                                        |
   |                          Entiers de longueur arbitraire                |
   |                                                                        |
   |                             Interface C <-> Ocaml                      |
   |                                                                        |
   +------------------------------------------------------------------------+ */

/* M. Quercia, 23/08/2001 */

#ifndef __ml_long_int__
#define __ml_long_int__

#include "long_int.h"

#ifdef use_slong
#define W_of_C(l) (l)                 /* conversion chiffres -> mots      */
#define C_of_W(l) (l)                 /* conversion mots -> chiffres      */
#define xx(nom) sx_##nom              /* prfixe des fonctions publiques  */

#else
#ifdef use_dlong
#define W_of_C(l) (l)                 /* conversion chiffres -> mots      */
#define C_of_W(l) (l)                 /* conversion mots -> chiffres      */
#define xx(nom) dx_##nom              /* prfixe des fonctions publiques  */

#else
#define W_of_C(l) (((l)+1)/2)         /* conversion chiffres -> mots      */
#define C_of_W(l) (2*(l))             /* conversion mots -> chiffres      */
#define xx(nom) cx_##nom              /* prfixe des fonctions publiques  */
#endif
#endif


#endif

