/*
   This file is part of Numerix.  Numerix is free software; you can
   redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA 
*/

/* +------------------------------------------------------------------------+
   |                                                                        |
   |                      Entiers de longueur arbitraire                    |
   |                                                                        |
   |               Liste des fonctions implmentes en assembleur           |
   |                                                                        |
   +------------------------------------------------------------------------+ */


/* M. Quercia, 08/02/2001 */

#ifdef use_slong

/* addition/soustraction */
#define have_sn_add
#define have_sn_sub
#define have_sn_inc_1
#define have_sn_inc
#define have_sz_addsub
#define have_sn_dec_1
#define have_sn_dec

/* comparaison */
#define have_sn_cmp
#define have_sz_cmp

/* dcalage */
#define	have_sn_shr
#define	have_sn_shl
#define	have_sz_shift

/* multiplication */
#define	have_sn_mul_2
#define	have_sz_mul_2
#define	have_sn_mul_n2
#define	have_sz_mul_n2
#define have_sn_karamul

/* carr */
#define have_sn_sqr_n2
#define have_sn_karasqr
#define have_sn_sqr_k
#define have_sz_sqr_k

/* division */
#define	have_sn_quo_2
#define	have_sz_quo_2
#define	have_sn_quo_n2
#define have_sn_hquo
#define have_sz_quo_n2

/* FFT modulo base^n+1 */
#define have_sn_sc_add
#define have_sn_sc_sub
#define have_sn_sc_mul
#define have_sn_sc_shift

#endif
