#
#   This file is part of Numerix.  Numerix is free software; you can
#   redistribute it and/or modify it under the terms of the GNU General
#   Public License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful, but
#   WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
#   USA 
#
#! /bin/sh
# makefile.pascal: gnre les rgles de compilation de l'interface Pascal

# rpertoires
kcom="lib/common"
pascaldir="lib/pascal"

# bibliothques  produire
modules=""
if test x$USE_CLONG = x1; then modules="$modules c"; fi
if test x$USE_DLONG = x1; then modules="$modules d"; fi
if test x$USE_SLONG = x1; then modules="$modules s"; fi

cat <<EOF
#-------------- This part is generated from makefile.pascal ------------
# switches: USE_CLONG=$USE_CLONG USE_DLONG=$USE_DLONG USE_SLONG=$USE_SLONG
# switches: MAKE_PASCAL_LIB=$MAKE_PASCAL_LIB

.PHONY: pascal_lib pascal_install pascal_ex pascal_test pascal_clean

EOF
if (test x$MAKE_PASCAL_LIB = x1) && (test -n "$modules"); then

# compilation des modules
#------------------------
pnumx=""
for i in $modules; do
src=$pascaldir/${i}long.p
ppu=$pascaldir/${i}long.ppu
obj=$pascaldir/${i}long.o
pnumx="$pnumx $ppu $obj"
cat <<EOF
$src: $pascaldir/xlong.p
	MODULENAME=${i}long $pascaldir/xlong.p >$src
$ppu: $src
	\$(PPC) -FElib/pascal $src
EOF
done
echo "pascal_lib: $pnumx"
echo

# installation des modules
#-------------------------
cat <<EOF
pascal_install: $pnumx
	mkdir -p \$(INSTALL_LIB)
	cp -p $pnumx \$(INSTALL_LIB)

EOF

# compilation des exemples
#-------------------------
exemples="nextpp pi simple"
test=""
for i in $exemples; do
for j in $modules; do
src=exemples/$i/pascal/$i.p
prog=exemples/$i/pascal/$i-$j
test="$test $prog"
cat <<EOF
$prog: $pnumx $prog.p
	\$(PPC) -FEexemples/$i/pascal -Fu$pascaldir -Fl$kcom $prog.p
$prog.p: $src
	MODULENAME=${j}long $src > $prog.p
EOF
done
done
echo "pascal_ex: $test"
echo

# excution des tests
#--------------------
if test -n "$test"; then
cat <<EOF
pascal_test: $test
	@echo "--------------- tests for the Pascal interface"
	for i in $test; do echo \$\$i -test; \$\$i -test; done
	@echo "--------------- end of Pascal tests"
	@echo
EOF
else cat<<EOF
pascal_test:
EOF
fi
echo

# nettoyage
#----------
cat <<EOF
pascal_clean:
	rm $pascaldir/clong* $pascaldir/dlong* $pascaldir/slong* exemples/*/pascal/*-* 2>/dev/null || /bin/true

EOF

else
cat <<EOF
pascal_lib:
pascal_install:
pascal_ex:
pascal_test:
pascal_clean:
EOF
fi
cat <<EOF
#--------------------------- End of pascal part ------------------------

EOF
