(************************************************************************)
(* This file is part of SKS.  SKS is free software; you can
   redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA *)
(***********************************************************************)

open Db3
open Printf

(* let _ = popt (Some 8) 
   let _ = popt None     *)

(* let _ = Dbenv.sopen dbe "DBTEST" 
   [Dbenv.DB_CREATE ; Dbenv.DB_INIT_MPOOL] 0o777 *)

let db = Db.sopen "testdb" Db.BTREE [Db.CREATE] 0o777
let _ = 
  (try
     let rval = Db.get db "foobar" [] in
     printf "Result unexpectedly found: %s\n" rval
   with
       Not_found -> printf "Not_found\n");
  Db.put db ~key:"foo" ~data:"bar" [];
  let data = Db.get db "foo" [] in
  printf "key: %s, data: %s\n" "foo" data;
  Db.del db "foo";
  (try
     let rval = Db.get db "foobar" [] in
     printf "Result unexpectedly found: %s\n" rval
   with
       Not_found -> printf "Not_found\n")
  
  
