(************************************************************************)
(* This file is part of SKS.  SKS is free software; you can
   redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA *)
(***********************************************************************)

open StdLabels
open MoreLabels
open Printf

let fname = try Sys.argv.(1) with _ -> 
  eprintf "No file specified\n";
  exit (-1)

let file = open_in fname
let () = 
  try
    while true do
    let line = input_line file in
    let length = String.length line in
    if length >= 3 &&
      String.sub line ~pos:0 ~len:3 = "//+" 
    then
      if length = 3 then print_string "\n"
      else
	if line.[3] = ' ' then
	  printf "%s\n" (String.sub line ~pos:4 ~len:(length - 4))
	else 
	  printf "%s\n" (String.sub line ~pos:3 ~len:(length - 3))
      done
  with
      End_of_file -> ()
