/*
   This file is part of SKS.  SKS is free software; you can
   redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
   USA 
*/

#define Max_dballoc 1000000


struct camldbenv {
  final_fun f;
  DBENV *dbenv;
  int closed; 
}

#define Camldbenv_wosize \
  ((sizeof(struct camldbenv) + sizeof(value) - 1) / sizeof(value))

#define Camldbenv_dbenv(v) (((struct camldbenv *)(Bp_val(v)))->dbenv)
#define Camldbenv_closed(v) (((struct camldbenv *)(Bp_val(v)))->closed)

#define Is_string(v)   (Is_block(v) && (Tag_val(v) == String_tag))


/* A DB is a finalized value containing
 *  a pointer to the DB,
 *  a pointer to the openstruct
 *    (this could be removed if we were sure that the library doesn't keep
 *     a pointer to it !)
 */
struct camldb {
  final_fun f;
  DB *db;
  // BTREEINFO *info;
  int closed;
};


#define Camldb_wosize \
  ((sizeof(struct camldb) + sizeof(value) - 1) / sizeof(value))

#define Camldb_db(v) (((struct camldb *)(Bp_val(v)))->db)
#define Camldb_closed(v) (((struct camldb *)(Bp_val(v)))->closed)

#define Is_string(v)   (Is_block(v) && (Tag_val(v) == String_tag))
