#include "io2.h"

vectorTable:
	rjmp Reset
	rjmp INTERRUPT0     
	rjmp INTERRUPT1     
	rjmp INTERRUPT2     
	rjmp INTERRUPT3     
	rjmp INTERRUPT4     
	rjmp INTERRUPT5     
	rjmp INTERRUPT6     
	rjmp INTERRUPT7     
	rjmp OUTPUT_COMPARE2
	rjmp OVERFLOW2      
	rjmp INPUT_CAPTURE1 
	rjmp OUTPUT_COMPARE1A   
	rjmp OUTPUT_COMPARE1B   
	rjmp OVERFLOW1      
	rjmp OUTPUT_COMPARE0
	rjmp OVERFLOW0      
	rjmp SPI        
	rjmp UART0_RECV     
	rjmp UART0_DATA     
	rjmp UART0_TRANS    
	rjmp ADC        
	rjmp EEPROM_READY   
	rjmp COMPARATOR     
	rjmp OUTPUT_COMPARE1C   
	rjmp INPUT_CAPTURE3 
	rjmp OUTPUT_COMPARE3A   
	rjmp OUTPUT_COMPARE3B   
	rjmp OUTPUT_COMPARE3C   
	rjmp OVERFLOW3      
	rjmp UART1_RECV     
	rjmp UART1_DATA     
	rjmp UART1_TRANS    
	rjmp WIRE_SERIAL   
	rjmp SPM_READY      

INTERRUPT0:
   	ldi r31, 0x01
	reti
INTERRUPT1:
   	ldi r31, 0x02
	reti
INTERRUPT2:
   	ldi r31, 0x03
	reti
INTERRUPT3:
   	ldi r31, 0x04
	reti
INTERRUPT4:
   	ldi r31, 0x05
	reti
INTERRUPT5:
   	ldi r31, 0x06
	reti
INTERRUPT6:
   	ldi r31, 0x07
	reti
INTERRUPT7:
   	ldi r31, 0x08
	reti
OUTPUT_COMPARE2:
   	ldi r31, 0x09
	reti
OVERFLOW2:
   	ldi r31, 0x0a
	reti
INPUT_CAPTURE1:
   	ldi r31, 0x0b
	reti
OUTPUT_COMPARE1A:
   	ldi r31, 0x0c
	reti
OUTPUT_COMPARE1B:
   	ldi r31, 0x0d
	reti
OVERFLOW1:
   	ldi r31, 0x0e
	reti
OUTPUT_COMPARE0:
   	ldi r31, 0x0f
	reti
OVERFLOW0:
   	ldi r31, 0x10
	reti
SPI:
   	ldi r31, 0x11
	reti
UART0_RECV:
   	ldi r31, 0x12
	reti
UART0_DATA:
   	ldi r31, 0x13
	reti
UART0_TRANS:
   	ldi r31, 0x14
	reti
ADC:
   	ldi r31, 0x15
	reti
EEPROM_READY:
   	ldi r31, 0x16
	reti
COMPARATOR:
   	ldi r31, 0x17
	reti
OUTPUT_COMPARE1C:
   	ldi r31, 0x18
	reti
INPUT_CAPTURE3:
   	ldi r31, 0x19
	reti
OUTPUT_COMPARE3A:
   	ldi r31, 0x1a
	reti
OUTPUT_COMPARE3B:
   	ldi r31, 0x1b
	reti
OUTPUT_COMPARE3C:
   	ldi r31, 0x1c
	reti
OVERFLOW3:
   	ldi r31, 0x1d
	reti
UART1_RECV:
   	ldi r31, 0x1e
	reti
UART1_DATA:
   	ldi r31, 0x1f
	reti
UART1_TRANS:
   	ldi r31, 0x20
	reti
WIRE_SERIAL:
   	ldi r31, 0x21
	reti
SPM_READY:
	ldi r31, 0x22
	reti

Reset:
	ldi r16, lo8(RAMEND-6)
	out SPL, r16
	ldi r16, hi8(RAMEND-6)
	out SPH, r16
/*
	ldi r16, 0x00
	out OCR1AH, r16
	ldi r17, 0x30
	out OCR1AL, r17

	ldi r16, 0x08|0x01		//CTC|Clk1
	out TCCR1B, r16

	ldi r16, 1<<OCIE1A
	out TIMSK, r16
	*/


	ldi r16, 0x01
	out TCCR0, r16	//run with clk

	ldi r16, 0x01
	out TIMSK, r16

	sei

end: rjmp end




