
set traceFile trace

#we use some itcl :-)
package require Itcl

#load the avr-simulator package
load ../../src/simulavr.so
puts "simulavr loaded"

#now start external generic gui server 
exec wish ../../tests/gui.tcl &

#start the trace output to given filename
StartTrace $traceFile

#start the user interface client 
set ui [new_UserInterface 7777 ]

#create new device
set dev1 [new_AvrDevice_at90s4433]

#load elf file to the device 
AvrDevice_Load $dev1 "./ad"

#set the clock cycle time [ns]
AvrDevice_SetClockFreq $dev1 250

#systemclock must know that this device will be stepped from application
$systemClock Add $dev1

#also the gui updates after each cycle
$systemClock AddAsyncMember $ui


#create some external pins
ExtAnalogPin ad0 0 $ui "ad0" ".x"
ExtAnalogPin aref 0 $ui "aref" ".x"


#create some nets which connect the pins 
Net nad0
nad0 Add ad0
nad0 Add [AvrDevice_GetPin $dev1 "C0"]

Net naref
naref Add aref
naref Add [AvrDevice_GetPin $dev1 "Y0"]


#exec xterm -e tail -f $traceFile &

puts "Simulation runs endless, please press CTRL-C to abort"
#lets the simulation run until CTRL-C
SystemClock_Endless $systemClock
