/* show the reading & writing of eeprom memory space
 * also show working interrupts after eeprom write finished in
 * mega devices 
 *
 * Status: in work
 */

#include <avr/signal.h>
#include <avr/io.h>

#ifndef SIG_ADC 
#error No comperator interrupt defined
#endif

unsigned char irqCnt=0;
unsigned int value;

SIGNAL(SIG_ADC) {
    irqCnt++;
    value= ADCL;
    value|=ADCH<<8; //must be read after ADCL!!!!!

     ADCSR|=1<<ADSC;    //start next conversion
}

int main () {
    asm("sei");

    //setting prescaler for ad:
    ADCSR=(1<<ADPS2)|(1<<ADPS1); //64 prescaler

    ADCSR|=1<<ADEN; //enable the adc
    ADCSR|=1<<ADIE; //enable irq
    ADCSR|=1<<ADSC;    //start conversion 
}




